/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.j2ee.classpath.tests;

import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.StringBufferInputStream;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import junit.framework.Test;
import junit.framework.TestSuite;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jst.j2ee.classpath.tests.AbstractTests;
import org.eclipse.jst.j2ee.classpath.tests.util.ClasspathDependencyTestUtil;
import org.eclipse.jst.j2ee.classpathdep.UpdateClasspathAttributeUtil;
import org.eclipse.jst.j2ee.commonarchivecore.internal.EARFile;
import org.eclipse.jst.j2ee.commonarchivecore.internal.helpers.ArchiveManifestImpl;
import org.eclipse.jst.j2ee.commonarchivecore.internal.impl.ArchiveImpl;
import org.eclipse.jst.j2ee.componentcore.util.EARArtifactEdit;
import org.eclipse.jst.j2ee.dependency.tests.util.DependencyCreationUtil;
import org.eclipse.jst.j2ee.dependency.tests.util.ProjectUtil;
import org.eclipse.jst.j2ee.internal.deployables.J2EEFlexProjDeployable;
import org.eclipse.wst.common.componentcore.ComponentCore;
import org.eclipse.wst.common.componentcore.resources.IVirtualComponent;
import org.eclipse.wst.server.core.IModule;
import org.eclipse.wst.server.core.internal.ModuleFolder;
import org.eclipse.wst.server.core.model.IModuleFile;
import org.eclipse.wst.server.core.model.IModuleResource;
import org.eclipse.wst.server.core.util.ProjectModule;

public class ClasspathDependencyEARTests
extends AbstractTests {
    private static final String UTIL_PROJECT = "TestUtil";
    private static final String WEB_PROJECT = "TestWeb";
    private static final String EAR_PROJECT = "TestEAR";

    private ClasspathDependencyEARTests(String name) {
        super(name);
    }

    public static Test suite() {
        TestSuite suite = new TestSuite();
        suite.setName("Classpath Dependency EAR Tests");
        suite.addTest((Test)new ClasspathDependencyEARTests("testEARExportJ2EE"));
        suite.addTest((Test)new ClasspathDependencyEARTests("testEARPublishJ2EE"));
        suite.addTest((Test)new ClasspathDependencyEARTests("testEARPublishJEE5"));
        return suite;
    }

    public void testEARExportJ2EE() throws Exception {
        this.testEARExport(false);
    }

    public void testEARExportJEE5() throws Exception {
        this.testEARExport(true);
    }

    private void testEARExport(boolean JEE5) throws Exception {
        this.createProjects(JEE5);
        IProject earProject = ProjectUtil.getProject(EAR_PROJECT);
        IVirtualComponent earComp = ComponentCore.createComponent((IProject)earProject);
        HashSet<String> archiveNames = new HashSet<String>();
        archiveNames.add("Test1.jar");
        archiveNames.add("Test2.jar");
        this.verifyExportedEAR(earComp, archiveNames, false);
        this.addDependencyAttribute();
        this.verifyExportedEAR(earComp, archiveNames, true);
    }

    private void verifyExportedEAR(IVirtualComponent comp, Set archiveNames, boolean shouldHaveDependencies) throws Exception {
        EARArtifactEdit earEdit = null;
        EARFile earFile = null;
        try {
            earEdit = EARArtifactEdit.getEARArtifactEditForRead((IVirtualComponent)comp);
            if (earEdit != null) {
                earFile = (EARFile)earEdit.asArchive(true);
                List archives = earFile.getArchiveFiles();
                Iterator it = archiveNames.iterator();
                while (it.hasNext()) {
                    String name = (String)it.next();
                    boolean hasArchive = false;
                    int i = 0;
                    while (i < archives.size()) {
                        org.eclipse.jst.j2ee.commonarchivecore.internal.File archive = (org.eclipse.jst.j2ee.commonarchivecore.internal.File)archives.get(i);
                        if (archive.isArchive() && archive.getName().equals(name)) {
                            hasArchive = true;
                        }
                        ++i;
                    }
                    if (shouldHaveDependencies) {
                        ClasspathDependencyEARTests.assertTrue((String)("Exported EAR missing classpath dependency Jar " + name), (boolean)hasArchive);
                        continue;
                    }
                    ClasspathDependencyEARTests.assertFalse((String)("Exported EAR has unexpected classpath dependency Jar " + name), (boolean)hasArchive);
                }
                int i = 0;
                while (i < archives.size()) {
                    org.eclipse.jst.j2ee.commonarchivecore.internal.File archive = (org.eclipse.jst.j2ee.commonarchivecore.internal.File)archives.get(i);
                    if (archive.isArchive() && archive.getName().equals("TestUtil.jar")) {
                        ArchiveImpl archiveImpl = (ArchiveImpl)archive;
                        String[] cp = archiveImpl.getManifest().getClassPathTokenized();
                        while (it.hasNext()) {
                            String name = (String)it.next();
                            boolean isOnCP = false;
                            int j = 0;
                            while (j < cp.length) {
                                if (cp[j].equals(name)) {
                                    isOnCP = true;
                                }
                                ++j;
                            }
                            if (shouldHaveDependencies) {
                                ClasspathDependencyEARTests.assertTrue((String)("Exported utility project MANIFEST.MF classpath in exported EAR is entry for dependency Jar " + name), (boolean)isOnCP);
                                continue;
                            }
                            ClasspathDependencyEARTests.assertFalse((String)("Exported utility project MANIFEST.MF classpath in exported EAR has unexpected entry for dependency Jar " + name), (boolean)isOnCP);
                        }
                        archiveImpl.getFiles();
                        boolean hasTestFile = archiveImpl.containsFile("test");
                        if (shouldHaveDependencies) {
                            ClasspathDependencyEARTests.assertTrue((String)"Exported utility project missing file from published/exported class folder", (boolean)hasTestFile);
                        } else {
                            ClasspathDependencyEARTests.assertFalse((String)"Exported utility project has unexpected entry for file from non-published/exported class folder", (boolean)hasTestFile);
                        }
                    } else if (archive.isArchive() && archive.getName().equals("TestWeb.war")) {
                        ArchiveImpl archiveImpl = (ArchiveImpl)archive;
                        archiveImpl.getFiles();
                        boolean hasTestFile = archiveImpl.containsFile("WEB-INF/classes/test");
                        if (shouldHaveDependencies) {
                            ClasspathDependencyEARTests.assertTrue((String)"Exported web project missing file from published/exported class folder", (boolean)hasTestFile);
                        } else {
                            ClasspathDependencyEARTests.assertFalse((String)"Exported web project has unexpected entry for file from non-published/exported class folder", (boolean)hasTestFile);
                        }
                    }
                    ++i;
                }
            }
        }
        finally {
            if (earEdit != null) {
                earEdit.dispose();
            }
            if (earFile != null) {
                earFile.close();
            }
        }
    }

    public void testEARPublishJ2EE() throws Exception {
        this.testEARPublish(false);
    }

    public void testEARPublishJEE5() throws Exception {
        this.testEARPublish(true);
    }

    private void testEARPublish(boolean JEE5) throws Exception {
        this.createProjects(JEE5);
        IProject earProject = ProjectUtil.getProject(EAR_PROJECT);
        IVirtualComponent earComp = ComponentCore.createComponent((IProject)earProject);
        HashSet<String> archiveNames = new HashSet<String>();
        archiveNames.add("Test1.jar");
        archiveNames.add("Test2.jar");
        this.verifyPublishedEAR(earComp, archiveNames, false);
        this.addDependencyAttribute();
        this.verifyPublishedEAR(earComp, archiveNames, true);
    }

    private void verifyPublishedEAR(IVirtualComponent comp, Set archiveNames, boolean shouldHaveDependencies) throws Exception {
        J2EEFlexProjDeployable deployable = new J2EEFlexProjDeployable(comp.getProject(), comp);
        try {
            String name;
            IModuleResource[] members = deployable.members();
            for (String name2 : archiveNames) {
                boolean hasArchive = false;
                int i = 0;
                while (i < members.length) {
                    if (members[i].getName().equals(name2)) {
                        hasArchive = true;
                    }
                    ++i;
                }
                if (shouldHaveDependencies) {
                    ClasspathDependencyEARTests.assertTrue((String)("Published EAR missing classpath dependency Jar " + name2), (boolean)hasArchive);
                    continue;
                }
                ClasspathDependencyEARTests.assertFalse((String)("Published EAR has unexpected classpath dependency Jar " + name2), (boolean)hasArchive);
            }
            IModule utilModule = null;
            IModule webModule = null;
            IModule[] childModules = deployable.getChildModules();
            int i = 0;
            while (i < childModules.length) {
                if (childModules[i].getName().equals(UTIL_PROJECT)) {
                    utilModule = childModules[i];
                } else if (childModules[i].getName().equals(WEB_PROJECT)) {
                    webModule = childModules[i];
                }
                ++i;
            }
            ClasspathDependencyEARTests.assertNotNull((String)"Missing entry for utility project", utilModule);
            J2EEFlexProjDeployable projectModule = (J2EEFlexProjDeployable)utilModule.loadAdapter(ProjectModule.class, null);
            IModuleResource[] moduleMembers = projectModule.members();
            ArchiveManifestImpl manifest = null;
            boolean foundMetaInf = false;
            boolean foundTest = false;
            int i2 = 0;
            while (i2 < moduleMembers.length) {
                name = moduleMembers[i2].getName();
                if (name.equals("META-INF")) {
                    foundMetaInf = true;
                    IModuleResource manifestResource = ((ModuleFolder)moduleMembers[i2]).members()[0];
                    ClasspathDependencyEARTests.assertTrue((boolean)manifestResource.getModuleRelativePath().toString().equals("META-INF"));
                    ClasspathDependencyEARTests.assertTrue((String)("Expected MANIFEST.MF, got " + manifestResource.getName()), (boolean)manifestResource.getName().equals("MANIFEST.MF"));
                    File manifestFile = (File)manifestResource.getAdapter(File.class);
                    if (manifestFile == null) {
                        manifestFile = ((IFile)manifestResource.getAdapter(IFile.class)).getLocation().toFile();
                    }
                    ClasspathDependencyEARTests.assertNotNull((Object)manifestFile);
                    FileInputStream fis = null;
                    try {
                        fis = new FileInputStream(manifestFile);
                        manifest = new ArchiveManifestImpl((InputStream)fis);
                    }
                    finally {
                        if (fis != null) {
                            fis.close();
                        }
                    }
                } else if (name.equals("test") && moduleMembers[i2] instanceof IModuleFile) {
                    foundTest = true;
                }
                ++i2;
            }
            if (!foundMetaInf) {
                ClasspathDependencyEARTests.assertTrue((String)"members() failed to return META-INF for utility project module in published EAR", (boolean)foundMetaInf);
            }
            if (shouldHaveDependencies) {
                ClasspathDependencyEARTests.assertTrue((String)"Published utility project missing file from published/exported class folder", (boolean)foundTest);
            } else {
                ClasspathDependencyEARTests.assertFalse((String)"Published utility project has unexpected entry for file from non-published/exported class folder", (boolean)foundTest);
            }
            ClasspathDependencyEARTests.assertNotNull((String)"Failed to retrieve MANIFEST.MF from utility project module in published EAR", manifest);
            for (String name3 : archiveNames) {
                boolean isOnCP = false;
                String[] cp = manifest.getClassPathTokenized();
                int j = 0;
                while (j < cp.length) {
                    if (cp[j].equals(name3)) {
                        isOnCP = true;
                    }
                    ++j;
                }
                if (shouldHaveDependencies) {
                    ClasspathDependencyEARTests.assertTrue((String)("Utility project MANIFEST.MF classpath in published EAR missing entry for dependency Jar " + name3), (boolean)isOnCP);
                    continue;
                }
                ClasspathDependencyEARTests.assertFalse((String)("Utility project MANIFEST.MF classpath in published EAR has unexpected entry for dependency Jar " + name3), (boolean)isOnCP);
            }
            ClasspathDependencyEARTests.assertNotNull((String)"Missing entry for web project", (Object)webModule);
            projectModule = (J2EEFlexProjDeployable)webModule.loadAdapter(ProjectModule.class, null);
            moduleMembers = projectModule.members();
            foundTest = false;
            i = 0;
            while (i < moduleMembers.length) {
                name = moduleMembers[i].getName();
                if (name.equals("test") && moduleMembers[i].getModuleRelativePath().equals((Object)new Path("WEB-INF/classes")) && moduleMembers[i] instanceof IModuleFile) {
                    foundTest = true;
                }
                ++i;
            }
            if (shouldHaveDependencies) {
                ClasspathDependencyEARTests.assertTrue((String)"Exported web project does not contain class folder file in WEB-INF/classes", (boolean)foundTest);
            } else {
                ClasspathDependencyEARTests.assertFalse((String)"Exported Web project should not class folder file in WEB-INF/classes", (boolean)foundTest);
            }
        }
        catch (CoreException e) {
            e.printStackTrace();
            ClasspathDependencyEARTests.fail((String)e.getMessage());
        }
    }

    private IVirtualComponent createProjects(boolean JEE5) throws Exception {
        int version = 25;
        if (!JEE5) {
            version = 24;
        }
        IProject webProject = ProjectUtil.createWebProject(WEB_PROJECT, EAR_PROJECT, version, true);
        IJavaProject webJavaProject = JavaCore.create((IProject)webProject);
        IVirtualComponent webComp = ComponentCore.createComponent((IProject)webProject);
        Path binPath = new Path("bin");
        IFolder webBin = webProject.getFolder((IPath)binPath);
        webBin.create(true, true, null);
        webBin.getFile("test").create((InputStream)new StringBufferInputStream("blah"), true, null);
        ClasspathDependencyTestUtil.addLibraryEntry(webJavaProject, webBin.getFullPath(), true);
        IProject util = ProjectUtil.createUtilityProject(UTIL_PROJECT, EAR_PROJECT, true);
        util.getFolder("build").getFolder("classes");
        IJavaProject utilJava = JavaCore.create((IProject)util);
        IFolder utilBin = util.getFolder((IPath)binPath);
        utilBin.create(true, true, null);
        utilBin.getFile("test").create((InputStream)new StringBufferInputStream("blah"), true, null);
        ComponentCore.createComponent((IProject)util);
        ClasspathDependencyTestUtil.addLibraryEntry(utilJava, utilBin.getFullPath(), true);
        DependencyCreationUtil.createModuleDependency(webProject, util);
        ClasspathDependencyTestUtil.addCustomClasspathContainer(utilJava);
        return webComp;
    }

    private void addDependencyAttribute() throws Exception {
        IProject util = ProjectUtil.getProject(UTIL_PROJECT);
        IPath fullUtilBinPath = util.getFullPath().append("bin");
        IJavaProject utilJava = JavaCore.create((IProject)util);
        IVirtualComponent utilComp = ComponentCore.createComponent((IProject)util);
        IProject web = ProjectUtil.getProject(WEB_PROJECT);
        IJavaProject webJava = JavaCore.create((IProject)web);
        IPath fullWebBinPath = web.getFullPath().append("bin");
        IVirtualComponent webComp = ComponentCore.createComponent((IProject)web);
        HashSet<IPath> entryPaths = new HashSet<IPath>();
        entryPaths.add(ClasspathDependencyTestUtil.CUSTOM_CLASSPATH_CONTAINER);
        entryPaths.add(fullUtilBinPath);
        List entries = ClasspathDependencyTestUtil.verifyPotentialClasspathEntries(utilJava, entryPaths);
        ClasspathDependencyTestUtil.verifyNoClasspathAttributes(utilJava);
        ClasspathDependencyTestUtil.verifyNoClasspathDependencies(utilComp);
        IClasspathEntry entry = (IClasspathEntry)entries.get(0);
        for (Object o : entries) {
            UpdateClasspathAttributeUtil.addDependencyAttribute(null, (String)util.getName(), (IClasspathEntry)((IClasspathEntry)o));
        }
        ClasspathDependencyTestUtil.verifyNoPotentialClasspathEntries(utilJava);
        ClasspathDependencyTestUtil.verifyClasspathAttributes(utilJava, entryPaths);
        HashSet<String> archiveNames = new HashSet<String>();
        archiveNames.add("Test1.jar");
        archiveNames.add("Test2.jar");
        archiveNames.add(fullUtilBinPath.toString());
        ClasspathDependencyTestUtil.verifyClasspathDependencies(utilComp, archiveNames);
        entryPaths.clear();
        entryPaths.add(fullWebBinPath);
        entries = ClasspathDependencyTestUtil.verifyPotentialClasspathEntries(webJava, entryPaths);
        ClasspathDependencyTestUtil.verifyNoClasspathAttributes(webJava);
        ClasspathDependencyTestUtil.verifyNoClasspathDependencies(webComp);
        entry = (IClasspathEntry)entries.get(0);
        UpdateClasspathAttributeUtil.addDependencyAttribute(null, (String)web.getName(), (IClasspathEntry)entry);
        ClasspathDependencyTestUtil.verifyNoPotentialClasspathEntries(webJava);
        ClasspathDependencyTestUtil.verifyClasspathAttributes(webJava, entryPaths);
        archiveNames.clear();
        archiveNames.add(fullWebBinPath.toString());
        ClasspathDependencyTestUtil.verifyClasspathDependencies(webComp, archiveNames);
    }
}

