/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.jsf.common.util;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.Signature;
import org.eclipse.jst.jsf.common.JSFCommonPlugin;
import org.eclipse.jst.jsf.common.util.TypeUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JDTBeanProperty {
    private IMethod _getter;
    private IMethod _setter;
    protected final IType _type;

    protected JDTBeanProperty(IType type) {
        this._type = type;
    }

    public boolean isReadable() {
        return this._getter != null;
    }

    public boolean isWritable() {
        return this._setter != null;
    }

    public IMethod getGetter() {
        return this._getter;
    }

    void setGetter(IMethod getter) {
        this._getter = getter;
    }

    public IMethod getSetter() {
        return this._setter;
    }

    void setSetter(IMethod setter) {
        this._setter = setter;
    }

    public IType getType() {
        String typeSignature = Signature.getElementType((String)this.getTypeSignature());
        return TypeUtil.resolveType(this._type, typeSignature);
    }

    public int getArrayCount() {
        String sig = this.getTypeSignature();
        if (sig == null) {
            return 0;
        }
        return Signature.getArrayCount((String)sig);
    }

    public boolean isEnumType() {
        return TypeUtil.isEnumType(this.getType());
    }

    public String getTypeSignature() {
        return this.getTypeSignature(true);
    }

    public String getTypeSignature(boolean eraseTypeParameters) {
        try {
            String unResolvedSig = this.getUnresolvedType();
            return TypeUtil.resolveTypeSignature(this._type, unResolvedSig, eraseTypeParameters);
        }
        catch (JavaModelException jme) {
            JSFCommonPlugin.log((Exception)((Object)jme), "Error resolving bean property type signature");
            return null;
        }
    }

    public List<String> getTypeParameterSignatures() {
        ArrayList<String> signatures = new ArrayList<String>();
        try {
            String[] typeParameters;
            String[] stringArray = typeParameters = Signature.getTypeArguments((String)this.getUnresolvedType());
            int n = typeParameters.length;
            int n2 = 0;
            while (n2 < n) {
                String parameter = stringArray[n2];
                signatures.add(TypeUtil.resolveTypeSignature(this._type, parameter, false));
                ++n2;
            }
        }
        catch (JavaModelException jme) {
            JSFCommonPlugin.log((Exception)((Object)jme), "Error resolving bean property type signature");
        }
        return signatures;
    }

    private String getUnresolvedType() throws JavaModelException {
        String typeSig = null;
        typeSig = this._getter != null ? this._getter.getReturnType() : this._setter.getParameterTypes()[0];
        return typeSig;
    }
}

