/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wtp.j2ee.headless.tests.j2ee.verifiers;

import junit.framework.Assert;
import org.eclipse.core.resources.IProject;
import org.eclipse.jem.util.emf.workbench.ProjectUtilities;
import org.eclipse.wst.common.frameworks.datamodel.IDataModel;
import org.eclipse.wtp.j2ee.headless.tests.j2ee.verifiers.JEEProjectCreationDataModelVerifier;

public abstract class ModuleProjectCreationDataModelVerifier
extends JEEProjectCreationDataModelVerifier {
    public void verify(IDataModel model) throws Exception {
        super.verify(model);
        this.verifyProjectAddToEAR();
    }

    private void verifyProjectAddToEAR() throws Exception {
        boolean addToEAR = this.model.getBooleanProperty("IJ2EEFacetProjectCreationDataModelProperties.ADD_TO_EAR");
        if (addToEAR) {
            String earName = this.model.getStringProperty("IJ2EEFacetProjectCreationDataModelProperties.EAR_PROJECT_NAME");
            IProject ear = ProjectUtilities.getProject((String)earName);
            Assert.assertTrue((String)"The EAR should exist", (boolean)ear.exists());
            IProject[] referencedProjs = ear.getReferencedProjects();
            boolean foundRef = false;
            int i = 0;
            while (i < referencedProjs.length && !foundRef) {
                foundRef = referencedProjs[i].getName().equals(this.project.getName());
                ++i;
            }
            Assert.assertTrue((String)"EAR did not have a reference to the project", (boolean)foundRef);
        }
    }
}

