/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.jee.model.web.tests;

import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jst.j2ee.dependency.tests.util.ProjectUtil;
import org.eclipse.jst.j2ee.model.IModelProvider;
import org.eclipse.jst.j2ee.model.IModelProviderListener;
import org.eclipse.jst.j2ee.model.ModelProviderManager;
import org.eclipse.jst.javaee.web.WebApp;
import org.eclipse.jst.jee.model.tests.AbstractTest;
import org.eclipse.jst.jee.model.tests.SynchronousModelChangedListener;
import org.eclipse.wst.common.project.facet.core.IFacetedProject;
import org.eclipse.wst.common.project.facet.core.ProjectFacetsManager;

public class DeleteWebProjectTest
extends TestCase {
    public static Test suite() {
        TestSuite suite = new TestSuite(DeleteWebProjectTest.class);
        return suite;
    }

    private static void createProjectContent(IFacetedProject facetedProject) throws Exception {
        IJavaProject javaProject = JavaCore.create((IProject)facetedProject.getProject());
        IFolder srcFolder = javaProject.getProject().getFolder("src");
        if (!srcFolder.exists()) {
            srcFolder.create(true, true, (IProgressMonitor)new NullProgressMonitor());
        }
        IFolder comFolder = javaProject.getProject().getFolder("src/com");
        comFolder.create(true, true, (IProgressMonitor)new NullProgressMonitor());
        IPackageFragmentRoot root = javaProject.getPackageFragmentRoot((IResource)comFolder);
        IPackageFragment fragment = root.createPackageFragment("sap", true, (IProgressMonitor)new NullProgressMonitor());
        DeleteWebProjectTest.createServlet(fragment);
        DeleteWebProjectTest.createServletWithSecurity(fragment);
    }

    private static void createServlet(IPackageFragment fragment) throws Exception {
        IFile file = ((IContainer)fragment.getResource()).getFile((IPath)new Path("Servlet1.java"));
        AbstractTest.saveFile(file, "package com.sap;import javax.annotation.Resource;import javax.ejb.EJB;import javax.servlet.http.HttpServlet;public class Servlet1 extends HttpServlet {private static final long serialVersionUID = 1L;@EJB private Comparable comp; @EJB public void setComparable(Comparable comp){};@Resource private Comparable comp2; @Resource public void setComparable2(Comparable comp){} }");
    }

    private static void createServletWithSecurity(IPackageFragment fragment) throws Exception {
        IFile file = ((IContainer)fragment.getResource()).getFile((IPath)new Path("ServletWithSecurity.java"));
        AbstractTest.saveFile(file, "package com.sap;import javax.servlet.http.HttpServlet;@DeclareRoles(value = {\"role1\", \"role2\"})  public class ServletWithSecurity extends HttpServlet {}");
    }

    public void testDeleteProjectSameProvider() throws Exception {
        IProject project = ProjectUtil.createWebProject(String.valueOf(DeleteWebProjectTest.class.getSimpleName()) + "testDeleteProjectSameProvider", null, 25, true);
        IFacetedProject facetedProject = ProjectFacetsManager.create((IProject)project);
        DeleteWebProjectTest.createProjectContent(facetedProject);
        IModelProvider provider = ModelProviderManager.getModelProvider((IProject)facetedProject.getProject());
        WebApp firstModel = (WebApp)provider.getModelObject();
        DeleteWebProjectTest.assertNotNull((Object)firstModel);
        DeleteWebProjectTest.assertEquals((Object)firstModel, (Object)provider.getModelObject());
        SynchronousModelChangedListener listener = new SynchronousModelChangedListener(1);
        provider.addListener((IModelProviderListener)listener);
        AbstractTest.deleteProject(facetedProject.getProject().getName());
        DeleteWebProjectTest.assertTrue((boolean)listener.waitForEvents());
        provider.removeListener((IModelProviderListener)listener);
        try {
            provider.getModelObject();
            DeleteWebProjectTest.fail((String)"IllegalStateException expected because the project is deleted and can not be accessed.");
        }
        catch (IllegalStateException illegalStateException) {}
    }

    public void testProviderForNonExistingProject() {
        try {
            IProject nonExistingProject = ResourcesPlugin.getWorkspace().getRoot().getProject("testProviderForNonExistingProject");
            DeleteWebProjectTest.assertFalse((boolean)nonExistingProject.exists());
            ModelProviderManager.getModelProvider((IProject)nonExistingProject);
            DeleteWebProjectTest.fail((String)"IllegalArgumentException expected");
        }
        catch (IllegalArgumentException illegalArgumentException) {}
    }

    public void testCloseProjectSameProvider() throws Exception {
        IFacetedProject facetedProject = AbstractTest.createWebProject(String.valueOf(DeleteWebProjectTest.class.getSimpleName()) + "testClose");
        DeleteWebProjectTest.createProjectContent(facetedProject);
        IModelProvider provider = ModelProviderManager.getModelProvider((IProject)facetedProject.getProject());
        WebApp firstModel = (WebApp)provider.getModelObject();
        DeleteWebProjectTest.assertNotNull((Object)firstModel);
        DeleteWebProjectTest.assertEquals((Object)firstModel, (Object)provider.getModelObject());
        SynchronousModelChangedListener listener = new SynchronousModelChangedListener(1);
        provider.addListener((IModelProviderListener)listener);
        AbstractTest.closeProject(facetedProject.getProject().getName());
        DeleteWebProjectTest.assertTrue((boolean)listener.waitForEvents());
        provider.removeListener((IModelProviderListener)listener);
        try {
            provider.getModelObject();
            DeleteWebProjectTest.fail((String)"IllegalStateException expected because the project is closed and can not be accessed.");
        }
        catch (IllegalStateException illegalStateException) {}
    }
}

