/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.jee.model.ejb.tests;

import java.util.HashMap;
import junit.framework.TestSuite;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jst.j2ee.dependency.tests.util.ProjectUtil;
import org.eclipse.jst.j2ee.ejb.internal.operations.AddSessionBeanOperation;
import org.eclipse.jst.j2ee.ejb.internal.operations.NewSessionBeanClassDataModelProvider;
import org.eclipse.jst.j2ee.ejb.internal.operations.StateType;
import org.eclipse.jst.j2ee.internal.ejb.archiveoperations.EjbClientJarCreationDataModelProvider;
import org.eclipse.jst.j2ee.model.IModelProvider;
import org.eclipse.jst.j2ee.model.IModelProviderListener;
import org.eclipse.jst.j2ee.model.ModelProviderManager;
import org.eclipse.jst.javaee.ejb.EJBJar;
import org.eclipse.jst.jee.model.internal.Ejb3ModelProvider;
import org.eclipse.jst.jee.model.tests.AbstractAnnotationModelTest;
import org.eclipse.jst.jee.model.tests.AbstractTest;
import org.eclipse.jst.jee.model.tests.SynchronousModelChangedListener;
import org.eclipse.jst.jee.model.tests.TestUtils;
import org.eclipse.wst.common.frameworks.datamodel.DataModelFactory;
import org.eclipse.wst.common.frameworks.datamodel.IDataModel;
import org.eclipse.wst.common.frameworks.datamodel.IDataModelOperation;
import org.eclipse.wst.common.frameworks.datamodel.IDataModelProvider;
import org.eclipse.wst.common.project.facet.core.IFacetedProject;
import org.eclipse.wst.common.project.facet.core.ProjectFacetsManager;

public class EJB3MergedModelProviderTest
extends AbstractAnnotationModelTest {
    private static final String EJB_PROJECT_NAME = EJB3MergedModelProviderTest.class.getSimpleName();
    private static final String EAR_PROJECT_NAME = String.valueOf(EJB_PROJECT_NAME) + "ear";
    private static final String CLIENT_NAME = String.valueOf(EJB_PROJECT_NAME) + "Client";

    public static TestSuite suite() throws Exception {
        TestSuite suite = new TestSuite(EJB3MergedModelProviderTest.class);
        EJB3MergedModelProviderTest.setUpProject();
        return suite;
    }

    public static void setUpProject() throws Exception {
        ProjectUtil.createEARProject(EAR_PROJECT_NAME);
        IProject project = ProjectUtil.createEJBProject(EJB_PROJECT_NAME, EAR_PROJECT_NAME, CLIENT_NAME, 30, true);
        IFacetedProject facetedProject = ProjectFacetsManager.create((IProject)project);
        IProject clientProject = ResourcesPlugin.getWorkspace().getRoot().getProject(CLIENT_NAME);
        EJB3MergedModelProviderTest.createProjectContent(facetedProject.getProject());
        EJB3MergedModelProviderTest.createClientProjectContent(clientProject);
    }

    private static void createClientProjectContent(IProject clientProject) throws Exception {
        IJavaProject javaProject = JavaCore.create((IProject)clientProject);
        IFolder comFolder = javaProject.getProject().getFolder("ejbModule/com");
        comFolder.create(true, true, (IProgressMonitor)new NullProgressMonitor());
        comFolder.getFolder("sap").create(true, true, null);
        IPackageFragmentRoot root = javaProject.getPackageFragmentRoot((IResource)comFolder);
        IPackageFragment fragment = root.createPackageFragment("sap", true, (IProgressMonitor)new NullProgressMonitor());
        EJB3MergedModelProviderTest.createSessionBeanLocal(fragment);
    }

    public static void tearDownAfterClass() throws InterruptedException {
        AbstractTest.deleteProject(EJB3MergedModelProviderTest.class.getSimpleName());
    }

    private static void createProjectContent(IProject project) throws Exception {
        IJavaProject javaProject = JavaCore.create((IProject)project);
        IFolder comFolder = javaProject.getProject().getFolder("ejbModule/com");
        comFolder.create(true, true, (IProgressMonitor)new NullProgressMonitor());
        comFolder.getFolder("sap").create(true, true, null);
        IPackageFragmentRoot root = javaProject.getPackageFragmentRoot((IResource)comFolder);
        IPackageFragment fragment = root.createPackageFragment("sap", true, (IProgressMonitor)new NullProgressMonitor());
        EJB3MergedModelProviderTest.createSessionBean(fragment);
    }

    public void setUp() throws Exception {
        super.setUp();
        if (this.facetedProject == null) {
            return;
        }
        this.fixture = ModelProviderManager.getModelProvider((IProject)this.facetedProject.getProject());
        this.clientProject = ResourcesPlugin.getWorkspace().getRoot().getProject(CLIENT_NAME);
    }

    public void tearDown() throws Exception {
    }

    public void testAddBeanWithOperation() throws Exception {
        String ejbProjectName = String.valueOf(((Object)((Object)this)).getClass().getSimpleName()) + this.getName();
        String clientName = String.valueOf(ejbProjectName) + "Client";
        IProject project = ProjectUtil.createEJBProject(ejbProjectName, String.valueOf(ejbProjectName) + "ear", clientName, 30, true);
        IDataModelOperation operation = this.createBeanOperation("testAddBeanWithOperation", "com.sap", project.getName());
        IModelProvider provider = ModelProviderManager.getModelProvider((IProject)project);
        EJBJar result = (EJBJar)provider.getModelObject();
        EJB3MergedModelProviderTest.assertEquals((Object)new Integer(0), (Object)new Integer(result.getEnterpriseBeans().getSessionBeans().size()));
        this.executeAndWait(operation, provider);
        result = (EJBJar)provider.getModelObject();
        EJB3MergedModelProviderTest.assertEquals((Object)new Integer(1), (Object)new Integer(result.getEnterpriseBeans().getSessionBeans().size()));
        EJB3MergedModelProviderTest.assertNotNull((Object)TestUtils.getSessionBean(result, "testAddBeanWithOperation"));
    }

    public void testAddBeanWithOperationPreserveListeners() throws Exception {
        String ejbProjectName = String.valueOf(((Object)((Object)this)).getClass().getSimpleName()) + this.getName();
        IProject project = ProjectUtil.createEJBProject(ejbProjectName, null, 30, true);
        IModelProvider provider = ModelProviderManager.getModelProvider((IProject)project);
        IDataModelOperation operation = this.createBeanOperation("testAddBeanWithOperationPreserveListeners1", "com.sap", project.getName());
        SynchronousModelChangedListener preservedListener = new SynchronousModelChangedListener(2);
        provider.addListener((IModelProviderListener)preservedListener);
        this.executeAndWait(operation, provider);
        EJB3MergedModelProviderTest.assertNotNull((Object)TestUtils.getSessionBean((EJBJar)provider.getModelObject(), "testAddBeanWithOperationPreserveListeners1"));
        int oldReceivedEvents = preservedListener.getReceivedEvents().size();
        operation = this.createBeanOperation("testAddBeanWithOperationPreserveListeners2", "com.sap", project.getName());
        this.executeAndWait(operation, provider);
        EJB3MergedModelProviderTest.assertNotNull((Object)TestUtils.getSessionBean((EJBJar)provider.getModelObject(), "testAddBeanWithOperationPreserveListeners2"));
        EJB3MergedModelProviderTest.assertTrue((preservedListener.getReceivedEvents().size() > oldReceivedEvents ? 1 : 0) != 0);
    }

    private IDataModel createModelEjbProjectWithClient(String ejbProjectName) {
        IDataModel model = DataModelFactory.createDataModel((IDataModelProvider)new EjbClientJarCreationDataModelProvider());
        model.setProperty("IEjbClientProjectCreationDataModelProperties.EJB_PROJECT_NAME", (Object)ejbProjectName);
        model.setProperty("IJavaUtilityProjectCreationDataModelProperties.PROJECT_NAME", (Object)(String.valueOf(CLIENT_NAME) + "newName"));
        return model;
    }

    private IProject createEjbProjectWithoutClient(String ejbProjectName, String earProjectName) throws Exception {
        HashMap<String, Object> facetModelProperties = new HashMap<String, Object>();
        facetModelProperties.put("IEjbFacetInstallDataModelProperties.CREATE_CLIENT", false);
        facetModelProperties.put("IJ2EEFacetInstallDataModelProperties.GENERATE_DD", true);
        IProject project = ProjectUtil.createEJBProject(ejbProjectName, earProjectName, facetModelProperties, 30, true);
        return project;
    }

    public void testCreateClientProjectWithOperation() throws Exception {
        String ejbProjectName = String.valueOf(((Object)((Object)this)).getClass().getSimpleName()) + this.getName();
        IProject project = this.createEjbProjectWithoutClient(ejbProjectName, String.valueOf(ejbProjectName) + "ear");
        Ejb3ModelProvider provider = new Ejb3ModelProvider(project);
        provider.getModelObject();
        IDataModel model = this.createModelEjbProjectWithClient(ejbProjectName);
        this.executeAndWait(model.getDefaultOperation(), (IModelProvider)provider);
        EJBJar result = (EJBJar)provider.getModelObject();
        EJB3MergedModelProviderTest.assertEquals((String)(String.valueOf(CLIENT_NAME) + "newNameClient" + ".jar"), (String)result.getEjbClientJar());
    }

    private void executeAndWait(IDataModelOperation operation, IModelProvider provider) throws InterruptedException, ExecutionException {
        SynchronousModelChangedListener listener = new SynchronousModelChangedListener(1);
        provider.addListener((IModelProviderListener)listener);
        operation.execute(null, null);
        EJB3MergedModelProviderTest.assertTrue((boolean)listener.waitForEvents());
        provider.removeListener((IModelProviderListener)listener);
    }

    protected IDataModelOperation createBeanOperation(String className, String javaPackage, String projectName) {
        NewSessionBeanClassDataModelProvider dataProvider = new NewSessionBeanClassDataModelProvider();
        IDataModel dataModel = DataModelFactory.createDataModel((IDataModelProvider)dataProvider);
        dataModel.setStringProperty("NewJavaClassDataModel.CLASS_NAME", className);
        dataModel.setStringProperty("INewSessionBeanClassDataModelProperties.STATE_TYPE", StateType.STATELESS.toString());
        dataModel.setStringProperty("INewEnterpriseBeanClassDataModelProperties.EJB_NAME", className);
        dataModel.setStringProperty("NewJavaClassDataModel.JAVA_PACKAGE", javaPackage);
        dataModel.setStringProperty("IArtifactEditOperationDataModelProperties.PROJECT_NAME", projectName);
        AddSessionBeanOperation operation = new AddSessionBeanOperation(dataModel);
        return operation;
    }
}

