/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.j2ee.flexible.project.apitests.artifactedit;

import java.io.File;
import junit.framework.TestCase;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.jst.j2ee.application.Application;
import org.eclipse.jst.j2ee.client.ApplicationClient;
import org.eclipse.jst.j2ee.componentcore.util.EARArtifactEdit;
import org.eclipse.jst.j2ee.flexible.project.apitests.artifactedit.TestWorkspace;
import org.eclipse.wst.common.componentcore.internal.ComponentResource;
import org.eclipse.wst.common.componentcore.internal.ComponentcoreFactory;
import org.eclipse.wst.common.internal.emfworkbench.integration.EditModelEvent;
import org.eclipse.wst.common.internal.emfworkbench.integration.EditModelListener;

public class EarArtiFactEditFVTest
extends TestCase {
    private IProject earProject;
    private String earModuleName;

    public EarArtiFactEditFVTest() {
        if (TestWorkspace.init()) {
            this.earProject = TestWorkspace.getTargetProject("EARArtifactEditTest");
            this.earModuleName = "EARArtifactModule";
        } else {
            EarArtiFactEditFVTest.fail();
        }
    }

    public void testCreationDisposeFunction() {
        EARArtifactEdit edit = null;
        try {
            edit = EARArtifactEdit.getEARArtifactEditForWrite((IProject)this.earProject);
            edit.addListener(new EditModelListener(){

                public void editModelChanged(EditModelEvent anEvent) {
                    EarArtiFactEditFVTest.this.pass();
                }
            });
            Application client = edit.getApplication();
            this.updateClient(client);
            edit.save((IProgressMonitor)new NullProgressMonitor());
        }
        finally {
            if (edit != null) {
                edit.dispose();
            }
        }
    }

    private void updateClient(Application client) {
        client.setDescription("FVT Description Test");
        client.setDisplayName("FVT DisplayName Test");
        client.setLargeIcon("fvtLargeIcon.gif");
    }

    private static void pass(Application client) {
        boolean pass = client.getDescription().equals("FVT Description Test") && client.getDisplayName().equals("FVT DisplayName Test") && client.getLargeIcon().equals("fvtLargeIcon.gif");
        EarArtiFactEditFVTest.assertTrue((boolean)pass);
    }

    private void pass() {
        EarArtiFactEditFVTest.assertTrue((boolean)true);
    }

    public void testPersistenceFunction() {
        EARArtifactEdit edit = null;
        try {
            edit = EARArtifactEdit.getEARArtifactEditForWrite((IProject)this.earProject);
            Application ear = edit.getApplication();
            EarArtiFactEditFVTest.pass(ear);
        }
        finally {
            if (edit != null) {
                edit.dispose();
            }
        }
    }

    private static void pass(ApplicationClient ear) {
        boolean pass = ear.getDescription().equals("FVT Description Test") && ear.getDisplayName().equals("FVT DisplayName Test") && ear.getLargeIcon().equals("fvtLargeIcon.gif");
        EarArtiFactEditFVTest.assertTrue((boolean)pass);
    }

    private void validateResource() {
        EARArtifactEdit edit = null;
        try {
            edit = EARArtifactEdit.getEARArtifactEditForWrite((IProject)this.earProject);
        }
        finally {
            if (edit != null) {
                edit.dispose();
            }
        }
    }

    private ComponentResource createResourceComponent() {
        ComponentResource resourceComponent = ComponentcoreFactory.eINSTANCE.createComponentResource();
        File testFile = TestWorkspace.ARTIFACT_EDIT_FVT_RESOURCE_PATH.toFile();
        if (testFile.exists()) {
            resourceComponent.setRuntimePath(TestWorkspace.ARTIFACT_EDIT_FVT_RESOURCE_PATH);
            resourceComponent.setSourcePath(TestWorkspace.ARTIFACT_EDIT_FVT_RESOURCE_PATH);
        } else {
            EarArtiFactEditFVTest.fail((String)"Missing: TestWorkspace.ARTIFACT_EDIT_FVT_RESOURCE_PATH");
        }
        return resourceComponent;
    }
}

