/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.j2ee.bindingshelper.tests;

import java.io.FileNotFoundException;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.jst.j2ee.common.ResourceEnvRef;
import org.eclipse.jst.j2ee.common.ResourceRef;
import org.eclipse.jst.j2ee.common.SecurityRoleRef;
import org.eclipse.jst.j2ee.commonarchivecore.internal.Archive;
import org.eclipse.jst.j2ee.core.internal.bindings.AbstractJNDIBindingsHelper;
import org.eclipse.jst.j2ee.ejb.ContainerManagedEntity;
import org.eclipse.jst.j2ee.ejb.EnterpriseBean;
import org.eclipse.jst.j2ee.webapplication.WebApp;
import org.eclipse.wst.common.componentcore.ComponentCore;
import org.eclipse.wst.common.componentcore.resources.IVirtualComponent;

public abstract class TestBindingsHelper
extends AbstractJNDIBindingsHelper {
    public static final String OBJ = "obj";
    public static final String EJB = "ejb";
    public static final String EJB_RES_REF = "ejbResRef";
    public static final String EJB_RES_ENV_REF = "ejbResEnvRef";
    public static final String EJB_SEC_ROLE_REF = "ejbSecRoleRef";
    public static final String WEB_RES_REF = "webResRef";
    public static final String WEB_RES_ENV_REF = "webResEnvRef";
    public static final String CMP = "cmp";

    public abstract String getBindingsFileName();

    public boolean appliesFor(IProject project) {
        IVirtualComponent component = ComponentCore.createComponent((IProject)project);
        if (component == null) {
            return false;
        }
        IFile bindingsFile = component.getRootFolder().getFile(this.getBindingsFileName()).getUnderlyingFile();
        return bindingsFile.exists();
    }

    public boolean appliesFor(Archive archive) {
        try {
            archive.getFile(this.getBindingsFileName());
            return true;
        }
        catch (FileNotFoundException fileNotFoundException) {
            return false;
        }
    }

    public String getJNDIName(Object object) {
        return String.valueOf(this.getBindingsFileName()) + super.getJNDIName(object) + OBJ;
    }

    public String getJNDIName(EnterpriseBean bean) {
        return String.valueOf(this.getBindingsFileName()) + super.getJNDIName(bean) + EJB;
    }

    public String getJNDINameForRef(EnterpriseBean bean, ResourceRef resourceRef) {
        return String.valueOf(this.getBindingsFileName()) + super.getJNDINameForRef(bean, resourceRef) + EJB_RES_REF;
    }

    public String getJNDINameForRef(EnterpriseBean bean, ResourceEnvRef resourceEnvRef) {
        return String.valueOf(this.getBindingsFileName()) + super.getJNDINameForRef(bean, resourceEnvRef) + EJB_RES_ENV_REF;
    }

    public String getJNDINameForRef(EnterpriseBean bean, SecurityRoleRef securityRoleRef) {
        return String.valueOf(this.getBindingsFileName()) + super.getJNDINameForRef(bean, securityRoleRef) + EJB_SEC_ROLE_REF;
    }

    public String getJNDINameForRef(WebApp webApp, ResourceRef resourceRef) {
        return String.valueOf(this.getBindingsFileName()) + super.getJNDINameForRef(webApp, resourceRef) + WEB_RES_REF;
    }

    public String getJNDINameForRef(WebApp webApp, ResourceEnvRef resourceEnvRef) {
        return String.valueOf(this.getBindingsFileName()) + super.getJNDINameForRef(webApp, resourceEnvRef) + WEB_RES_ENV_REF;
    }

    public String getJNDINameForDefaultDataSource(ContainerManagedEntity bean) {
        return String.valueOf(this.getBindingsFileName()) + super.getJNDINameForDefaultDataSource(bean) + CMP;
    }
}

