/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.xml.core.internal.validation.eclipse;

import java.io.InputStream;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.wst.validation.ValidationResult;
import org.eclipse.wst.validation.ValidationState;
import org.eclipse.wst.validation.internal.provisional.core.IMessage;
import org.eclipse.wst.xml.core.internal.XMLCorePlugin;
import org.eclipse.wst.xml.core.internal.validation.XMLNestedValidatorContext;
import org.eclipse.wst.xml.core.internal.validation.XMLValidationConfiguration;
import org.eclipse.wst.xml.core.internal.validation.XMLValidationReport;
import org.eclipse.wst.xml.core.internal.validation.core.AbstractNestedValidator;
import org.eclipse.wst.xml.core.internal.validation.core.NestedValidatorContext;
import org.eclipse.wst.xml.core.internal.validation.core.ValidationMessage;
import org.eclipse.wst.xml.core.internal.validation.core.ValidationReport;
import org.eclipse.wst.xml.core.internal.validation.eclipse.XMLMessageInfoHelper;
import org.eclipse.wst.xml.core.internal.validation.eclipse.XMLValidator;

public class Validator
extends AbstractNestedValidator {
    private static final String XML_VALIDATOR_CONTEXT = "org.eclipse.wst.xml.core.validatorContext";
    protected int indicateNoGrammar = 0;

    protected void setupValidation(NestedValidatorContext context) {
        super.setupValidation(context);
        this.indicateNoGrammar = XMLCorePlugin.getDefault().getPluginPreferences().getInt("indicateNoGrammar");
    }

    public ValidationReport validate(String uri, InputStream inputstream, NestedValidatorContext context) {
        return this.validate(uri, inputstream, context, null);
    }

    public ValidationReport validate(String uri, InputStream inputstream, NestedValidatorContext context, ValidationResult result) {
        XMLValidator validator = XMLValidator.getInstance();
        XMLValidationConfiguration configuration = new XMLValidationConfiguration();
        try {
            configuration.setFeature(XMLValidationConfiguration.INDICATE_NO_GRAMMAR, this.indicateNoGrammar);
        }
        catch (Exception exception) {}
        XMLValidationReport valreport = null;
        valreport = inputstream != null ? validator.validate(uri, inputstream, configuration, result, context) : validator.validate(uri, null, configuration, result, context);
        return valreport;
    }

    protected void addInfoToMessage(ValidationMessage validationMessage, IMessage message) {
        String key = validationMessage.getKey();
        if (key != null) {
            XMLMessageInfoHelper messageInfoHelper = new XMLMessageInfoHelper();
            String[] messageInfo = messageInfoHelper.createMessageInfo(key, validationMessage.getMessageArguments());
            message.setAttribute("columnNumber", (Object)new Integer(validationMessage.getColumnNumber()));
            message.setAttribute("squiggleSelectionStrategy", (Object)messageInfo[0]);
            message.setAttribute("squiggleNameOrValue", (Object)messageInfo[1]);
        }
    }

    protected NestedValidatorContext getNestedContext(ValidationState state, boolean create) {
        XMLNestedValidatorContext context = null;
        Object o = state.get(XML_VALIDATOR_CONTEXT);
        if (o instanceof XMLNestedValidatorContext) {
            context = (XMLNestedValidatorContext)o;
        } else if (create) {
            context = new XMLNestedValidatorContext();
        }
        return context;
    }

    public void validationStarting(IProject project, ValidationState state, IProgressMonitor monitor) {
        if (project != null) {
            NestedValidatorContext context = this.getNestedContext(state, false);
            if (context == null) {
                context = this.getNestedContext(state, true);
                this.setupValidation(context);
                state.put(XML_VALIDATOR_CONTEXT, (Object)context);
            }
            super.validationStarting(project, state, monitor);
        }
    }

    public void validationFinishing(IProject project, ValidationState state, IProgressMonitor monitor) {
        if (project != null) {
            super.validationFinishing(project, state, monitor);
            NestedValidatorContext context = this.getNestedContext(state, false);
            if (context != null) {
                this.teardownValidation(context);
                state.put(XML_VALIDATOR_CONTEXT, null);
            }
        }
    }
}

