/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.j2ee.internal.archive.operations;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.jst.j2ee.commonarchivecore.internal.Archive;
import org.eclipse.jst.j2ee.commonarchivecore.internal.File;
import org.eclipse.jst.j2ee.commonarchivecore.internal.exception.SaveFailureException;
import org.eclipse.jst.j2ee.commonarchivecore.internal.helpers.ArchiveManifest;
import org.eclipse.jst.j2ee.commonarchivecore.internal.strategy.SaveStrategy;
import org.eclipse.jst.j2ee.commonarchivecore.internal.strategy.SaveStrategyImpl;
import org.eclipse.jst.j2ee.internal.archive.operations.EJBArchiveOpsResourceHandler;
import org.eclipse.jst.j2ee.internal.archive.operations.IOverwriteHandler;
import org.eclipse.jst.j2ee.internal.archive.operations.OverwriteHandlerException;
import org.eclipse.wst.common.componentcore.ComponentCore;
import org.eclipse.wst.common.componentcore.internal.operation.CreateReferenceComponentsDataModelProvider;
import org.eclipse.wst.common.componentcore.resources.IVirtualComponent;
import org.eclipse.wst.common.componentcore.resources.IVirtualFile;
import org.eclipse.wst.common.componentcore.resources.IVirtualFolder;
import org.eclipse.wst.common.frameworks.datamodel.DataModelFactory;
import org.eclipse.wst.common.frameworks.datamodel.IDataModel;
import org.eclipse.wst.common.frameworks.datamodel.IDataModelProvider;

public abstract class ComponentSaveStrategyImpl
extends SaveStrategyImpl {
    protected IDataModel dataModel;
    protected IVirtualComponent vComponent;
    protected IOverwriteHandler overwriteHandler;
    protected IProgressMonitor progressMonitor;
    private String archiveComponentsDeployPath;
    private List archiveComponents;
    private Map archiveComponentURIMap;
    private Map archiveComponentDeployPathMap;

    public ComponentSaveStrategyImpl(IVirtualComponent vComponent) {
        if (vComponent == null) {
            throw new NullPointerException();
        }
        this.vComponent = vComponent;
    }

    public void setDataModel(IDataModel dataModel) {
        this.dataModel = dataModel;
    }

    public void setOverwriteHandler(IOverwriteHandler newOverwriteHandler) {
        this.overwriteHandler = newOverwriteHandler;
    }

    public void setProgressMonitor(IProgressMonitor newProgressMonitor) {
        this.progressMonitor = newProgressMonitor;
    }

    protected void validateEdit(IFile aFile) {
        if (this.overwriteHandler == null) {
            return;
        }
        if (!aFile.exists() || !aFile.isReadOnly()) {
            return;
        }
        this.overwriteHandler.validateEdit(aFile);
    }

    protected boolean shouldOverwrite(String uri) {
        if (this.overwriteHandler.isOverwriteNone()) {
            return false;
        }
        return this.overwriteHandler.isOverwriteResources() || this.overwriteHandler.isOverwriteAll() || this.overwriteHandler.shouldOverwrite(uri);
    }

    protected SaveStrategy createNestedSaveStrategy(Archive anArchive) throws IOException {
        return null;
    }

    protected OutputStream getOutputStreamForResource(Resource aResource) throws IOException {
        return null;
    }

    protected void saveFiles() throws SaveFailureException {
        super.saveFiles();
        this.linkArchiveComponents();
    }

    public void save(File aFile, InputStream in) throws SaveFailureException {
        try {
            try {
                this.progressMonitor.subTask(aFile.getURI());
                IPath projectRelativePath = this.getOutputPathForFile(aFile);
                if (aFile.isArchive()) {
                    this.saveAsArchiveComponent((Archive)aFile, projectRelativePath, in);
                } else if (!aFile.isDirectoryEntry()) {
                    this.saveToOutputPath(projectRelativePath, in);
                } else {
                    this.createDirectory(projectRelativePath);
                }
            }
            catch (OverwriteHandlerException ohe) {
                throw ohe;
            }
            catch (Exception e) {
                String errorString = String.valueOf(EJBArchiveOpsResourceHandler.ARCHIVE_OPERATION_SaveFile) + aFile.getName();
                throw new SaveFailureException(errorString, e);
            }
        }
        finally {
            this.progressMonitor.worked(1);
        }
    }

    protected IPath getOutputPathForFile(File aFile) {
        String uri = aFile.getURI();
        IFile iFile = null;
        if (uri.startsWith(".settings")) {
            iFile = this.vComponent.getProject().getFile((IPath)new Path(uri));
        } else {
            IVirtualFolder rootFolder = this.vComponent.getRootFolder();
            IVirtualFile vFile = rootFolder.getFile(aFile.getURI());
            iFile = vFile.getUnderlyingFile();
        }
        return iFile.getProjectRelativePath();
    }

    protected void saveToWorkbenchPath(IPath workbenchPath, InputStream in) throws Exception {
        IFile iFile = ResourcesPlugin.getWorkspace().getRoot().getFile(workbenchPath);
        this.saveToIFile(iFile, in);
    }

    protected void createDirectory(IPath projectRelativePath) throws CoreException {
        IFolder iFolder = this.vComponent.getProject().getFolder(projectRelativePath);
        if (!iFolder.exists()) {
            this.mkdirs(iFolder);
        }
    }

    protected void mkdirs(IFolder folder) throws CoreException {
        IContainer container = folder.getParent();
        if (!container.exists()) {
            this.mkdirs((IFolder)container);
        }
        folder.create(true, true, null);
    }

    protected void saveAsArchiveComponent(Archive archive, IPath projectRelativePath, InputStream in) throws Exception {
        IFile iFile = this.saveToOutputPathIFile(projectRelativePath, in);
        if (this.shouldLinkAsComponentRef(archive)) {
            IVirtualComponent archiveComponent = ComponentCore.createArchiveComponent((IProject)this.vComponent.getProject(), (String)("lib" + iFile.getFullPath().toString()));
            if (this.archiveComponents == null) {
                this.archiveComponents = new ArrayList();
                this.archiveComponentURIMap = new HashMap();
                this.archiveComponentDeployPathMap = new HashMap();
                this.archiveComponentsDeployPath = String.valueOf('/') + new Path(archive.getURI()).removeLastSegments(1).toString();
            }
            this.archiveComponents.add(archiveComponent);
            this.archiveComponentURIMap.put(archiveComponent, iFile.getName());
            this.archiveComponentDeployPathMap.put(archiveComponent, String.valueOf('/') + new Path(archive.getURI()).removeLastSegments(1).toString());
        }
    }

    protected boolean shouldLinkAsComponentRef(Archive archive) {
        return false;
    }

    protected void linkArchiveComponents() {
        if (this.archiveComponents != null && this.archiveComponents.size() > 0) {
            IDataModel createReferencesDataModel = DataModelFactory.createDataModel((IDataModelProvider)new CreateReferenceComponentsDataModelProvider());
            createReferencesDataModel.setProperty("ICreateReferenceComponentsDataModelProperties.SOURCE_COMPONENT", (Object)this.vComponent);
            createReferencesDataModel.setProperty("ICreateReferenceComponentsDataModelProperties.TARGET_COMPONENT_DEPLOY_PATH", (Object)this.archiveComponentsDeployPath);
            createReferencesDataModel.setProperty("ICreateReferenceComponentsDataModelProperties.TARGET_COMPONENT_DEPLOY_PATH_MAP", (Object)this.archiveComponentDeployPathMap);
            createReferencesDataModel.setProperty("ICreateReferenceComponentsDataModelProperties.TARGET_COMPONENT", (Object)this.archiveComponents);
            createReferencesDataModel.setProperty("ICreateReferenceComponentsDataModelProperties.TARGET_COMPONENTS_TO_URI_MAP", (Object)this.archiveComponentURIMap);
            try {
                createReferencesDataModel.getDefaultOperation().execute(null, null);
            }
            catch (ExecutionException e) {
                e.printStackTrace();
            }
        }
    }

    protected void saveToOutputPath(IPath projectRelativePath, InputStream in) throws Exception {
        this.saveToOutputPathIFile(projectRelativePath, in);
    }

    protected IFile saveToOutputPathIFile(IPath projectRelativePath, InputStream in) throws Exception {
        IFile iFile = this.vComponent.getProject().getFile(projectRelativePath);
        this.saveToIFile(iFile, in);
        return iFile;
    }

    protected void saveToIFile(IFile iFile, InputStream in) throws Exception {
        this.validateEdit(iFile);
        if (iFile.exists()) {
            iFile.setContents(in, true, true, null);
        } else {
            this.mkdirs(iFile.getFullPath().removeLastSegments(1), ResourcesPlugin.getWorkspace().getRoot());
            iFile.create(in, true, null);
        }
    }

    protected void mkdirs(IPath path, IWorkspaceRoot root) throws CoreException {
        if (path.segmentCount() <= 1) {
            return;
        }
        IFolder folder = root.getFolder(path);
        if (!folder.exists()) {
            this.mkdirs(path.removeLastSegments(1), root);
            folder.create(true, true, null);
        }
    }

    public void save(ArchiveManifest aManifest) throws SaveFailureException {
    }
}

