/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.web.ui.internal.java.search;

import java.util.HashMap;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.search.ui.text.Match;
import org.eclipse.wst.jsdt.ui.search.ISearchRequestor;
import org.eclipse.wst.jsdt.web.ui.internal.Logger;
import org.eclipse.wst.jsdt.web.ui.internal.java.search.BasicJsSearchRequestor;

public class JsSearchRequestor
extends BasicJsSearchRequestor {
    private ISearchRequestor fJavaRequestor = null;

    public JsSearchRequestor() {
    }

    public JsSearchRequestor(ISearchRequestor javaRequestor) {
        this.fJavaRequestor = javaRequestor;
    }

    protected void addSearchMatch(IDocument jspDocument, IFile jspFile, int jspStart, int jspEnd, String jspText) {
        if (!jspFile.exists()) {
            return;
        }
        int lineNumber = -1;
        try {
            lineNumber = jspDocument.getLineOfOffset(jspStart);
        }
        catch (BadLocationException e) {
            Logger.logException("offset: " + Integer.toString(jspStart), e);
        }
        this.createSearchMarker(jspFile, jspStart, jspEnd, lineNumber);
        if (this.fJavaRequestor != null) {
            Match match = new Match((Object)jspFile, jspStart, jspEnd - jspStart);
            this.fJavaRequestor.reportMatch(match);
        }
    }

    private void createSearchMarker(IFile jspFile, int jspStart, int jspEnd, int lineNumber) {
        try {
            IMarker marker = jspFile.createMarker("org.eclipse.search.searchmarker");
            HashMap<String, Integer> attributes = new HashMap<String, Integer>(4);
            attributes.put("charStart", new Integer(jspStart));
            attributes.put("charEnd", new Integer(jspEnd));
            attributes.put("lineNumber", new Integer(lineNumber));
            marker.setAttributes(attributes);
        }
        catch (CoreException e) {
            Logger.logException(e);
        }
    }
}

