/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.xml.ui.internal.dialogs;

import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;
import org.eclipse.wst.xml.core.internal.XMLCorePlugin;
import org.eclipse.wst.xml.core.internal.catalog.provisional.ICatalog;
import org.eclipse.wst.xml.core.internal.catalog.provisional.ICatalogEntry;
import org.eclipse.wst.xml.ui.internal.dialogs.SelectXMLCatalogIdPanel;

public class SelectXMLCatalogIdDialog
extends Dialog {
    protected String[] extensions;
    protected Button okButton;
    protected SelectXMLCatalogIdPanel panel;
    protected String publicId;
    protected String systemId;

    public SelectXMLCatalogIdDialog(Shell parentShell, String[] extensions) {
        super(parentShell);
        this.setShellStyle(this.getShellStyle() | 0x10);
        this.extensions = extensions;
    }

    protected void buttonPressed(int buttonId) {
        if (buttonId == 0) {
            Object selectedObject;
            ISelection selection = this.panel.getTableViewer().getSelection();
            Object object = selectedObject = selection instanceof IStructuredSelection ? ((IStructuredSelection)selection).getFirstElement() : null;
            if (selectedObject instanceof ICatalogEntry) {
                ICatalogEntry mappingInfo = (ICatalogEntry)selectedObject;
                this.publicId = mappingInfo.getKey();
                this.systemId = this.computeDefaultSystemId(mappingInfo);
            }
        }
        super.buttonPressed(buttonId);
    }

    protected String computeDefaultSystemId(ICatalogEntry mappingInfo) {
        String result = mappingInfo.getAttributeValue("webURL");
        if (result == null && mappingInfo.getURI() != null) {
            String lastSegment;
            int index = mappingInfo.getURI().lastIndexOf("/");
            result = lastSegment = index != -1 ? mappingInfo.getURI().substring(index + 1) : mappingInfo.getURI();
        }
        return result;
    }

    protected void createButtonsForButtonBar(Composite parent) {
        this.okButton = this.createButton(parent, 0, IDialogConstants.OK_LABEL, true);
        this.okButton.setEnabled(false);
        this.createButton(parent, 1, IDialogConstants.CANCEL_LABEL, false);
    }

    protected Control createDialogArea(Composite parent) {
        Composite dialogArea = (Composite)super.createDialogArea(parent);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)dialogArea, "org.eclipse.wst.xml.ui.xcui0400");
        ICatalog xmlCatalog = XMLCorePlugin.getDefault().getDefaultXMLCatalog();
        this.panel = new SelectXMLCatalogIdPanel(dialogArea, xmlCatalog);
        ISelectionChangedListener listener = new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                SelectXMLCatalogIdDialog.this.updateButtonState();
            }
        };
        this.panel.getTableViewer().setFilterExtensions(this.extensions);
        this.panel.getTableViewer().addSelectionChangedListener(listener);
        return dialogArea;
    }

    public String getId() {
        return this.publicId;
    }

    public String getSystemId() {
        return this.systemId;
    }

    protected void updateButtonState() {
        ISelection selection = this.panel.getTableViewer().getSelection();
        this.okButton.setEnabled(!selection.isEmpty());
    }
}

