/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.core.dom;

import java.util.ArrayList;
import java.util.Iterator;
import org.eclipse.wst.jsdt.core.IFunction;
import org.eclipse.wst.jsdt.core.IJavaScriptElement;
import org.eclipse.wst.jsdt.core.IType;
import org.eclipse.wst.jsdt.core.ITypeRoot;
import org.eclipse.wst.jsdt.core.JavaScriptModelException;
import org.eclipse.wst.jsdt.core.Signature;
import org.eclipse.wst.jsdt.core.compiler.CharOperation;
import org.eclipse.wst.jsdt.core.dom.ASTNode;
import org.eclipse.wst.jsdt.core.dom.BindingComparator;
import org.eclipse.wst.jsdt.core.dom.BindingResolver;
import org.eclipse.wst.jsdt.core.dom.DefaultBindingResolver;
import org.eclipse.wst.jsdt.core.dom.FunctionDeclaration;
import org.eclipse.wst.jsdt.core.dom.IBinding;
import org.eclipse.wst.jsdt.core.dom.IFunctionBinding;
import org.eclipse.wst.jsdt.core.dom.ITypeBinding;
import org.eclipse.wst.jsdt.core.dom.SingleVariableDeclaration;
import org.eclipse.wst.jsdt.core.dom.Type;
import org.eclipse.wst.jsdt.internal.compiler.lookup.LookupEnvironment;
import org.eclipse.wst.jsdt.internal.compiler.lookup.MethodBinding;
import org.eclipse.wst.jsdt.internal.compiler.lookup.MethodVerifier;
import org.eclipse.wst.jsdt.internal.compiler.lookup.ParameterizedGenericMethodBinding;
import org.eclipse.wst.jsdt.internal.compiler.lookup.RawTypeBinding;
import org.eclipse.wst.jsdt.internal.compiler.lookup.ReferenceBinding;
import org.eclipse.wst.jsdt.internal.compiler.lookup.TypeBinding;
import org.eclipse.wst.jsdt.internal.compiler.lookup.TypeVariableBinding;
import org.eclipse.wst.jsdt.internal.compiler.problem.AbortCompilation;
import org.eclipse.wst.jsdt.internal.core.JavaElement;
import org.eclipse.wst.jsdt.internal.core.Member;
import org.eclipse.wst.jsdt.internal.core.util.Util;

class FunctionBinding
implements IFunctionBinding {
    private static final int VALID_MODIFIERS = 3391;
    private static final ITypeBinding[] NO_TYPE_BINDINGS = new ITypeBinding[0];
    private MethodBinding binding;
    private BindingResolver resolver;
    private ITypeBinding[] parameterTypes;
    private ITypeBinding[] exceptionTypes;
    private String name;
    private ITypeBinding declaringClass;
    private ITypeBinding returnType;
    private String key;
    private ITypeBinding[] typeParameters;
    private ITypeBinding[] typeArguments;

    FunctionBinding(BindingResolver resolver, MethodBinding binding) {
        this.resolver = resolver;
        this.binding = binding;
    }

    public boolean isAnnotationMember() {
        return this.getDeclaringClass().isAnnotation();
    }

    public boolean isConstructor() {
        return this.binding.isConstructor();
    }

    public boolean isDefaultConstructor() {
        ReferenceBinding declaringClassBinding = this.binding.declaringClass;
        if (declaringClassBinding.isRawType()) {
            RawTypeBinding rawTypeBinding = (RawTypeBinding)declaringClassBinding;
            if (rawTypeBinding.genericType().isBinaryBinding()) {
                return false;
            }
            return (this.binding.modifiers & 0x4000000) != 0;
        }
        if (declaringClassBinding.isBinaryBinding()) {
            return false;
        }
        return (this.binding.modifiers & 0x4000000) != 0;
    }

    public String getName() {
        if (this.name == null) {
            this.name = this.binding.isConstructor() ? this.getDeclaringClass().getName() : (this.binding.selector != null ? new String(this.binding.selector) : "");
        }
        return this.name;
    }

    public ITypeBinding getDeclaringClass() {
        if (this.declaringClass == null) {
            this.declaringClass = this.resolver.getTypeBinding(this.binding.declaringClass);
        }
        return this.declaringClass;
    }

    public ITypeBinding[] getParameterTypes() {
        int length;
        if (this.parameterTypes != null) {
            return this.parameterTypes;
        }
        TypeBinding[] parameters = this.binding.parameters;
        int n = length = parameters == null ? 0 : parameters.length;
        if (length == 0) {
            this.parameterTypes = NO_TYPE_BINDINGS;
            return NO_TYPE_BINDINGS;
        }
        ITypeBinding[] paramTypes = new ITypeBinding[length];
        int i = 0;
        while (i < length) {
            ITypeBinding typeBinding;
            TypeBinding parameterBinding = parameters[i];
            if (parameterBinding != null) {
                typeBinding = this.resolver.getTypeBinding(parameterBinding);
                if (typeBinding == null) {
                    this.parameterTypes = NO_TYPE_BINDINGS;
                    return NO_TYPE_BINDINGS;
                }
            } else {
                StringBuffer message = new StringBuffer("Report method binding where a parameter is null:\n");
                message.append(this.toString());
                Util.log(new IllegalArgumentException(), message.toString());
                this.parameterTypes = NO_TYPE_BINDINGS;
                return NO_TYPE_BINDINGS;
            }
            paramTypes[i] = typeBinding;
            ++i;
        }
        this.parameterTypes = paramTypes;
        return paramTypes;
    }

    public ITypeBinding getReturnType() {
        if (this.returnType == null) {
            this.returnType = this.resolver.getTypeBinding(this.binding.returnType);
        }
        return this.returnType;
    }

    public Object getDefaultValue() {
        return null;
    }

    public ITypeBinding[] getExceptionTypes() {
        int length;
        if (this.exceptionTypes != null) {
            return this.exceptionTypes;
        }
        ReferenceBinding[] exceptions = this.binding.thrownExceptions;
        int n = length = exceptions == null ? 0 : exceptions.length;
        if (length == 0) {
            this.exceptionTypes = NO_TYPE_BINDINGS;
            return NO_TYPE_BINDINGS;
        }
        ITypeBinding[] exTypes = new ITypeBinding[length];
        int i = 0;
        while (i < length) {
            ITypeBinding typeBinding = this.resolver.getTypeBinding(exceptions[i]);
            if (typeBinding == null) {
                this.exceptionTypes = NO_TYPE_BINDINGS;
                return NO_TYPE_BINDINGS;
            }
            exTypes[i] = typeBinding;
            ++i;
        }
        this.exceptionTypes = exTypes;
        return exTypes;
    }

    public IJavaScriptElement getJavaElement() {
        JavaElement element = this.getUnresolvedJavaElement();
        if (element == null) {
            return null;
        }
        return element.resolved(this.binding);
    }

    private JavaElement getUnresolvedJavaElement() {
        IJavaScriptElement declaringElement = this.getDeclaringClass().getJavaElement();
        if (declaringElement == null) {
            return null;
        }
        if (!(this.resolver instanceof DefaultBindingResolver)) {
            return null;
        }
        ASTNode node = (ASTNode)((DefaultBindingResolver)this.resolver).bindingsToAstNodes.get(this);
        ITypeRoot typeRoot = null;
        IType declaringType = null;
        if (declaringElement instanceof ITypeRoot) {
            typeRoot = (ITypeRoot)declaringElement;
        } else if (declaringElement instanceof IType) {
            declaringType = (IType)declaringElement;
        }
        if (node != null && declaringElement.getParent().getElementType() != 6) {
            if (node instanceof FunctionDeclaration) {
                FunctionDeclaration methodDeclaration = (FunctionDeclaration)node;
                ArrayList<String> parameterSignatures = new ArrayList<String>();
                Iterator iterator = methodDeclaration.parameters().iterator();
                while (iterator.hasNext()) {
                    SingleVariableDeclaration parameter = (SingleVariableDeclaration)iterator.next();
                    Type type = parameter.getType();
                    String typeSig = Util.getSignature(type);
                    int arrayDim = parameter.getExtraDimensions();
                    if (parameter.getAST().apiLevel() >= 3 && parameter.isVarargs()) {
                        ++arrayDim;
                    }
                    if (arrayDim > 0) {
                        typeSig = Signature.createArraySignature(typeSig, arrayDim);
                    }
                    parameterSignatures.add(typeSig);
                }
                int parameterCount = parameterSignatures.size();
                String[] parameters = new String[parameterCount];
                parameterSignatures.toArray(parameters);
                if (typeRoot != null) {
                    return (JavaElement)((Object)typeRoot.getFunction(this.getName(), parameters));
                }
                return (JavaElement)((Object)declaringType.getFunction(this.getName(), parameters));
            }
            return null;
        }
        MethodBinding original = this.binding.original();
        String selector = original.isConstructor() ? declaringType.getElementName() : new String(original.selector);
        boolean isBinary = declaringType.isBinary();
        ReferenceBinding enclosingType = original.declaringClass.enclosingType();
        boolean isInnerBinaryTypeConstructor = isBinary && original.isConstructor() && enclosingType != null;
        TypeBinding[] parameters = original.parameters;
        int length = parameters == null ? 0 : parameters.length;
        int declaringIndex = isInnerBinaryTypeConstructor ? 1 : 0;
        String[] parameterSignatures = new String[declaringIndex + length];
        if (isInnerBinaryTypeConstructor) {
            parameterSignatures[0] = new String(enclosingType.genericTypeSignature()).replace('/', '.');
        }
        int i = 0;
        while (i < length) {
            parameterSignatures[declaringIndex + i] = new String(parameters[i].genericTypeSignature()).replace('/', '.');
            ++i;
        }
        IFunction result = declaringType.getFunction(selector, parameterSignatures);
        if (isBinary) {
            return (JavaElement)((Object)result);
        }
        IFunction[] methods = null;
        try {
            methods = declaringType.getFunctions();
        }
        catch (JavaScriptModelException javaScriptModelException) {
            return null;
        }
        IFunction[] candidates = Member.findMethods(result, methods);
        if (candidates == null || candidates.length == 0) {
            return null;
        }
        return (JavaElement)((Object)candidates[0]);
    }

    public int getKind() {
        return 4;
    }

    public int getModifiers() {
        return this.binding.getAccessFlags() & 0xD3F;
    }

    public boolean isDeprecated() {
        return this.binding.isDeprecated();
    }

    public boolean isRecovered() {
        return false;
    }

    public boolean isSynthetic() {
        return this.binding.isSynthetic();
    }

    public boolean isVarargs() {
        return this.binding.isVarargs();
    }

    public String getKey() {
        if (this.key == null) {
            this.key = new String(this.binding.computeUniqueKey());
        }
        return this.key;
    }

    public boolean isEqualTo(IBinding other) {
        if (other == this) {
            return true;
        }
        if (other == null) {
            return false;
        }
        if (!(other instanceof FunctionBinding)) {
            return false;
        }
        MethodBinding otherBinding = ((FunctionBinding)other).binding;
        return BindingComparator.isEqual(this.binding, otherBinding);
    }

    public ITypeBinding[] getTypeParameters() {
        int typeVariableBindingsLength;
        if (this.typeParameters != null) {
            return this.typeParameters;
        }
        TypeVariableBinding[] typeVariableBindings = this.binding.typeVariables();
        int n = typeVariableBindingsLength = typeVariableBindings == null ? 0 : typeVariableBindings.length;
        if (typeVariableBindingsLength == 0) {
            this.typeParameters = NO_TYPE_BINDINGS;
            return NO_TYPE_BINDINGS;
        }
        ITypeBinding[] tParameters = new ITypeBinding[typeVariableBindingsLength];
        int i = 0;
        while (i < typeVariableBindingsLength) {
            ITypeBinding typeBinding = this.resolver.getTypeBinding(typeVariableBindings[i]);
            if (typeBinding == null) {
                this.typeParameters = NO_TYPE_BINDINGS;
                return NO_TYPE_BINDINGS;
            }
            tParameters[i] = typeBinding;
            ++i;
        }
        this.typeParameters = tParameters;
        return tParameters;
    }

    public boolean isGenericMethod() {
        if (this.typeParameters != null) {
            return this.typeParameters.length > 0;
        }
        TypeVariableBinding[] typeVariableBindings = this.binding.typeVariables();
        return typeVariableBindings != null && typeVariableBindings.length > 0;
    }

    public ITypeBinding[] getTypeArguments() {
        if (this.typeArguments != null) {
            return this.typeArguments;
        }
        if (this.binding instanceof ParameterizedGenericMethodBinding) {
            int typeArgumentsLength;
            ParameterizedGenericMethodBinding genericMethodBinding = (ParameterizedGenericMethodBinding)this.binding;
            TypeBinding[] typeArgumentsBindings = genericMethodBinding.typeArguments;
            int n = typeArgumentsLength = typeArgumentsBindings == null ? 0 : typeArgumentsBindings.length;
            if (typeArgumentsLength != 0) {
                ITypeBinding[] tArguments = new ITypeBinding[typeArgumentsLength];
                int i = 0;
                while (i < typeArgumentsLength) {
                    ITypeBinding typeBinding = this.resolver.getTypeBinding(typeArgumentsBindings[i]);
                    if (typeBinding == null) {
                        this.typeArguments = NO_TYPE_BINDINGS;
                        return NO_TYPE_BINDINGS;
                    }
                    tArguments[i] = typeBinding;
                    ++i;
                }
                this.typeArguments = tArguments;
                return tArguments;
            }
        }
        this.typeArguments = NO_TYPE_BINDINGS;
        return NO_TYPE_BINDINGS;
    }

    public boolean isParameterizedMethod() {
        return this.binding instanceof ParameterizedGenericMethodBinding && !((ParameterizedGenericMethodBinding)this.binding).isRaw;
    }

    public boolean isRawMethod() {
        return this.binding instanceof ParameterizedGenericMethodBinding && ((ParameterizedGenericMethodBinding)this.binding).isRaw;
    }

    public boolean isSubsignature(IFunctionBinding otherMethod) {
        MethodBinding other;
        block3: {
            try {
                other = ((FunctionBinding)otherMethod).binding;
                if (CharOperation.equals(this.binding.selector, other.selector)) break block3;
                return false;
            }
            catch (AbortCompilation abortCompilation) {
                return false;
            }
        }
        return this.binding.areParameterErasuresEqual(other) && this.binding.areTypeVariableErasuresEqual(other);
    }

    public IFunctionBinding getMethodDeclaration() {
        return this.resolver.getMethodBinding(this.binding.original());
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean overrides(IFunctionBinding overridenMethod) {
        try {
            MethodBinding overridenCompilerBinding = ((FunctionBinding)overridenMethod).binding;
            if (this.binding == overridenCompilerBinding) {
                return false;
            }
            char[] selector = this.binding.selector;
            if (!CharOperation.equals(selector, overridenCompilerBinding.selector)) {
                return false;
            }
            TypeBinding match = this.binding.declaringClass.findSuperTypeWithSameErasure(overridenCompilerBinding.declaringClass);
            if (!(match instanceof ReferenceBinding)) {
                return false;
            }
            MethodBinding[] superMethods = ((ReferenceBinding)match).getMethods(selector);
            int i = 0;
            int length = superMethods.length;
            while (true) {
                if (i >= length) {
                    return false;
                }
                if (superMethods[i].original() == overridenCompilerBinding) {
                    LookupEnvironment lookupEnvironment = this.resolver.lookupEnvironment();
                    if (lookupEnvironment == null) {
                        return false;
                    }
                    MethodVerifier methodVerifier = lookupEnvironment.methodVerifier();
                    MethodBinding superMethod = superMethods[i];
                    return !superMethod.isPrivate() && (!superMethod.isDefault() || superMethod.declaringClass.getPackage() == this.binding.declaringClass.getPackage()) && methodVerifier.doesMethodOverride(this.binding, superMethod);
                }
                ++i;
            }
        }
        catch (AbortCompilation abortCompilation) {
            return false;
        }
    }

    public String toString() {
        return this.binding.toString();
    }
}

