/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.jsf.core.internal.contentassist.el;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import org.eclipse.jst.jsf.common.internal.types.CompositeType;
import org.eclipse.jst.jsf.context.IModelContext;
import org.eclipse.jst.jsf.context.resolver.structureddocument.IDOMContextResolver;
import org.eclipse.jst.jsf.context.resolver.structureddocument.IStructuredDocumentContextResolverFactory;
import org.eclipse.jst.jsf.context.resolver.structureddocument.ITaglibContextResolver;
import org.eclipse.jst.jsf.context.structureddocument.IStructuredDocumentContext;
import org.eclipse.jst.jsf.context.symbol.IInstanceSymbol;
import org.eclipse.jst.jsf.context.symbol.IObjectSymbol;
import org.eclipse.jst.jsf.context.symbol.ISymbol;
import org.eclipse.jst.jsf.designtime.resolver.ISymbolContextResolver;
import org.eclipse.jst.jsf.designtime.resolver.StructuredDocumentSymbolResolverFactory;
import org.eclipse.jst.jsf.metadataprocessors.IMetaDataEnabledFeature;
import org.eclipse.jst.jsf.metadataprocessors.MetaDataEnabledProcessingFactory;
import org.eclipse.jst.jsf.metadataprocessors.features.ELIsNotValidException;
import org.eclipse.jst.jsf.metadataprocessors.features.IValidELValues;
import org.w3c.dom.Attr;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class SymbolResolveUtil {
    private SymbolResolveUtil() {
    }

    public static ISymbol getSymbolForVariable(IStructuredDocumentContext context, String name) {
        ISymbolContextResolver symbolResolver = StructuredDocumentSymbolResolverFactory.getInstance().getSymbolContextResolver((IModelContext)context);
        return symbolResolver.getVariable(name);
    }

    public static ISymbol getSymbolForVariableSuffixExpr(IStructuredDocumentContext context, String fullName, boolean isLastSuffix) {
        ISymbol symbol;
        ISymbolContextResolver symbolResolver;
        String[] ids = fullName.split("\\.");
        if (ids.length < 1) {
            ids = new String[]{fullName};
        }
        if ((symbolResolver = StructuredDocumentSymbolResolverFactory.getInstance().getSymbolContextResolver((IModelContext)context)) != null && (symbol = symbolResolver.getVariable(ids[0])) instanceof IInstanceSymbol && ((IInstanceSymbol)symbol).isTypeResolved()) {
            int curSuffixIdx = 1;
            while (curSuffixIdx < ids.length) {
                if (isLastSuffix && curSuffixIdx == ids.length - 1 && SymbolResolveUtil.isMethodBindingExpected(context)) {
                    return symbolResolver.getMethod((IObjectSymbol)symbol, ids[curSuffixIdx]);
                }
                ISymbol property = symbolResolver.getProperty(symbol, ids[curSuffixIdx]);
                if (property == null) {
                    return null;
                }
                symbol = property;
                ++curSuffixIdx;
            }
            return symbol;
        }
        return null;
    }

    public static boolean isMethodBindingExpected(IStructuredDocumentContext context) {
        return SymbolResolveUtil.isMethodBindingExpected(context, null);
    }

    public static boolean isMethodBindingExpected(IStructuredDocumentContext context, List expectedBindings) {
        IDOMContextResolver domResolver = IStructuredDocumentContextResolverFactory.INSTANCE.getDOMContextResolver(context);
        Node curNode = domResolver.getNode();
        if (curNode instanceof Attr) {
            Attr attr = (Attr)curNode;
            Element element = attr.getOwnerElement();
            ITaglibContextResolver taglibResolver = IStructuredDocumentContextResolverFactory.INSTANCE.getTaglibContextResolver(context);
            String uri = taglibResolver.getTagURIForNodeName((Node)element);
            List<IMetaDataEnabledFeature> elVals = MetaDataEnabledProcessingFactory.getInstance().getAttributeValueRuntimeTypeFeatureProcessors(IValidELValues.class, context, uri, element.getLocalName(), attr.getLocalName());
            boolean methodBindingExpected = false;
            for (IValidELValues iValidELValues : elVals) {
                try {
                    CompositeType type = iValidELValues.getExpectedRuntimeType();
                    if (type == null || type.getAssignmentTypeMask() != 0) continue;
                    methodBindingExpected = true;
                    if (expectedBindings != null) {
                        expectedBindings.addAll((Collection)Arrays.asList(iValidELValues.getExpectedRuntimeType().getSignatures()));
                        continue;
                    }
                    return true;
                }
                catch (ELIsNotValidException eLIsNotValidException) {}
            }
            return methodBindingExpected;
        }
        return false;
    }
}

