/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.ws.internal.conformance;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jdt.core.IClassFile;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jst.ws.internal.WSPluginMessages;
import org.eclipse.jst.ws.internal.conformance.JAXRPCWebServiceRuleEngine;
import org.eclipse.jst.ws.internal.conformance.JavaWebServiceRuleSet;
import org.eclipse.jst.ws.internal.conformance.rules.JAXRPCRuleSetFactory;
import org.eclipse.osgi.util.NLS;

public class JAXRPCWebServiceAnalyzer {
    private JavaWebServiceRuleSet ruleSet_ = JAXRPCRuleSetFactory.newRuleSet();

    public JavaWebServiceRuleSet getRuleSet() {
        return this.ruleSet_;
    }

    public IStatus analyze(IProject project, IType rootClass, IProgressMonitor monitor) {
        JAXRPCWebServiceRuleEngine engine = new JAXRPCWebServiceRuleEngine(monitor);
        return engine.analyze(project, rootClass, this.ruleSet_);
    }

    public IStatus analyze(IProject project, String rootClass, IProgressMonitor monitor) {
        try {
            IType rootType = JAXRPCWebServiceAnalyzer.asType(rootClass, project);
            if (rootType == null) {
                String message = NLS.bind((String)WSPluginMessages.MSG_JAXRPC11_UNRESOLVED_CLASS, (Object)rootClass, (Object)project.getName());
                return new Status(4, "org.eclipse.jst.ws", 0, message, null);
            }
            return this.analyze(project, rootType, monitor);
        }
        catch (JavaModelException e) {
            return new Status(4, "org.eclipse.jst.ws", 0, "Internal error", (Throwable)e);
        }
    }

    public IStatus analyze(IProject project, IFile rootClass, IProgressMonitor monitor) {
        try {
            IType rootType = JAXRPCWebServiceAnalyzer.asType(rootClass);
            if (rootType == null) {
                String message = NLS.bind((String)WSPluginMessages.MSG_JAXRPC11_UNRESOLVED_CLASS, (Object)rootClass.getFullPath().toString(), (Object)project.getName());
                return new Status(4, "org.eclipse.jst.ws", 0, message, null);
            }
            return this.analyze(project, rootType, monitor);
        }
        catch (JavaModelException e) {
            return new Status(4, "org.eclipse.jst.ws", 0, "Internal error", (Throwable)e);
        }
    }

    private static IType asType(String qname, IProject project) throws JavaModelException {
        IType type = null;
        IJavaProject javaElement = JavaCore.create((IProject)project);
        if (javaElement instanceof IJavaProject) {
            IJavaProject javaProject = javaElement;
            type = javaProject.findType(qname);
        }
        return type;
    }

    private static IType asType(IFile file) throws JavaModelException {
        IType type = null;
        IJavaElement javaElement = JavaCore.create((IFile)file);
        if (javaElement instanceof ICompilationUnit) {
            ICompilationUnit compilationUnit = (ICompilationUnit)javaElement;
            type = compilationUnit.findPrimaryType();
        } else if (javaElement instanceof IClassFile) {
            IClassFile classFile = (IClassFile)javaElement;
            type = classFile.getType();
        }
        return type;
    }
}

