/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.ws.internal.explorer.platform.uddi.actions;

import java.net.MalformedURLException;
import java.net.URL;
import java.util.Hashtable;
import java.util.Properties;
import java.util.Vector;
import org.eclipse.wst.ws.internal.datamodel.Element;
import org.eclipse.wst.ws.internal.explorer.platform.perspective.Controller;
import org.eclipse.wst.ws.internal.explorer.platform.perspective.FormTool;
import org.eclipse.wst.ws.internal.explorer.platform.perspective.MessageQueue;
import org.eclipse.wst.ws.internal.explorer.platform.perspective.Node;
import org.eclipse.wst.ws.internal.explorer.platform.perspective.NodeManager;
import org.eclipse.wst.ws.internal.explorer.platform.perspective.ToolManager;
import org.eclipse.wst.ws.internal.explorer.platform.uddi.actions.UDDIPropertiesFormAction;
import org.eclipse.wst.ws.internal.explorer.platform.uddi.datamodel.CategoryModel;
import org.eclipse.wst.ws.internal.explorer.platform.uddi.datamodel.RegistryElement;
import org.eclipse.wst.ws.internal.explorer.platform.uddi.datamodel.UDDIMainElement;
import org.eclipse.wst.ws.internal.explorer.platform.uddi.perspective.UDDIMainNode;
import org.eclipse.wst.ws.internal.explorer.platform.uddi.perspective.UDDIPerspective;
import org.eclipse.wst.ws.internal.explorer.platform.util.MultipartFormDataException;
import org.eclipse.wst.ws.internal.explorer.platform.util.MultipartFormDataParser;
import org.eclipse.wst.ws.internal.explorer.platform.util.Validator;
import org.uddi4j.UDDIException;
import org.uddi4j.client.UDDIProxy;
import org.uddi4j.datatype.tmodel.TModel;
import org.uddi4j.response.TModelDetail;
import org.uddi4j.response.TModelInfo;
import org.uddi4j.response.TModelInfos;
import org.uddi4j.response.TModelList;
import org.uddi4j.transport.TransportException;
import org.uddi4j.util.CategoryBag;
import org.uddi4j.util.KeyedReference;

public class OpenRegistryAction
extends UDDIPropertiesFormAction {
    public OpenRegistryAction(Controller controller) {
        super(controller);
    }

    protected final boolean processParsedResults(MultipartFormDataParser parser) throws MultipartFormDataException {
        String registryName = parser.getParameter("registryName");
        String inquiryURL = parser.getParameter("inquiryURL");
        String publishURL = parser.getParameter("publishURL");
        String username = parser.getParameter("uddiUsername");
        String password = parser.getParameter("uddiPassword");
        String checkUserDefinedCategoriesChecked = parser.getParameter("checkUserDefinedCategories");
        String categoriesDirectory = parser.getParameter("categoriesDirectory");
        boolean inputsValid = true;
        UDDIPerspective uddiPerspective = this.controller_.getUDDIPerspective();
        MessageQueue messageQueue = uddiPerspective.getMessageQueue();
        FormTool formTool = this.getSelectedFormTool();
        if (registryName != null) {
            this.propertyTable_.put("registryName", registryName);
        }
        if (!Validator.validateString(registryName)) {
            inputsValid = false;
            formTool.flagError("registryName");
            messageQueue.addMessage(uddiPerspective.getMessage("MSG_ERROR_INVALID_REGISTRY_NAME"));
        }
        if (inquiryURL != null) {
            this.propertyTable_.put("inquiryURL", inquiryURL);
        }
        if (!Validator.validateURL(inquiryURL)) {
            inputsValid = false;
            formTool.flagError("inquiryURL");
            messageQueue.addMessage(uddiPerspective.getMessage("MSG_ERROR_INVALID_INQUIRY_URL"));
        }
        if (publishURL != null) {
            this.propertyTable_.put("publishURL", publishURL);
        }
        if (username != null) {
            this.propertyTable_.put("uddiUsername", username);
        }
        if (password != null) {
            this.propertyTable_.put("uddiPassword", password);
        }
        if (checkUserDefinedCategoriesChecked != null) {
            this.propertyTable_.put("checkUserDefinedCategories", checkUserDefinedCategoriesChecked);
        } else {
            this.removeProperty("checkUserDefinedCategories");
        }
        if (categoriesDirectory != null) {
            this.propertyTable_.put("categoriesDirectory", categoriesDirectory);
        } else {
            this.removeProperty("categoriesDirectory");
        }
        formTool.updatePropertyTable(this.propertyTable_);
        return inputsValid;
    }

    public final void gatherWSUserDefinedCategories(UDDIProxy proxy, Hashtable categoryModels) {
        try {
            CategoryBag categoryBag = new CategoryBag();
            categoryBag.add(new KeyedReference("", "categorization", "UUID:C1ACF26D-9672-4404-9D70-39B756E62AB4"));
            TModelList tModelList = proxy.find_tModel("%", categoryBag, null, null, 100);
            TModelInfos tModelInfos = tModelList.getTModelInfos();
            Vector<String> tModelKeyVector = new Vector<String>();
            int i = 0;
            while (i < tModelInfos.size()) {
                TModelInfo tModelInfo = tModelInfos.get(i);
                tModelKeyVector.addElement(tModelInfo.getTModelKey());
                ++i;
            }
            TModelDetail tModelDetail = proxy.get_tModelDetail(tModelKeyVector);
            Vector tModelVector = tModelDetail.getTModelVector();
            int i2 = 0;
            while (i2 < tModelVector.size()) {
                TModel tModel = (TModel)tModelVector.elementAt(i2);
                boolean checked = false;
                String displayName = null;
                String categoryKey = null;
                categoryBag = tModel.getCategoryBag();
                int j = 0;
                while (j < categoryBag.size()) {
                    KeyedReference kr = categoryBag.get(j);
                    String krTModelKey = kr.getTModelKey();
                    if (krTModelKey.equalsIgnoreCase("UUID:A035A07C-F362-44dd-8F95-E2B134BF43B4")) {
                        String krKeyName = kr.getKeyName();
                        if (krKeyName.equals("urn:x-ibm:uddi:customTaxonomy:key")) {
                            categoryKey = kr.getKeyValue();
                        } else if (krKeyName.equals("urn:x-ibm:uddi:customTaxonomy:displayName")) {
                            displayName = kr.getKeyValue();
                        }
                    } else if (krTModelKey.equalsIgnoreCase("UUID:C1ACF26D-9672-4404-9D70-39B756E62AB4")) {
                        checked = kr.getKeyValue().equals("checked");
                    }
                    ++j;
                }
                if (categoryKey != null) {
                    if (displayName == null) {
                        displayName = tModel.getNameString();
                    }
                    CategoryModel categoryModel = new CategoryModel();
                    categoryModel.setCategoryKey(categoryKey);
                    categoryModel.enableChecked(checked);
                    categoryModel.setDisplayName(displayName);
                    String tModelKey = tModel.getTModelKey();
                    categoryModel.setTModelKey(tModelKey);
                    categoryModels.put(tModelKey, categoryModel);
                }
                ++i2;
            }
        }
        catch (UDDIException uDDIException) {
        }
        catch (TransportException transportException) {}
    }

    public final boolean run() {
        UDDIPerspective uddiPerspective = this.controller_.getUDDIPerspective();
        MessageQueue messageQueue = uddiPerspective.getMessageQueue();
        try {
            String registryName = (String)this.propertyTable_.get("registryName");
            String inquiryURL = (String)this.propertyTable_.get("inquiryURL");
            String publishURL = (String)this.propertyTable_.get("publishURL");
            String registrationURL = (String)this.propertyTable_.get("registrationURL");
            String username = (String)this.propertyTable_.get("uddiUsername");
            String password = (String)this.propertyTable_.get("uddiPassword");
            boolean checkForUserDefinedCategoriesChecked = this.propertyTable_.get("checkUserDefinedCategories") != null;
            String categoriesDirectory = (String)this.propertyTable_.get("categoriesDirectory");
            String recognizedPublishURL = uddiPerspective.getKnownRegistryPublishURL(inquiryURL);
            String recognizedRegistrationURL = uddiPerspective.getKnownRegistryRegistrationURL(inquiryURL);
            if (publishURL == null) {
                publishURL = recognizedPublishURL;
            }
            if (registrationURL == null) {
                registrationURL = recognizedRegistrationURL;
            }
            UDDIMainNode uddiMainNode = (UDDIMainNode)this.controller_.getUDDIPerspective().getNavigatorManager().getRootNode();
            UDDIMainElement uddiMainElement = (UDDIMainElement)uddiMainNode.getTreeElement();
            Properties props = new Properties();
            props.put("org.uddi4j.TransportClassName", "org.uddi4j.transport.ApacheAxisTransport");
            UDDIProxy proxy = new UDDIProxy(props);
            proxy.setInquiryURL(new URL(inquiryURL));
            RegistryElement registryElement = new RegistryElement(proxy, inquiryURL, registryName, uddiMainElement.getModel());
            if (publishURL != null) {
                registryElement.setCachedPublishURL(publishURL);
            }
            if (registrationURL != null) {
                registryElement.setRegistrationURL(registrationURL);
            }
            if (username != null) {
                registryElement.setUserId(username);
            }
            if (password != null) {
                registryElement.setCred(password);
            }
            registryElement.setCheckForUserDefinedCategories(checkForUserDefinedCategoriesChecked);
            if (checkForUserDefinedCategoriesChecked) {
                Hashtable categoryModels = new Hashtable();
                this.gatherWSUserDefinedCategories(proxy, categoryModels);
                if (categoryModels.size() > 0) {
                    registryElement.setUserDefinedCategories(categoryModels);
                }
            }
            registryElement.setCategoriesDirectory(categoriesDirectory);
            uddiMainElement.connect((Element)registryElement, "registries", "owner");
            NodeManager nodeManager = uddiMainNode.getNodeManager();
            int newRegistryNodeId = uddiMainNode.getChildNode(registryElement).getNodeId();
            nodeManager.setSelectedNodeId(newRegistryNodeId);
            Node registryNode = nodeManager.getSelectedNode();
            ToolManager toolManager = registryNode.getCurrentToolManager();
            this.addToHistory(0, toolManager.getSelectedTool().getSelectToolActionHref(true));
            messageQueue.addMessage(uddiPerspective.getMessage("MSG_INFO_REGISTRY_OPENED", new String[]{registryName, inquiryURL}));
            return true;
        }
        catch (MalformedURLException e) {
            messageQueue.addMessage(this.controller_.getMessage("MSG_ERROR_UNEXPECTED"));
            messageQueue.addMessage("MalformedURLException");
            messageQueue.addMessage(e.getMessage());
            FormTool formTool = this.getSelectedFormTool();
            formTool.flagError("inquiryURL");
            return false;
        }
    }
}

