/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.jsf.core.internal.jsflibraryconfig;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.resources.IProject;
import org.eclipse.jst.jsf.core.internal.Messages;
import org.eclipse.jst.jsf.core.internal.jsflibraryconfig.JSFLibraryConfigProjectData;
import org.eclipse.jst.jsf.core.internal.jsflibraryconfig.JSFLibraryConfiglModelSource;
import org.eclipse.jst.jsf.core.internal.jsflibraryconfig.JSFLibraryInternalReference;
import org.eclipse.jst.jsf.core.internal.jsflibraryconfig.JSFLibraryRegistryUtil;
import org.eclipse.jst.jsf.core.internal.project.facet.IJSFFacetInstallDataModelProperties;

public class JSFLibraryConfigModel {
    private final JSFLibraryConfiglModelSource data;
    private final JSFLibraryRegistryUtil jsfLibReg;
    private List colJSFImplLib;
    private List colJSFCompLib;

    private JSFLibraryConfigModel(JSFLibraryConfiglModelSource data) {
        this.data = data;
        this.jsfLibReg = JSFLibraryRegistryUtil.getInstance();
    }

    public IJSFFacetInstallDataModelProperties.IMPLEMENTATION_TYPE getImplementationType() {
        return this.data.getImplementationType();
    }

    public List getJSFImplementationLibraries() {
        if (this.colJSFImplLib == null) {
            JSFLibraryInternalReference srcLib;
            this.colJSFImplLib = this.jsfLibReg.getJSFImplementationLibraries();
            JSFLibraryInternalReference targetLib = this.data.getJSFImplementationLibrary();
            if (targetLib == null) {
                targetLib = this.jsfLibReg.getDefaultJSFImplementationLibrary();
            }
            if (targetLib != null && (srcLib = this.jsfLibReg.getJSFLibraryReferencebyID(targetLib.getID())) != null) {
                srcLib.setSelected(true);
                srcLib.setToBeDeployed(targetLib.isCheckedToBeDeployed());
            }
        }
        return this.colJSFImplLib;
    }

    public List getJSFComponentLibraries() {
        if (this.colJSFCompLib == null) {
            this.colJSFCompLib = this.jsfLibReg.getJSFComponentLibraries();
            Iterator it = this.data.getJSFComponentLibraries().iterator();
            JSFLibraryInternalReference targetItem = null;
            JSFLibraryInternalReference srcItem = null;
            while (it.hasNext()) {
                targetItem = (JSFLibraryInternalReference)it.next();
                srcItem = this.jsfLibReg.getJSFLibraryReferencebyID(targetItem.getID());
                if (srcItem == null) continue;
                srcItem.setSelected(true);
                srcItem.setToBeDeployed(targetItem.isCheckedToBeDeployed());
            }
        }
        return this.colJSFCompLib;
    }

    public JSFLibraryInternalReference getCurrentJSFImplementationLibrarySelection() {
        Iterator it = this.getJSFImplementationLibraries().iterator();
        JSFLibraryInternalReference crtItem = null;
        while (it.hasNext()) {
            crtItem = (JSFLibraryInternalReference)it.next();
            if (!crtItem.isSelected()) continue;
            return crtItem;
        }
        return null;
    }

    public List getCurrentJSFComponentLibrarySelection() {
        ArrayList<JSFLibraryInternalReference> list = new ArrayList<JSFLibraryInternalReference>();
        Iterator it = this.getJSFComponentLibraries().iterator();
        JSFLibraryInternalReference crtItem = null;
        while (it.hasNext()) {
            crtItem = (JSFLibraryInternalReference)it.next();
            if (!crtItem.isSelected()) continue;
            list.add(crtItem);
        }
        return list;
    }

    public JSFLibraryInternalReference getSavedJSFImplementationLibrary() {
        return this.data.getJSFImplementationLibrary();
    }

    public List getSavedJSFComponentLibraries() {
        return this.data.getJSFComponentLibraries();
    }

    public void setCurrentJSFImplementationLibrarySelection(JSFLibraryInternalReference library) {
        if (library != null) {
            Iterator it = this.getJSFImplementationLibraries().iterator();
            JSFLibraryInternalReference crtjsflib = null;
            while (it.hasNext()) {
                crtjsflib = (JSFLibraryInternalReference)it.next();
                if (crtjsflib.getID().equals(library.getID())) {
                    crtjsflib.setSelected(true);
                    crtjsflib.setToBeDeployed(library.isCheckedToBeDeployed());
                    continue;
                }
                crtjsflib.setSelected(false);
            }
        }
    }

    public void setCurrentJSFComponentLibrarySelection(List libraries) {
        if (libraries != null) {
            this.setJSFLibrariesSelection(this.getJSFComponentLibraries(), false);
            Iterator it = libraries.iterator();
            JSFLibraryInternalReference srcItem = null;
            while (it.hasNext()) {
                JSFLibraryInternalReference crtItem = (JSFLibraryInternalReference)it.next();
                srcItem = this.jsfLibReg.getJSFLibraryReferencebyID(crtItem.getID());
                if (srcItem == null) continue;
                srcItem.setSelected(true);
                srcItem.setToBeDeployed(crtItem.isCheckedToBeDeployed());
            }
        }
    }

    public void saveData(IProject project) {
        JSFLibraryConfigProjectData data_ = new JSFLibraryConfigProjectData(project);
        ArrayList<JSFLibraryInternalReference> implLibs = new ArrayList<JSFLibraryInternalReference>();
        implLibs.add(this.getCurrentJSFImplementationLibrarySelection());
        data_.saveData(implLibs, this.getCurrentJSFComponentLibrarySelection(), this.getImplementationType());
    }

    private void setJSFLibrariesSelection(List libs, boolean state) {
        for (JSFLibraryInternalReference crtjsflib : libs) {
            crtjsflib.setSelected(state);
        }
    }

    /* synthetic */ JSFLibraryConfigModel(JSFLibraryConfiglModelSource jSFLibraryConfiglModelSource, JSFLibraryConfigModel jSFLibraryConfigModel) {
        this(jSFLibraryConfiglModelSource);
    }

    public static final class JSFLibraryConfigModelFactory {
        public static JSFLibraryConfigModel createInstance(JSFLibraryConfiglModelSource source) {
            if (source == null) {
                throw new NullPointerException(Messages.JSFLibraryConfigModel_Null_Data_Source);
            }
            return new JSFLibraryConfigModel(source, null);
        }
    }
}

