/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.common.componentcore.internal.util;

import java.util.Hashtable;
import java.util.Map;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.ISafeRunnable;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.SafeRunner;
import org.eclipse.jem.util.RegistryReader;
import org.eclipse.jem.util.emf.workbench.ISynchronizerExtender;
import org.eclipse.jem.util.emf.workbench.ProjectResourceSet;
import org.eclipse.jem.util.emf.workbench.WorkbenchResourceHelperBase;
import org.eclipse.wst.common.componentcore.ModuleCoreNature;
import org.eclipse.wst.common.componentcore.internal.ModulecorePlugin;
import org.eclipse.wst.common.componentcore.internal.resources.ResourceTimestampMappings;
import org.eclipse.wst.common.componentcore.internal.resources.VirtualArchiveComponent;
import org.eclipse.wst.common.componentcore.internal.resources.VirtualComponent;
import org.eclipse.wst.common.componentcore.internal.resources.VirtualFolder;
import org.eclipse.wst.common.componentcore.internal.util.IComponentImplFactory;
import org.eclipse.wst.common.componentcore.resources.IVirtualComponent;
import org.eclipse.wst.common.componentcore.resources.IVirtualFolder;
import org.eclipse.wst.common.project.facet.core.IFacetedProject;
import org.eclipse.wst.common.project.facet.core.IProjectFacet;
import org.eclipse.wst.common.project.facet.core.ProjectFacetsManager;

public class ComponentImplManager
implements ISynchronizerExtender {
    private static final String NO_FACETS = "NONE";
    private static final String COMPONENT_IMPL_EXTENSION_POINT = "componentimpl";
    private static final String TAG_COMPONENT_IMPL = "componentimpl";
    private static final String ATT_TYPE = "typeID";
    private static final String ATT_CLASS = "class";
    private static final ComponentImplManager instance = new ComponentImplManager();
    private final Map descriptors = new Hashtable();
    private final Map instances = new Hashtable();

    public static ComponentImplManager instance() {
        return instance;
    }

    public ComponentImplManager() {
        SafeRunner.run((ISafeRunnable)new ISafeRunnable(){

            public void handleException(Throwable exception) {
                ModulecorePlugin.logError(0, exception.getMessage(), exception);
            }

            public void run() throws Exception {
                new ComponentImplRegistryReader().readRegistry();
            }
        });
    }

    private IComponentImplFactory getComponentImplFactory(String typeID) {
        ComponentImplDescriptor descriptor = (ComponentImplDescriptor)this.descriptors.get(typeID);
        IComponentImplFactory factory = null;
        if (descriptor != null && (factory = (IComponentImplFactory)this.instances.get(descriptor)) == null) {
            factory = descriptor.createFactory();
            if (factory != null) {
                this.instances.put(descriptor, factory);
            } else {
                this.descriptors.remove(descriptor);
            }
        }
        return factory;
    }

    private IComponentImplFactory findFactoryForProject(IProject project, Map descriptors) {
        try {
            IComponentImplFactory factory = ComponentCacheManager.instance().getComponentImplFactory(project);
            if (factory != null) {
                return factory;
            }
            IFacetedProject facetedProject = ProjectFacetsManager.create((IProject)project);
            if (facetedProject == null) {
                factory = this.getComponentImplFactory(NO_FACETS);
                ComponentCacheManager.instance().setComponentImplFactory(project, factory);
                return factory;
            }
            for (String typeID : descriptors.keySet()) {
                if (typeID.equals(NO_FACETS)) continue;
                try {
                    IProjectFacet projectFacet = ProjectFacetsManager.getProjectFacet((String)typeID);
                    if (projectFacet == null || !facetedProject.hasProjectFacet(projectFacet) || (factory = this.getComponentImplFactory(typeID)) == null) continue;
                    ComponentCacheManager.instance().setComponentImplFactory(project, factory);
                    return factory;
                }
                catch (Exception exception) {}
            }
        }
        catch (Exception e) {
            ModulecorePlugin.logError(0, "Returning null factory for project: " + project, e);
            ComponentCacheManager.instance().markErrorComponentImplFactory(project);
        }
        return null;
    }

    public IVirtualFolder createFolder(IProject aProject, IPath aRuntimePath) {
        try {
            IComponentImplFactory factory = this.findFactoryForProject(aProject, this.descriptors);
            if (factory != null) {
                return factory.createFolder(aProject, aRuntimePath);
            }
        }
        catch (Exception exception) {}
        ComponentCacheManager.instance().setComponentImplFactory(aProject, null);
        return new VirtualFolder(aProject, aRuntimePath);
    }

    public IVirtualComponent createComponent(IProject project) {
        return this.createComponent(project, true);
    }

    public IVirtualComponent createComponent(IProject project, boolean checkSettings) {
        IVirtualComponent component;
        try {
            component = ComponentCacheManager.instance().getComponent(project);
            if (component != null) {
                return component;
            }
            IComponentImplFactory factory = this.findFactoryForProject(project, this.descriptors);
            if (factory != null) {
                component = factory.createComponent(project);
                if (component != null) {
                    ComponentCacheManager.instance().setComponent(project, component);
                    this.registerListener(project);
                }
                return component;
            }
        }
        catch (Exception exception) {}
        if (checkSettings ? !ModuleCoreNature.isFlexibleProject(project) : ModuleCoreNature.getModuleCoreNature(project) == null) {
            return null;
        }
        component = new VirtualComponent(project, (IPath)new Path("/"));
        if (component != null) {
            ComponentCacheManager.instance().setComponentImplFactory(project, null);
            ComponentCacheManager.instance().setComponent(project, component);
            this.registerListener(project);
        }
        return component;
    }

    public IVirtualComponent createArchiveComponent(IProject aProject, String aComponentName) {
        try {
            IComponentImplFactory factory;
            IVirtualComponent component = ComponentCacheManager.instance().getArchiveComponent(aProject, aComponentName);
            if (component != null) {
                return component;
            }
            if (!ComponentCacheManager.instance().isValidComponentImplFactory(aProject)) {
                this.registerListener(aProject);
            }
            if ((factory = this.findFactoryForProject(aProject, this.descriptors)) != null) {
                IVirtualComponent archiveComponent = factory.createArchiveComponent(aProject, aComponentName, (IPath)new Path("/"));
                ComponentCacheManager.instance().setArchiveComponent(aProject, aComponentName, archiveComponent);
                return archiveComponent;
            }
        }
        catch (Exception exception) {}
        ComponentCacheManager.instance().setComponentImplFactory(aProject, null);
        VirtualArchiveComponent archiveComponent = new VirtualArchiveComponent(aProject, aComponentName, (IPath)new Path("/"));
        ComponentCacheManager.instance().setArchiveComponent(aProject, aComponentName, archiveComponent);
        return archiveComponent;
    }

    private void registerListener(IProject aProject) {
        ProjectResourceSet resSet = this.getResourceSet(aProject);
        if (resSet == null) {
            return;
        }
        resSet.getSynchronizer().addExtender((ISynchronizerExtender)this);
    }

    protected ProjectResourceSet getResourceSet(IProject proj) {
        return (ProjectResourceSet)WorkbenchResourceHelperBase.getResourceSet((IProject)proj);
    }

    public void projectChanged(IResourceDelta delta) {
    }

    public synchronized void projectClosed() {
        ComponentCacheManager.instance().clearCache();
    }

    private static class ComponentCacheManager {
        private static final ComponentCacheManager instance = new ComponentCacheManager();
        private final ResourceTimestampMappings factoryMap = new ResourceTimestampMappings();
        private final Map<IProject, IVirtualComponent> componentsMap = new Hashtable<IProject, IVirtualComponent>();
        private final Map<IProject, Map<String, IVirtualComponent>> componentsArchivesMap = new Hashtable<IProject, Map<String, IVirtualComponent>>();
        private Object cacheLock = new Object();

        public static ComponentCacheManager instance() {
            return instance;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public IComponentImplFactory getComponentImplFactory(IProject project) {
            Object object = this.cacheLock;
            synchronized (object) {
                Object data;
                if (this.isValidComponentImplFactory(project) && (data = this.factoryMap.getData((IResource)project)) instanceof IComponentImplFactory) {
                    return (IComponentImplFactory)data;
                }
                return null;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean isValidComponentImplFactory(IProject project) {
            Object object = this.cacheLock;
            synchronized (object) {
                block4: {
                    if (this.factoryMap.hasChanged((IResource)project) || this.factoryMap.hasCacheError((IResource)project) || !this.factoryMap.hasCacheData((IResource)project)) break block4;
                    return true;
                }
                return false;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void setComponentImplFactory(IProject project, IComponentImplFactory factory) {
            Object object = this.cacheLock;
            synchronized (object) {
                if (factory != null) {
                    this.factoryMap.mark((IResource)project, factory);
                } else {
                    this.factoryMap.mark((IResource)project, project);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void markErrorComponentImplFactory(IProject project) {
            Object object = this.cacheLock;
            synchronized (object) {
                this.factoryMap.markError((IResource)project);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public IVirtualComponent getComponent(IProject project) {
            Object object = this.cacheLock;
            synchronized (object) {
                if (this.componentsMap.containsKey(project)) {
                    if (this.isValidComponentImplFactory(project)) {
                        return this.componentsMap.get(project);
                    }
                    this.componentsMap.remove(project);
                }
                return null;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void setComponent(IProject project, IVirtualComponent component) {
            Object object = this.cacheLock;
            synchronized (object) {
                if (component != null) {
                    this.componentsMap.put(project, component);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public IVirtualComponent getArchiveComponent(IProject project, String componentName) {
            Object object = this.cacheLock;
            synchronized (object) {
                Hashtable archives = this.getComponentArchives(project);
                if (this.isValidComponentImplFactory(project)) {
                    if (archives.containsKey(componentName)) {
                        return (IVirtualComponent)archives.get(componentName);
                    }
                } else {
                    archives = new Hashtable();
                    this.componentsArchivesMap.put(project, archives);
                }
                return null;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Map getComponentArchives(IProject project) {
            Object object = this.cacheLock;
            synchronized (object) {
                Map<String, IVirtualComponent> archives = this.componentsArchivesMap.get(project);
                if (archives == null) {
                    archives = new Hashtable<String, IVirtualComponent>();
                    this.componentsArchivesMap.put(project, archives);
                }
                return archives;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void setArchiveComponent(IProject project, String componentName, IVirtualComponent archiveComponent) {
            Object object = this.cacheLock;
            synchronized (object) {
                if (archiveComponent != null) {
                    Map archives = ComponentCacheManager.instance().getComponentArchives(project);
                    archives.put(componentName, archiveComponent);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void clearCache() {
            Object[] components = null;
            Object[] componentsArchives = null;
            Object object = this.cacheLock;
            synchronized (object) {
                components = this.componentsMap.values().toArray();
                this.componentsMap.clear();
                componentsArchives = this.componentsArchivesMap.values().toArray();
                this.componentsArchivesMap.clear();
            }
            int i = 0;
            while (i < components.length) {
                if (components[i] instanceof VirtualComponent) {
                    ((VirtualComponent)components[i]).dispose();
                }
                ++i;
            }
            i = 0;
            while (i < componentsArchives.length) {
                if (componentsArchives[i] instanceof VirtualComponent) {
                    ((VirtualComponent)componentsArchives[i]).dispose();
                }
                ++i;
            }
        }
    }

    private class ComponentImplDescriptor {
        private final IConfigurationElement element;
        private final String type;

        public ComponentImplDescriptor(IConfigurationElement configElement) {
            this.element = configElement;
            this.type = this.element.getAttribute(ComponentImplManager.ATT_TYPE);
        }

        public IComponentImplFactory createFactory() {
            final IComponentImplFactory[] factory = new IComponentImplFactory[1];
            SafeRunner.run((ISafeRunnable)new ISafeRunnable(){

                public void handleException(Throwable exception) {
                    ModulecorePlugin.logError(0, exception.getMessage(), exception);
                }

                public void run() throws Exception {
                    factory[0] = (IComponentImplFactory)ComponentImplDescriptor.this.element.createExecutableExtension(ComponentImplManager.ATT_CLASS);
                }
            });
            return factory[0];
        }

        public String getType() {
            return this.type;
        }
    }

    private class ComponentImplRegistryReader
    extends RegistryReader {
        public ComponentImplRegistryReader() {
            super("org.eclipse.wst.common.modulecore", "componentimpl");
        }

        public boolean readElement(IConfigurationElement element) {
            if ("componentimpl".equals(element.getName())) {
                String type = element.getAttribute(ComponentImplManager.ATT_TYPE);
                if (type != null) {
                    ComponentImplManager.this.descriptors.put(element.getAttribute(ComponentImplManager.ATT_TYPE), new ComponentImplDescriptor(element));
                } else {
                    ModulecorePlugin.logError(0, "No type attribute is specified for org.eclipse.wst.common.modulecore.componentimpl extension in " + element.getDeclaringExtension().getNamespaceIdentifier(), null);
                }
                return true;
            }
            return false;
        }
    }
}

