/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.j2ee.model;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import java.util.WeakHashMap;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.impl.AdapterImpl;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.jem.util.logger.proxy.Logger;
import org.eclipse.jst.j2ee.internal.common.J2EECommonMessages;
import org.eclipse.jst.j2ee.internal.plugin.J2EEPlugin;
import org.eclipse.jst.j2ee.internal.project.J2EEProjectUtilities;
import org.eclipse.jst.j2ee.model.IModelProvider;
import org.eclipse.jst.j2ee.model.IModelProviderEvent;
import org.eclipse.jst.j2ee.model.IModelProviderFactory;
import org.eclipse.jst.j2ee.model.IModelProviderListener;
import org.eclipse.jst.j2ee.model.J2EEModelProviderRegistry;
import org.eclipse.jst.j2ee.model.ModelProviderEvent;
import org.eclipse.wst.common.componentcore.resources.IVirtualComponent;
import org.eclipse.wst.common.internal.emf.resource.CompatibilityXMIResource;
import org.eclipse.wst.common.internal.emfworkbench.WorkbenchResourceHelper;
import org.eclipse.wst.common.project.facet.core.IFacetedProject;
import org.eclipse.wst.common.project.facet.core.IProjectFacet;
import org.eclipse.wst.common.project.facet.core.IProjectFacetVersion;
import org.eclipse.wst.common.project.facet.core.ProjectFacetsManager;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ModelProviderManager {
    private static WeakHashMap modelsProviders = new WeakHashMap();
    private static final int DEFAULT_PRIORITY = 100;
    private static HashMap providers;
    protected static HashMap resourceSetListeners;
    private static J2EEModelProviderRegistry registry;

    public static IModelProvider getModelProvider(IProject project, IProjectFacetVersion vers) {
        IModelProviderFactory factory = ModelProviderManager.getProvider(vers);
        if (factory != null) {
            ModelProviderManager.startListeningToResourceSet(project);
            return factory.create(project);
        }
        String errorMessage = J2EECommonMessages.getResourceString(J2EECommonMessages.ERR_NO_MODEL_PROVIDER_FOR_PROJECT, new Object[]{project, vers});
        NullPointerException error = new NullPointerException(errorMessage);
        J2EEPlugin.INSTANCE.getLogger().logError((Throwable)error);
        return null;
    }

    public static IModelProvider getModelProvider(IVirtualComponent aModule, IProjectFacetVersion vers) {
        IModelProviderFactory factory = ModelProviderManager.getProvider(vers);
        if (factory != null) {
            IModelProvider mp = factory.create(aModule);
            ModelProviderManager.addProvider(mp);
            return mp;
        }
        String errorMessage = J2EECommonMessages.getResourceString(J2EECommonMessages.ERR_NO_MODEL_PROVIDER_FOR_PROJECT, new Object[]{aModule, vers});
        NullPointerException error = new NullPointerException(errorMessage);
        J2EEPlugin.INSTANCE.getLogger().logError((Throwable)error);
        return null;
    }

    private static void addProvider(IModelProvider mp) {
        modelsProviders.put(mp, null);
    }

    private static void addedResource(Resource addedResource) {
        if (addedResource != null && addedResource instanceof CompatibilityXMIResource) {
            ((CompatibilityXMIResource)addedResource).setFormat(1);
        }
        IProject proj = WorkbenchResourceHelper.getProject((Resource)addedResource);
        ModelProviderEvent event = new ModelProviderEvent(8, null, proj);
        event.addResource(addedResource);
        ModelProviderManager.notifyModelProviders(event);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static void notifyModelProviders(IModelProviderEvent anEvent) {
        if (anEvent == null || modelsProviders.size() == 0) {
            return;
        }
        ArrayList aList = new ArrayList();
        WeakHashMap weakHashMap = modelsProviders;
        synchronized (weakHashMap) {
            aList.addAll(modelsProviders.keySet());
        }
        int i = 0;
        while (i < aList.size()) {
            IModelProvider mod = (IModelProvider)aList.get(i);
            try {
                if (mod instanceof IModelProviderListener) {
                    ((IModelProviderListener)((Object)mod)).modelsChanged(anEvent);
                }
            }
            catch (Exception e) {
                Logger.getLogger().logError((Throwable)e);
            }
            ++i;
        }
    }

    private static void removedResource(Resource removedResource) {
        IProject proj = WorkbenchResourceHelper.getProject((Resource)removedResource);
        ModelProviderEvent event = new ModelProviderEvent(4, null, proj);
        event.addResource(removedResource);
        ModelProviderManager.notifyModelProviders(event);
    }

    private static void removedResources(List removedResources) {
        Resource firstRes = (Resource)removedResources.get(0);
        IProject proj = WorkbenchResourceHelper.getProject((Resource)firstRes);
        ModelProviderEvent event = new ModelProviderEvent(4, null, proj);
        event.addResources(removedResources);
        ModelProviderManager.notifyModelProviders(event);
    }

    public static void registerProvider(IModelProviderFactory providerFactory, IProjectFacetVersion v, String priority) {
        int currentPriority;
        int newPriority = priority != null ? Integer.parseInt(priority) : 100;
        if (newPriority <= (currentPriority = ModelProviderManager.getProviderPriority(v))) {
            ModelProviderKey key = ModelProviderManager.createProviderKey(v, newPriority);
            ModelProviderManager.getProviders().put(key, providerFactory);
        }
    }

    private static IModelProviderFactory getProvider(IProjectFacetVersion v) {
        Set<ModelProviderKey> keys = ModelProviderManager.getProviders().keySet();
        for (ModelProviderKey key : keys) {
            if (!key.version.equals(v)) continue;
            return (IModelProviderFactory)providers.get(key);
        }
        return null;
    }

    private static int getProviderPriority(IProjectFacetVersion v) {
        Set<ModelProviderKey> keys = ModelProviderManager.getProviders().keySet();
        for (ModelProviderKey key : keys) {
            if (!key.version.equals(v)) continue;
            return key.priority;
        }
        return 100;
    }

    protected static Adapter getResourceSetListener(IProject project) {
        Object listener;
        if (resourceSetListeners == null) {
            resourceSetListeners = new HashMap();
        }
        if ((listener = (Adapter)resourceSetListeners.get(project)) == null) {
            listener = new ResourceSetListener();
            resourceSetListeners.put(project, listener);
        }
        return listener;
    }

    private static void initProviders() {
        if (registry == null && providers == null) {
            providers = new HashMap();
            registry = J2EEModelProviderRegistry.getInstance();
        }
    }

    private static void startListeningToResourceSet(IProject project) {
        ResourceSet set = WorkbenchResourceHelper.getResourceSet((IProject)project);
        Adapter listener = ModelProviderManager.getResourceSetListener(project);
        if (set != null && !set.eAdapters().contains((Object)listener)) {
            set.eAdapters().add((Object)listener);
        }
    }

    private static ModelProviderKey createProviderKey(IProjectFacetVersion fv, int priority) {
        ModelProviderKey key = new ModelProviderKey();
        key.priority = priority;
        key.version = fv;
        return key;
    }

    public static IModelProvider getModelProvider(IProject proj) {
        IProjectFacetVersion facetVersion = ModelProviderManager.getDefaultFacet(proj);
        return ModelProviderManager.getModelProvider(proj, facetVersion);
    }

    public static IModelProvider getModelProvider(IVirtualComponent aModule) {
        IProjectFacetVersion facetVersion = ModelProviderManager.getDefaultFacet(aModule);
        return ModelProviderManager.getModelProvider(aModule, facetVersion);
    }

    private static IProjectFacetVersion getDefaultFacet(IProject proj) {
        String type = J2EEProjectUtilities.getJ2EEProjectType(proj);
        IProjectFacet facet = ProjectFacetsManager.getProjectFacet((String)type);
        IFacetedProject fp = null;
        try {
            fp = ProjectFacetsManager.create((IProject)proj);
        }
        catch (CoreException e) {
            e.printStackTrace();
        }
        if (fp != null && facet != null) {
            return fp.getInstalledVersion(facet);
        }
        return null;
    }

    private static IProjectFacetVersion getDefaultFacet(IVirtualComponent aModule) {
        String type = J2EEProjectUtilities.getJ2EEComponentType(aModule);
        IProjectFacet facet = ProjectFacetsManager.getProjectFacet((String)type);
        IFacetedProject fp = null;
        try {
            if (!aModule.isBinary()) {
                fp = ProjectFacetsManager.create((IProject)aModule.getProject());
            }
        }
        catch (CoreException e) {
            e.printStackTrace();
        }
        if (fp != null && facet != null) {
            return fp.getInstalledVersion(facet);
        }
        return null;
    }

    private static synchronized HashMap<ModelProviderKey, IModelProviderFactory> getProviders() {
        if (registry == null) {
            ModelProviderManager.initProviders();
        }
        return providers;
    }

    public static class ModelProviderKey {
        protected IProjectFacetVersion version;
        protected int priority;

        public boolean equals(Object aOther) {
            if (this == aOther) {
                return true;
            }
            ModelProviderKey otherKey = (ModelProviderKey)aOther;
            return this.version.equals(otherKey.version);
        }

        public int hashCode() {
            return this.version.hashCode();
        }
    }

    private static class ResourceSetListener
    extends AdapterImpl {
        private ResourceSetListener() {
        }

        public void notifyChanged(Notification notification) {
            switch (notification.getEventType()) {
                case 3: {
                    ModelProviderManager.addedResource((Resource)notification.getNewValue());
                    break;
                }
                case 4: {
                    ModelProviderManager.removedResource((Resource)notification.getOldValue());
                    break;
                }
                case 6: {
                    ModelProviderManager.removedResources((List)notification.getOldValue());
                }
            }
        }
    }
}

