/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.corext.refactoring.structure;

import java.util.ArrayList;
import java.util.Arrays;
import org.eclipse.ltk.core.refactoring.RefactoringStatus;
import org.eclipse.ltk.core.refactoring.RefactoringStatusContext;
import org.eclipse.wst.jsdt.core.IField;
import org.eclipse.wst.jsdt.core.IFunction;
import org.eclipse.wst.jsdt.core.IMember;
import org.eclipse.wst.jsdt.core.IType;
import org.eclipse.wst.jsdt.core.ITypeRoot;
import org.eclipse.wst.jsdt.core.JavaScriptModelException;
import org.eclipse.wst.jsdt.internal.corext.refactoring.Checks;
import org.eclipse.wst.jsdt.internal.corext.refactoring.RefactoringCoreMessages;
import org.eclipse.wst.jsdt.internal.corext.refactoring.base.JavaStatusContext;
import org.eclipse.wst.jsdt.internal.corext.util.JavaModelUtil;
import org.eclipse.wst.jsdt.internal.corext.util.Messages;

class MemberCheckUtil {
    private MemberCheckUtil() {
    }

    public static RefactoringStatus checkMembersInDestinationType(IMember[] members, IType destinationType) throws JavaScriptModelException {
        RefactoringStatus result = new RefactoringStatus();
        int i = 0;
        while (i < members.length) {
            if (members[i].getElementType() == 9) {
                MemberCheckUtil.checkMethodInType(destinationType, result, (IFunction)members[i]);
            } else if (members[i].getElementType() == 8) {
                MemberCheckUtil.checkFieldInType(destinationType, result, (IField)members[i]);
            } else if (members[i].getElementType() == 7) {
                MemberCheckUtil.checkTypeInType(destinationType, result, (IType)members[i]);
            }
            ++i;
        }
        return result;
    }

    private static void checkMethodInType(IType destinationType, RefactoringStatus result, IFunction method) throws JavaScriptModelException {
        IFunction[] destinationTypeMethods = destinationType.getFunctions();
        IFunction found = MemberCheckUtil.findMethod(method, destinationTypeMethods);
        if (found != null) {
            RefactoringStatusContext context = JavaStatusContext.create((ITypeRoot)destinationType.getJavaScriptUnit(), found.getSourceRange());
            String message = Messages.format(RefactoringCoreMessages.MemberCheckUtil_signature_exists, new String[]{method.getElementName(), JavaModelUtil.getFullyQualifiedName(destinationType)});
            result.addError(message, context);
        } else {
            IFunction similar = Checks.findMethod(method, destinationType);
            if (similar != null) {
                String message = Messages.format(RefactoringCoreMessages.MemberCheckUtil_same_param_count, new String[]{method.getElementName(), JavaModelUtil.getFullyQualifiedName(destinationType)});
                RefactoringStatusContext context = JavaStatusContext.create((ITypeRoot)destinationType.getJavaScriptUnit(), similar.getSourceRange());
                result.addWarning(message, context);
            }
        }
    }

    private static void checkFieldInType(IType destinationType, RefactoringStatus result, IField field) throws JavaScriptModelException {
        IField destinationTypeField = destinationType.getField(field.getElementName());
        if (!destinationTypeField.exists()) {
            return;
        }
        String message = Messages.format(RefactoringCoreMessages.MemberCheckUtil_field_exists, new String[]{field.getElementName(), JavaModelUtil.getFullyQualifiedName(destinationType)});
        RefactoringStatusContext context = JavaStatusContext.create((ITypeRoot)destinationType.getJavaScriptUnit(), destinationTypeField.getSourceRange());
        result.addError(message, context);
    }

    private static void checkTypeInType(IType destinationType, RefactoringStatus result, IType type) throws JavaScriptModelException {
        String typeName = type.getElementName();
        IType destinationTypeType = destinationType.getType(typeName);
        if (destinationTypeType.exists()) {
            String message = Messages.format(RefactoringCoreMessages.MemberCheckUtil_type_name_conflict0, new String[]{typeName, JavaModelUtil.getFullyQualifiedName(destinationType)});
            RefactoringStatusContext context = JavaStatusContext.create((ITypeRoot)destinationType.getJavaScriptUnit(), destinationTypeType.getNameRange());
            result.addError(message, context);
        } else {
            RefactoringStatusContext context;
            String message;
            if (destinationType.getElementName().equals(typeName)) {
                message = Messages.format(RefactoringCoreMessages.MemberCheckUtil_type_name_conflict1, new String[]{JavaModelUtil.getFullyQualifiedName(type)});
                context = JavaStatusContext.create((ITypeRoot)destinationType.getJavaScriptUnit(), destinationType.getNameRange());
                result.addError(message, context);
            }
            if (MemberCheckUtil.typeNameExistsInEnclosingTypeChain(destinationType, typeName)) {
                message = Messages.format(RefactoringCoreMessages.MemberCheckUtil_type_name_conflict2, new String[]{JavaModelUtil.getFullyQualifiedName(type)});
                context = JavaStatusContext.create((ITypeRoot)destinationType.getJavaScriptUnit(), destinationType.getNameRange());
                result.addError(message, context);
            }
            MemberCheckUtil.checkHierarchyOfEnclosedTypes(destinationType, result, type);
        }
    }

    private static void checkHierarchyOfEnclosedTypes(IType destinationType, RefactoringStatus result, IType type) throws JavaScriptModelException {
        IType[] enclosedTypes = MemberCheckUtil.getAllEnclosedTypes(type);
        int i = 0;
        while (i < enclosedTypes.length) {
            RefactoringStatusContext context;
            String message;
            IType enclosedType = enclosedTypes[i];
            if (destinationType.getElementName().equals(enclosedType.getElementName())) {
                message = Messages.format(RefactoringCoreMessages.MemberCheckUtil_type_name_conflict3, new String[]{JavaModelUtil.getFullyQualifiedName(enclosedType), JavaModelUtil.getFullyQualifiedName(type)});
                context = JavaStatusContext.create((ITypeRoot)destinationType.getJavaScriptUnit(), destinationType.getNameRange());
                result.addError(message, context);
            }
            if (MemberCheckUtil.typeNameExistsInEnclosingTypeChain(destinationType, enclosedType.getElementName())) {
                message = Messages.format(RefactoringCoreMessages.MemberCheckUtil_type_name_conflict4, new String[]{JavaModelUtil.getFullyQualifiedName(enclosedType), JavaModelUtil.getFullyQualifiedName(type)});
                context = JavaStatusContext.create((ITypeRoot)destinationType.getJavaScriptUnit(), destinationType.getNameRange());
                result.addError(message, context);
            }
            ++i;
        }
    }

    private static IType[] getAllEnclosedTypes(IType type) throws JavaScriptModelException {
        ArrayList<IType> result = new ArrayList<IType>(2);
        IType[] directlyEnclosed = type.getTypes();
        result.addAll(Arrays.asList(directlyEnclosed));
        int i = 0;
        while (i < directlyEnclosed.length) {
            IType enclosedType = directlyEnclosed[i];
            result.addAll(Arrays.asList(MemberCheckUtil.getAllEnclosedTypes(enclosedType)));
            ++i;
        }
        return result.toArray(new IType[result.size()]);
    }

    private static boolean typeNameExistsInEnclosingTypeChain(IType type, String typeName) {
        IType enclosing = type.getDeclaringType();
        while (enclosing != null) {
            if (enclosing.getElementName().equals(typeName)) {
                return true;
            }
            enclosing = enclosing.getDeclaringType();
        }
        return false;
    }

    public static IFunction findMethod(IFunction method, IFunction[] allMethods) throws JavaScriptModelException {
        String name = method.getElementName();
        String[] paramTypes = method.getParameterTypes();
        boolean isConstructor = method.isConstructor();
        int i = 0;
        while (i < allMethods.length) {
            if (JavaModelUtil.isSameMethodSignature(name, paramTypes, isConstructor, allMethods[i])) {
                return allMethods[i];
            }
            ++i;
        }
        return null;
    }
}

