/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.sse.ui.internal.debug;

import java.util.ArrayList;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.IBreakpointManager;
import org.eclipse.debug.core.model.IBreakpoint;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.Position;
import org.eclipse.jface.text.source.IAnnotationModel;
import org.eclipse.jface.text.source.IVerticalRulerInfo;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IStorageEditorInput;
import org.eclipse.ui.texteditor.AbstractMarkerAnnotationModel;
import org.eclipse.ui.texteditor.IDocumentProvider;
import org.eclipse.ui.texteditor.ITextEditor;
import org.eclipse.ui.texteditor.IUpdate;
import org.eclipse.wst.sse.ui.internal.Logger;

public abstract class BreakpointRulerAction
extends Action
implements IUpdate {
    protected MouseListener fMouseListener = null;
    protected IVerticalRulerInfo fRulerInfo = null;
    protected ITextEditor fTextEditor = null;
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;
    static /* synthetic */ Class class$2;

    public static final String getFileExtension(IEditorInput input) {
        IPath path = null;
        if (input instanceof IStorageEditorInput) {
            try {
                path = ((IStorageEditorInput)input).getStorage().getFullPath();
            }
            catch (CoreException e) {
                Logger.logException(e);
            }
        }
        if (path != null) {
            return path.getFileExtension();
        }
        String name = input.getName();
        int index = name.lastIndexOf(46);
        if (index == -1) {
            return null;
        }
        if (index == name.length() - 1) {
            return "";
        }
        return name.substring(index + 1);
    }

    /*
     * Exception decompiling
     */
    public static final IResource getResource(IEditorInput input) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Back jump on a try block [egrp 5[TRYBLOCK] [5 : 398->401)] java.lang.Throwable
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.insertExceptionBlocks(Op02WithProcessedDataAndRefs.java:2283)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:415)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public BreakpointRulerAction(ITextEditor editor, IVerticalRulerInfo rulerInfo) {
        this.fTextEditor = editor;
        if (rulerInfo != null) {
            this.fRulerInfo = rulerInfo;
            this.fMouseListener = new MouseUpdater();
            rulerInfo.getControl().addMouseListener(this.fMouseListener);
        }
    }

    protected AbstractMarkerAnnotationModel getAnnotationModel() {
        IDocumentProvider provider = this.fTextEditor.getDocumentProvider();
        IAnnotationModel model = provider.getAnnotationModel((Object)this.fTextEditor.getEditorInput());
        if (model instanceof AbstractMarkerAnnotationModel) {
            return (AbstractMarkerAnnotationModel)model;
        }
        return null;
    }

    protected IBreakpoint[] getBreakpoints(IMarker[] markers) {
        IBreakpointManager manager = DebugPlugin.getDefault().getBreakpointManager();
        ArrayList<IBreakpoint> breakpoints = new ArrayList<IBreakpoint>(markers.length);
        int i = 0;
        while (i < markers.length) {
            IBreakpoint breakpoint = manager.getBreakpoint(markers[i]);
            if (breakpoint != null) {
                breakpoints.add(breakpoint);
            }
            ++i;
        }
        return breakpoints.toArray(new IBreakpoint[0]);
    }

    protected IDocument getDocument() {
        IDocumentProvider provider = this.fTextEditor.getDocumentProvider();
        return provider.getDocument((Object)this.fTextEditor.getEditorInput());
    }

    protected IMarker[] getMarkers() {
        ArrayList<IMarker> markers = new ArrayList<IMarker>();
        IResource resource = this.getResource();
        IDocument document = this.getDocument();
        AbstractMarkerAnnotationModel annotationModel = this.getAnnotationModel();
        if (resource != null && annotationModel != null && resource.exists()) {
            try {
                IMarker[] allMarkers = resource.findMarkers(IBreakpoint.BREAKPOINT_MARKER, true, 0);
                if (allMarkers != null) {
                    int i = 0;
                    while (i < allMarkers.length) {
                        if (this.includesRulerLine(annotationModel.getMarkerPosition(allMarkers[i]), document)) {
                            markers.add(allMarkers[i]);
                        }
                        ++i;
                    }
                }
            }
            catch (CoreException coreException) {}
        }
        return markers.toArray(new IMarker[0]);
    }

    protected IResource getResource() {
        IEditorInput input = this.getTextEditor().getEditorInput();
        IResource resource = BreakpointRulerAction.getResource(input);
        return resource;
    }

    public IVerticalRulerInfo getRulerInfo() {
        return this.fRulerInfo;
    }

    public ITextEditor getTextEditor() {
        return this.fTextEditor;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected boolean hasMarkers() {
        IResource resource = this.getResource();
        IDocument document = this.getDocument();
        AbstractMarkerAnnotationModel model = this.getAnnotationModel();
        if (resource == null) return false;
        if (model == null) return false;
        if (!resource.exists()) return false;
        try {
            IMarker[] allMarkers = resource.findMarkers(IBreakpoint.LINE_BREAKPOINT_MARKER, true, 0);
            if (allMarkers == null) return false;
            int i = 0;
            while (true) {
                if (i >= allMarkers.length) {
                    return false;
                }
                if (this.includesRulerLine(model.getMarkerPosition(allMarkers[i]), document)) {
                    return true;
                }
                ++i;
            }
        }
        catch (CoreException coreException) {}
        return false;
    }

    protected boolean includesRulerLine(Position position, IDocument document) {
        if (position != null && this.fRulerInfo != null) {
            try {
                int markerLine = document.getLineOfOffset(position.getOffset());
                int line = this.getRulerInfo().getLineOfLastMouseButtonActivity();
                if (line == markerLine) {
                    return true;
                }
            }
            catch (BadLocationException badLocationException) {}
        }
        return false;
    }

    protected class MouseUpdater
    implements MouseListener {
        protected MouseUpdater() {
        }

        public void mouseDoubleClick(MouseEvent e) {
        }

        public void mouseDown(MouseEvent e) {
            BreakpointRulerAction.this.update();
        }

        public void mouseUp(MouseEvent e) {
        }
    }
}

