/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.jsp.core.internal.util;

import org.eclipse.core.filebuffers.FileBuffers;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.jst.jsp.core.internal.util.FacetModuleCoreSupportDelegate;

public final class FacetModuleCoreSupport {
    static final boolean _dump_NCDFE = false;
    private static final String WEB_INF = "WEB-INF";
    private static final IPath WEB_INF_PATH = new Path("WEB-INF");

    public static IPath computeWebContentRootPath(IPath path) {
        IPath root = null;
        try {
            root = FacetModuleCoreSupportDelegate.getWebContentRootPath(ResourcesPlugin.getWorkspace().getRoot().getProject(path.segment(0)));
        }
        catch (NoClassDefFoundError noClassDefFoundError) {}
        if (root == null) {
            root = FacetModuleCoreSupport.getLocalRoot(path);
        }
        return root;
    }

    public static float getDynamicWebProjectVersion(IProject project) {
        float version = 2.5f;
        try {
            version = FacetModuleCoreSupportDelegate.getDynamicWebProjectVersion(project);
        }
        catch (NoClassDefFoundError noClassDefFoundError) {}
        return version;
    }

    public static IPath getWebContentRootPath(IProject project) {
        if (project == null) {
            return null;
        }
        IPath path = null;
        try {
            path = FacetModuleCoreSupportDelegate.getWebContentRootPath(project);
        }
        catch (NoClassDefFoundError noClassDefFoundError) {}
        return path;
    }

    public static IPath getRuntimePath(IPath path) {
        IPath result = null;
        try {
            result = FacetModuleCoreSupportDelegate.getRuntimePath(path);
        }
        catch (NoClassDefFoundError noClassDefFoundError) {}
        if (result == null) {
            IPath root = FacetModuleCoreSupport.getLocalRoot(path);
            result = path.removeFirstSegments(root.segmentCount()).makeAbsolute();
        }
        return result;
    }

    public static boolean isDynamicWebProject(IProject project) {
        if (project == null) {
            return false;
        }
        try {
            return FacetModuleCoreSupportDelegate.isDynamicWebProject(project);
        }
        catch (NoClassDefFoundError noClassDefFoundError) {
            return true;
        }
    }

    public static IPath resolve(IPath basePath, String reference) {
        IPath resolvedPath = null;
        try {
            resolvedPath = FacetModuleCoreSupportDelegate.resolve(basePath, reference);
        }
        catch (NoClassDefFoundError noClassDefFoundError) {}
        if (resolvedPath == null) {
            IPath rootPath = FacetModuleCoreSupport.getLocalRoot(basePath);
            resolvedPath = reference.startsWith(Path.ROOT.toString()) ? rootPath.append(reference) : basePath.removeLastSegments(1).append(reference);
        }
        return resolvedPath;
    }

    private static IPath getLocalRoot(IPath basePath) {
        IFile[] files;
        IWorkspaceRoot workspaceRoot = ResourcesPlugin.getWorkspace().getRoot();
        IFile file = FileBuffers.getWorkspaceFileAtLocation((IPath)basePath);
        if (file == null && basePath.segmentCount() > 1) {
            file = workspaceRoot.getFolder(basePath);
        }
        if (file != null && !file.exists() && basePath.segmentCount() > 1) {
            file = workspaceRoot.getFile(basePath);
        }
        if (file == null && basePath.segmentCount() == 1) {
            file = workspaceRoot.getProject(basePath.segment(0));
        }
        if (file == null && (files = ResourcesPlugin.getWorkspace().getRoot().findFilesForLocation(basePath)).length > 0) {
            file = files[0];
        }
        while (file != null) {
            IFolder webinf;
            IContainer folder = null;
            folder = (file.getType() & 2) != 0 ? (IContainer)file : file.getParent();
            if (folder != null && (folder.getType() & 8) == 0 && (webinf = folder.getFolder(WEB_INF_PATH)) != null && webinf.exists()) {
                return folder.getFullPath();
            }
            file = file.getParent();
        }
        return basePath.uptoSegment(1);
    }
}

