/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.ui.typehierarchy;

import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.wst.jsdt.core.Flags;
import org.eclipse.wst.jsdt.core.IFunction;
import org.eclipse.wst.jsdt.core.IType;
import org.eclipse.wst.jsdt.core.ITypeHierarchy;
import org.eclipse.wst.jsdt.core.JavaScriptModelException;
import org.eclipse.wst.jsdt.internal.corext.util.JavaModelUtil;
import org.eclipse.wst.jsdt.internal.corext.util.MethodOverrideTester;
import org.eclipse.wst.jsdt.internal.ui.viewsupport.SourcePositionComparator;
import org.eclipse.wst.jsdt.ui.JavaScriptElementComparator;

public abstract class AbstractHierarchyViewerSorter
extends ViewerComparator {
    private static final int OTHER = 1;
    private static final int CLASS = 2;
    private static final int INTERFACE = 3;
    private static final int ANONYM = 4;
    private JavaScriptElementComparator fNormalSorter = new JavaScriptElementComparator();
    private SourcePositionComparator fSourcePositonSorter = new SourcePositionComparator();

    protected abstract ITypeHierarchy getHierarchy(IType var1);

    public abstract boolean isSortByDefiningType();

    public abstract boolean isSortAlphabetically();

    protected int getTypeFlags(IType type) throws JavaScriptModelException {
        return type.getFlags();
    }

    public int category(Object element) {
        if (element instanceof IType) {
            IType type = (IType)element;
            if (type.getElementName().length() == 0) {
                return 4;
            }
            try {
                int flags = this.getTypeFlags(type);
                if (Flags.isInterface((int)flags)) {
                    return 3;
                }
                return 2;
            }
            catch (JavaScriptModelException javaScriptModelException) {}
        }
        return 1;
    }

    public int compare(Viewer viewer, Object e1, Object e2) {
        int cat2;
        if (!this.isSortAlphabetically() && !this.isSortByDefiningType()) {
            return this.fSourcePositonSorter.compare(viewer, e1, e2);
        }
        int cat1 = this.category(e1);
        if (cat1 != (cat2 = this.category(e2))) {
            return cat1 - cat2;
        }
        if (cat1 == 1) {
            block14: {
                if (this.isSortByDefiningType()) {
                    IType def2;
                    block13: {
                        try {
                            IType def1 = e1 instanceof IFunction ? this.getDefiningType((IFunction)e1) : null;
                            IType iType = def2 = e2 instanceof IFunction ? this.getDefiningType((IFunction)e2) : null;
                            if (def1 == null) break block13;
                            if (def2 != null) {
                                if (!def2.equals(def1)) {
                                    return this.compareInHierarchy(def1, def2);
                                }
                                break block14;
                            }
                            return -1;
                        }
                        catch (JavaScriptModelException javaScriptModelException) {}
                    }
                    if (def2 != null) {
                        return 1;
                    }
                }
            }
            if (this.isSortAlphabetically()) {
                return this.fNormalSorter.compare(viewer, e1, e2);
            }
            return 0;
        }
        if (cat1 == 4) {
            return 0;
        }
        if (this.isSortAlphabetically()) {
            String name1 = ((IType)e1).getElementName();
            String name2 = ((IType)e2).getElementName();
            return this.getComparator().compare(name1, name2);
        }
        return 0;
    }

    private IType getDefiningType(IFunction method) throws JavaScriptModelException {
        MethodOverrideTester tester;
        IFunction res;
        ITypeHierarchy hierarchy;
        int flags = method.getFlags();
        if (Flags.isPrivate((int)flags) || Flags.isStatic((int)flags) || method.isConstructor()) {
            return null;
        }
        IType declaringType = method.getDeclaringType();
        if (declaringType != null && (hierarchy = this.getHierarchy(declaringType)) != null && (res = (tester = new MethodOverrideTester(declaringType, hierarchy)).findDeclaringMethod(method, true)) != null) {
            return res.getDeclaringType();
        }
        return null;
    }

    private int compareInHierarchy(IType def1, IType def2) {
        block8: {
            int flags2;
            block7: {
                if (JavaModelUtil.isSuperType(this.getHierarchy(def1), def2, def1)) {
                    return 1;
                }
                if (JavaModelUtil.isSuperType(this.getHierarchy(def2), def1, def2)) {
                    return -1;
                }
                try {
                    int flags1 = this.getTypeFlags(def1);
                    flags2 = this.getTypeFlags(def2);
                    if (!Flags.isInterface((int)flags1)) break block7;
                    if (!Flags.isInterface((int)flags2)) {
                        return 1;
                    }
                    break block8;
                }
                catch (JavaScriptModelException javaScriptModelException) {}
            }
            if (Flags.isInterface((int)flags2)) {
                return -1;
            }
        }
        String name1 = def1.getElementName();
        String name2 = def2.getElementName();
        return this.getComparator().compare(name1, name2);
    }
}

