/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.corext.codemanipulation;

import org.eclipse.core.filebuffers.FileBuffers;
import org.eclipse.core.filebuffers.ITextFileBufferManager;
import org.eclipse.core.filebuffers.LocationKind;
import org.eclipse.core.resources.IWorkspaceRunnable;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.TextUtilities;
import org.eclipse.text.edits.InsertEdit;
import org.eclipse.text.edits.MultiTextEdit;
import org.eclipse.text.edits.TextEdit;
import org.eclipse.wst.jsdt.core.IField;
import org.eclipse.wst.jsdt.core.IFunction;
import org.eclipse.wst.jsdt.core.IJavaScriptProject;
import org.eclipse.wst.jsdt.core.IJavaScriptUnit;
import org.eclipse.wst.jsdt.core.IMember;
import org.eclipse.wst.jsdt.core.IType;
import org.eclipse.wst.jsdt.core.ITypeHierarchy;
import org.eclipse.wst.jsdt.core.JavaScriptModelException;
import org.eclipse.wst.jsdt.core.Signature;
import org.eclipse.wst.jsdt.internal.corext.codemanipulation.CodeGenerationMessages;
import org.eclipse.wst.jsdt.internal.corext.codemanipulation.StubUtility;
import org.eclipse.wst.jsdt.internal.corext.dom.TokenScanner;
import org.eclipse.wst.jsdt.internal.corext.util.MethodOverrideTester;
import org.eclipse.wst.jsdt.internal.corext.util.Strings;
import org.eclipse.wst.jsdt.internal.corext.util.SuperTypeHierarchyCache;
import org.eclipse.wst.jsdt.internal.ui.JavaUIStatus;
import org.eclipse.wst.jsdt.ui.CodeGeneration;

public class AddJavaDocStubOperation
implements IWorkspaceRunnable {
    private IMember[] fMembers;

    public AddJavaDocStubOperation(IMember[] members) {
        this.fMembers = members;
    }

    private String createTypeComment(IType type, String lineDelimiter) throws CoreException {
        String[] typeParameterNames = StubUtility.getTypeParameterNames(type.getTypeParameters());
        return CodeGeneration.getTypeComment(type.getJavaScriptUnit(), type.getTypeQualifiedName('.'), typeParameterNames, lineDelimiter);
    }

    private String createMethodComment(IFunction meth, String lineDelimiter) throws CoreException {
        IType declaringType = meth.getDeclaringType();
        IFunction overridden = null;
        if (!meth.isConstructor() && declaringType != null) {
            ITypeHierarchy hierarchy = SuperTypeHierarchyCache.getTypeHierarchy(declaringType);
            MethodOverrideTester tester = new MethodOverrideTester(declaringType, hierarchy);
            overridden = tester.findOverriddenMethod(meth, true);
        }
        return CodeGeneration.getMethodComment(meth, overridden, lineDelimiter);
    }

    private String createFieldComment(IField field, String lineDelimiter) throws JavaScriptModelException, CoreException {
        String typeName = Signature.toString((String)field.getTypeSignature());
        String fieldName = field.getElementName();
        return CodeGeneration.getFieldComment(field.getJavaScriptUnit(), typeName, fieldName, lineDelimiter);
    }

    public ISchedulingRule getScheduleRule() {
        return ResourcesPlugin.getWorkspace().getRoot();
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void run(IProgressMonitor monitor) throws CoreException, OperationCanceledException {
        if (monitor == null) {
            monitor = new NullProgressMonitor();
        }
        if (this.fMembers.length == 0) {
            return;
        }
        try {
            monitor.beginTask(CodeGenerationMessages.AddJavaDocStubOperation_description, this.fMembers.length + 2);
            this.addJavadocComments(monitor);
        }
        catch (Throwable throwable) {
            Object var2_3 = null;
            monitor.done();
            throw throwable;
        }
        {
            Object var2_4 = null;
        }
        monitor.done();
    }

    protected IDocument getDocument(IJavaScriptUnit cu, IProgressMonitor monitor) throws CoreException {
        IDocument iDocument;
        ITextFileBufferManager manager = FileBuffers.getTextFileBufferManager();
        IPath path = cu.getPath();
        try {
            manager.connect(path, LocationKind.IFILE, (IProgressMonitor)new SubProgressMonitor(monitor, 1));
            iDocument = manager.getTextFileBuffer(path).getDocument();
            Object var5_6 = null;
        }
        catch (Throwable throwable) {
            Object var5_7 = null;
            manager.disconnect(path, LocationKind.IFILE, (IProgressMonitor)new SubProgressMonitor(monitor, 1));
            throw throwable;
        }
        manager.disconnect(path, LocationKind.IFILE, (IProgressMonitor)new SubProgressMonitor(monitor, 1));
        return iDocument;
    }

    private void addJavadocComments(IProgressMonitor monitor) throws CoreException {
        IJavaScriptUnit cu = this.fMembers[0].getJavaScriptUnit();
        try {
            IDocument document = this.getDocument(cu, monitor);
            String lineDelim = TextUtilities.getDefaultLineDelimiter((IDocument)document);
            MultiTextEdit edit = new MultiTextEdit();
            int i = 0;
            while (i < this.fMembers.length) {
                IMember curr = this.fMembers[i];
                int memberStartOffset = this.getMemberStartOffset(curr, document);
                String comment = null;
                switch (curr.getElementType()) {
                    case 7: {
                        comment = this.createTypeComment((IType)curr, lineDelim);
                        break;
                    }
                    case 8: {
                        comment = this.createFieldComment((IField)curr, lineDelim);
                        break;
                    }
                    case 9: {
                        comment = this.createMethodComment((IFunction)curr, lineDelim);
                    }
                }
                if (comment == null) {
                    StringBuffer buf = new StringBuffer();
                    buf.append("/**").append(lineDelim);
                    buf.append(" *").append(lineDelim);
                    buf.append(" */").append(lineDelim);
                    comment = buf.toString();
                } else if (!comment.endsWith(lineDelim)) {
                    comment = String.valueOf(comment) + lineDelim;
                }
                IJavaScriptProject project = cu.getJavaScriptProject();
                IRegion region = document.getLineInformationOfOffset(memberStartOffset);
                String line = document.get(region.getOffset(), region.getLength());
                String indentString = Strings.getIndentString(line, project);
                String indentedComment = Strings.changeIndent(comment, 0, project, indentString, lineDelim);
                edit.addChild((TextEdit)new InsertEdit(memberStartOffset, indentedComment));
                monitor.worked(1);
                ++i;
            }
            edit.apply(document);
        }
        catch (BadLocationException e) {
            throw new CoreException(JavaUIStatus.createError(4, e));
        }
    }

    private int getMemberStartOffset(IMember curr, IDocument document) throws JavaScriptModelException {
        int offset = curr.getSourceRange().getOffset();
        TokenScanner scanner = new TokenScanner(document, curr.getJavaScriptProject());
        try {
            return scanner.getNextStartOffset(offset, true);
        }
        catch (CoreException coreException) {
            return offset;
        }
    }
}

