/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.common.project.facet.core.internal;

import java.util.Collections;
import java.util.Hashtable;
import java.util.List;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ProjectScope;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.launching.IVMInstall;
import org.eclipse.jdt.launching.JavaRuntime;
import org.eclipse.jst.common.project.facet.core.ClasspathHelper;
import org.eclipse.jst.common.project.facet.core.JavaFacet;
import org.eclipse.osgi.util.NLS;
import org.eclipse.wst.common.project.facet.core.IProjectFacetVersion;
import org.osgi.service.prefs.BackingStoreException;

public final class JavaFacetUtil {
    public static String getCompilerLevel() {
        InstanceScope context = new InstanceScope();
        IEclipsePreferences prefs = context.getNode("org.eclipse.jdt.core");
        String level = prefs.get("org.eclipse.jdt.core.compiler.compliance", null);
        if (level == null) {
            Hashtable defaults = JavaCore.getDefaultOptions();
            level = (String)defaults.get("org.eclipse.jdt.core.compiler.compliance");
        }
        return level;
    }

    public static String getCompilerLevel(IProject project) {
        ProjectScope context = new ProjectScope(project);
        IEclipsePreferences prefs = context.getNode("org.eclipse.jdt.core");
        String level = prefs.get("org.eclipse.jdt.core.compiler.compliance", null);
        if (level == null) {
            level = JavaFacetUtil.getCompilerLevel();
        }
        return level;
    }

    public static void setCompilerLevel(IProject project, IProjectFacetVersion fv) throws CoreException {
        JavaFacetUtil.setCompilerLevel(project, JavaFacetUtil.facetToCompilerLevel(fv));
    }

    public static void setCompilerLevel(IProject project, String level) throws CoreException {
        ProjectScope context = new ProjectScope(project);
        IEclipsePreferences prefs = context.getNode("org.eclipse.jdt.core");
        if (level.equals("1.3")) {
            prefs.put("org.eclipse.jdt.core.compiler.compliance", "1.3");
            prefs.put("org.eclipse.jdt.core.compiler.codegen.targetPlatform", "1.1");
            prefs.put("org.eclipse.jdt.core.compiler.source", "1.3");
            prefs.put("org.eclipse.jdt.core.compiler.problem.assertIdentifier", "ignore");
            prefs.put("org.eclipse.jdt.core.compiler.problem.enumIdentifier", "ignore");
        } else if (level.equals("1.4")) {
            prefs.put("org.eclipse.jdt.core.compiler.compliance", "1.4");
            prefs.put("org.eclipse.jdt.core.compiler.codegen.targetPlatform", "1.2");
            prefs.put("org.eclipse.jdt.core.compiler.source", "1.3");
            prefs.put("org.eclipse.jdt.core.compiler.problem.assertIdentifier", "warning");
            prefs.put("org.eclipse.jdt.core.compiler.problem.enumIdentifier", "warning");
        } else if (level.equals("1.5")) {
            prefs.put("org.eclipse.jdt.core.compiler.compliance", "1.5");
            prefs.put("org.eclipse.jdt.core.compiler.codegen.targetPlatform", "1.5");
            prefs.put("org.eclipse.jdt.core.compiler.source", "1.5");
            prefs.put("org.eclipse.jdt.core.compiler.problem.assertIdentifier", "error");
            prefs.put("org.eclipse.jdt.core.compiler.problem.enumIdentifier", "error");
        } else if (level.equals("1.6")) {
            prefs.put("org.eclipse.jdt.core.compiler.compliance", "1.6");
            prefs.put("org.eclipse.jdt.core.compiler.codegen.targetPlatform", "1.6");
            prefs.put("org.eclipse.jdt.core.compiler.source", "1.6");
            prefs.put("org.eclipse.jdt.core.compiler.problem.assertIdentifier", "error");
            prefs.put("org.eclipse.jdt.core.compiler.problem.enumIdentifier", "error");
        } else {
            throw new IllegalStateException();
        }
        try {
            prefs.flush();
        }
        catch (BackingStoreException backingStoreException) {}
    }

    public static void scheduleFullBuild(final IProject project) {
        final IWorkspace ws = ResourcesPlugin.getWorkspace();
        final String msg = NLS.bind((String)Resources.buildingMsg, (Object)project.getName());
        Job buildJob = new Job(msg){

            public IStatus run(IProgressMonitor monitor) {
                monitor.beginTask(msg, 2);
                try {
                    try {
                        project.build(6, (IProgressMonitor)new SubProgressMonitor(monitor, 1));
                        ws.build(10, (IProgressMonitor)new SubProgressMonitor(monitor, 1));
                    }
                    catch (CoreException e) {
                        IStatus iStatus = e.getStatus();
                        monitor.done();
                        return iStatus;
                    }
                }
                finally {
                    monitor.done();
                }
                return Status.OK_STATUS;
            }

            public boolean belongsTo(Object family) {
                return family == ResourcesPlugin.FAMILY_MANUAL_BUILD;
            }
        };
        buildJob.setRule(ws.getRuleFactory().buildRule());
        buildJob.schedule();
    }

    public static void resetClasspath(IProject project, IProjectFacetVersion oldver, IProjectFacetVersion newver) throws CoreException {
        IVMInstall vm;
        if (oldver != null) {
            ClasspathHelper.removeClasspathEntries(project, oldver);
        }
        JavaFacetUtil.removeJreContainer(project);
        if (!ClasspathHelper.addClasspathEntries(project, newver) && (vm = JavaRuntime.getDefaultVMInstall()) != null) {
            Path path = new Path(JavaRuntime.JRE_CONTAINER);
            path = path.append(vm.getVMInstallType().getId());
            path = path.append(vm.getName());
            IClasspathEntry cpe = JavaCore.newContainerEntry((IPath)path);
            List<IClasspathEntry> entries = Collections.singletonList(cpe);
            ClasspathHelper.addClasspathEntries(project, newver, entries);
        }
    }

    private static void removeJreContainer(IProject proj) throws CoreException {
        IJavaProject jproj = JavaCore.create((IProject)proj);
        IClasspathEntry[] cp = jproj.getRawClasspath();
        int pos = -1;
        int i = 0;
        while (i < cp.length) {
            IClasspathEntry cpe = cp[i];
            if (cpe.getEntryKind() == 5 && cpe.getPath().segment(0).equals(JavaRuntime.JRE_CONTAINER)) {
                pos = i;
                break;
            }
            ++i;
        }
        if (pos == -1) {
            return;
        }
        IClasspathEntry[] newcp = new IClasspathEntry[cp.length - 1];
        System.arraycopy(cp, 0, newcp, 0, pos);
        System.arraycopy(cp, pos + 1, newcp, pos, newcp.length - pos);
        jproj.setRawClasspath(newcp, null);
    }

    public static IProjectFacetVersion compilerLevelToFacet(String ver) {
        if (ver.equals("1.5")) {
            return JavaFacet.JAVA_50;
        }
        if (ver.equals("1.6")) {
            return JavaFacet.JAVA_60;
        }
        return JavaFacet.FACET.getVersion(ver);
    }

    public static String facetToCompilerLevel(IProjectFacetVersion fv) {
        if (fv == JavaFacet.JAVA_50) {
            return "1.5";
        }
        if (fv == JavaFacet.JAVA_60) {
            return "1.6";
        }
        return fv.getVersionString();
    }

    private static final class Resources
    extends NLS {
        public static String buildingMsg;

        static {
            Resources.initializeMessages((String)JavaFacetUtil.class.getName(), Resources.class);
        }

        private Resources() {
        }
    }
}

