/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.ui.search;

import org.eclipse.wst.jsdt.core.IFunction;
import org.eclipse.wst.jsdt.internal.ui.search.JavaElementMatch;
import org.eclipse.wst.jsdt.internal.ui.search.JavaMatchFilter;
import org.eclipse.wst.jsdt.internal.ui.search.JavaSearchQuery;
import org.eclipse.wst.jsdt.internal.ui.search.SearchMessages;
import org.eclipse.wst.jsdt.ui.search.ElementQuerySpecification;
import org.eclipse.wst.jsdt.ui.search.PatternQuerySpecification;
import org.eclipse.wst.jsdt.ui.search.QuerySpecification;

class PolymorphicFilter
extends JavaMatchFilter {
    PolymorphicFilter() {
    }

    public boolean filters(JavaElementMatch match) {
        return match.isSuperInvocation();
    }

    public String getName() {
        return SearchMessages.MatchFilter_PolymorphicFilter_name;
    }

    public String getActionLabel() {
        return SearchMessages.MatchFilter_PolymorphicFilter_actionLabel;
    }

    public String getDescription() {
        return SearchMessages.MatchFilter_PolymorphicFilter_description;
    }

    public boolean isApplicable(JavaSearchQuery query) {
        QuerySpecification spec = query.getSpecification();
        switch (spec.getLimitTo()) {
            case 2: 
            case 3: {
                if (spec instanceof ElementQuerySpecification) {
                    ElementQuerySpecification elementSpec = (ElementQuerySpecification)spec;
                    return elementSpec.getElement() instanceof IFunction;
                }
                if (!(spec instanceof PatternQuerySpecification)) break;
                PatternQuerySpecification patternSpec = (PatternQuerySpecification)spec;
                return patternSpec.getSearchFor() == 1;
            }
        }
        return false;
    }

    public String getID() {
        return "filter_polymorphic";
    }
}

