/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.ui.text.correction;

import org.eclipse.wst.jsdt.core.IJavaScriptElement;
import org.eclipse.wst.jsdt.core.IJavaScriptUnit;
import org.eclipse.wst.jsdt.core.dom.ASTNode;
import org.eclipse.wst.jsdt.core.dom.ASTVisitor;
import org.eclipse.wst.jsdt.core.dom.JavaScriptUnit;
import org.eclipse.wst.jsdt.internal.corext.dom.NodeFinder;
import org.eclipse.wst.jsdt.internal.ui.javaeditor.ASTProvider;
import org.eclipse.wst.jsdt.internal.ui.text.correction.ASTResolving;
import org.eclipse.wst.jsdt.ui.text.java.IInvocationContext;

public class AssistContext
implements IInvocationContext {
    private IJavaScriptUnit fCompilationUnit;
    private int fOffset;
    private int fLength;
    private JavaScriptUnit fASTRoot;

    public AssistContext(IJavaScriptUnit cu, int offset, int length) {
        this.fCompilationUnit = cu;
        this.fOffset = offset;
        this.fLength = length;
        this.fASTRoot = null;
    }

    public IJavaScriptUnit getCompilationUnit() {
        return this.fCompilationUnit;
    }

    public int getSelectionLength() {
        return this.fLength;
    }

    public int getSelectionOffset() {
        return this.fOffset;
    }

    public JavaScriptUnit getASTRoot() {
        if (this.fASTRoot == null) {
            this.fASTRoot = ASTProvider.getASTProvider().getAST((IJavaScriptElement)this.fCompilationUnit, ASTProvider.WAIT_YES, null);
            if (this.fASTRoot == null) {
                this.fASTRoot = ASTResolving.createQuickFixAST(this.fCompilationUnit, null);
            }
        }
        return this.fASTRoot;
    }

    public void setASTRoot(JavaScriptUnit root) {
        this.fASTRoot = root;
    }

    public ASTNode getCoveringNode() {
        NodeFinder finder = new NodeFinder(this.fOffset, this.fLength);
        this.getASTRoot().accept((ASTVisitor)finder);
        return finder.getCoveringNode();
    }

    public ASTNode getCoveredNode() {
        NodeFinder finder = new NodeFinder(this.fOffset, this.fLength);
        this.getASTRoot().accept((ASTVisitor)finder);
        return finder.getCoveredNode();
    }
}

