/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.sse.core.internal.modelhandler;

import java.util.HashSet;
import java.util.Iterator;
import org.eclipse.wst.sse.core.internal.ltk.modelhandler.EmbeddedTypeHandler;
import org.eclipse.wst.sse.core.internal.ltk.modelhandler.IDocumentTypeHandler;
import org.eclipse.wst.sse.core.internal.modelhandler.EmbeddedTypeRegistry;
import org.eclipse.wst.sse.core.internal.modelhandler.EmbeddedTypeRegistryReader;

public class EmbeddedTypeRegistryImpl
implements EmbeddedTypeRegistry {
    private static EmbeddedTypeRegistry instance = null;
    private HashSet hashSet = new HashSet();
    private EmbeddedTypeHandler registryDefaultHandler = null;

    public static synchronized EmbeddedTypeRegistry getInstance() {
        if (instance == null) {
            instance = new EmbeddedTypeRegistryImpl();
        }
        return instance;
    }

    private EmbeddedTypeRegistryImpl() {
        new EmbeddedTypeRegistryReader().readRegistry(this.hashSet);
    }

    void add(IDocumentTypeHandler contentTypeDescription) {
        this.hashSet.add(contentTypeDescription);
    }

    private EmbeddedTypeHandler getJSPDefaultEmbeddedType() {
        return this.getTypeFor("text/html");
    }

    private EmbeddedTypeHandler getRegistryDefault() {
        if (this.registryDefaultHandler == null) {
            Iterator it = this.hashSet.iterator();
            while (this.registryDefaultHandler == null && it.hasNext()) {
                EmbeddedTypeHandler item = (EmbeddedTypeHandler)it.next();
                if (item == null || !item.isDefault()) continue;
                this.registryDefaultHandler = item;
                break;
            }
        }
        return this.registryDefaultHandler;
    }

    public EmbeddedTypeHandler getTypeFor(String mimeType) {
        EmbeddedTypeHandler found = null;
        if (mimeType == null || mimeType.trim().length() == 0) {
            found = this.getJSPDefaultEmbeddedType();
        } else {
            EmbeddedTypeHandler item;
            Iterator it = this.hashSet.iterator();
            while (found == null && it.hasNext()) {
                item = (EmbeddedTypeHandler)it.next();
                if (item == null || !item.getSupportedMimeTypes().contains(mimeType)) continue;
                found = item;
                break;
            }
            if (found == null) {
                it = this.hashSet.iterator();
                while (found == null && it.hasNext()) {
                    item = (EmbeddedTypeHandler)it.next();
                    if (item == null || !item.canHandleMimeType(mimeType)) continue;
                    found = item;
                    break;
                }
            }
        }
        if (found == null) {
            found = this.getRegistryDefault();
        }
        return found;
    }
}

