/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.ws.internal.explorer.platform.wsdl.util;

import java.util.Hashtable;
import java.util.Map;
import java.util.Vector;
import javax.wsdl.Part;
import javax.xml.parsers.ParserConfigurationException;
import org.eclipse.wst.ws.internal.explorer.platform.wsdl.datamodel.WSDLOperationElement;
import org.eclipse.wst.ws.internal.explorer.platform.wsdl.fragment.IXSDFragment;
import org.eclipse.wst.ws.internal.explorer.platform.wsdl.util.SoapHelper;
import org.eclipse.wst.ws.internal.explorer.transport.ISOAPMessage;
import org.eclipse.wst.wsdl.binding.soap.SOAPHeader;
import org.w3c.dom.Attr;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;

public class SOAPMessageUtils {
    public static boolean decodeNamespaceTable(Hashtable soapEnvelopeNamespaceTable, WSDLOperationElement operElement) {
        boolean updated = false;
        String[] nsDeclarations = (String[])operElement.getPropertyAsObject("propSourceContentNS");
        if (nsDeclarations == null) {
            return false;
        }
        int i = 0;
        while (i < nsDeclarations.length) {
            String[] prefix_ns = SoapHelper.decodeNamespaceDeclaration(nsDeclarations[i]);
            if (!soapEnvelopeNamespaceTable.containsKey(prefix_ns[1])) {
                soapEnvelopeNamespaceTable.put(prefix_ns[1], prefix_ns[0]);
                updated = true;
            }
            ++i;
        }
        return updated;
    }

    public static void setHeaderContentFromModel(Hashtable soapEnvelopeNamespaceTable, WSDLOperationElement operElement, ISOAPMessage soapMessage) throws ParserConfigurationException {
        Vector<Element> headerEntries = new Vector<Element>();
        for (SOAPHeader soapHeader : operElement.getSOAPHeaders()) {
            boolean isUseLiteral = "literal".equals(soapHeader.getUse());
            IXSDFragment frag = operElement.getHeaderFragment(soapHeader);
            Element[] instanceDocuments = frag.genInstanceDocumentsFromParameterValues(!isUseLiteral, soapEnvelopeNamespaceTable, soapMessage.getEnvelope(false).getOwnerDocument());
            int i = 0;
            while (i < instanceDocuments.length) {
                if (instanceDocuments[i] != null) {
                    headerEntries.addElement(instanceDocuments[i]);
                }
                ++i;
            }
        }
        Object[] headerContent = new Element[headerEntries.size()];
        headerEntries.copyInto(headerContent);
        soapMessage.setHeaderContent((Element[])headerContent);
    }

    public static void setBodyContentFromModel(Hashtable soapEnvelopeNamespaceTable, WSDLOperationElement operElement, ISOAPMessage soapMessage) throws ParserConfigurationException {
        Vector<Element> bodyEntries = new Vector<Element>();
        boolean isUseLiteral = operElement.isUseLiteral();
        for (Part part : operElement.getOrderedBodyParts()) {
            IXSDFragment frag = operElement.getFragment(part);
            Element[] instanceDocuments = frag.genInstanceDocumentsFromParameterValues(!isUseLiteral, soapEnvelopeNamespaceTable, soapMessage.getEnvelope(false).getOwnerDocument());
            int i = 0;
            while (i < instanceDocuments.length) {
                if (instanceDocuments[i] != null) {
                    bodyEntries.addElement(instanceDocuments[i]);
                }
                ++i;
            }
        }
        Object[] bodyContent = new Element[bodyEntries.size()];
        bodyEntries.copyInto(bodyContent);
        soapMessage.setBodyContent((Element[])bodyContent);
    }

    private static String getNSPrefix(Attr attribute) {
        String name = attribute.getName();
        if (name.startsWith("xmlns:")) {
            return name.substring(6);
        }
        return null;
    }

    private static String lookupPrefix(Element element, String namespaceURI) {
        NamedNodeMap attributes = element.getAttributes();
        int i = 0;
        while (i < attributes.getLength()) {
            Attr attribute = (Attr)attributes.item(i);
            String prefix = SOAPMessageUtils.getNSPrefix(attribute);
            if (prefix != null && attribute.getValue().equals(namespaceURI)) {
                return prefix;
            }
            ++i;
        }
        return null;
    }

    public static int findFirstMatchingElement(Part part, Element[] elements, Map namespaceTable, String fragName, int start) {
        String namespaceURI = null;
        String prefix = null;
        if (part.getElementName() != null) {
            namespaceURI = part.getElementName().getNamespaceURI();
            prefix = (String)namespaceTable.get(namespaceURI);
        }
        int i = start;
        while (i < elements.length) {
            Element element = elements[i];
            String name = element.getTagName();
            if (prefix == null && namespaceURI != null && element.hasAttributes()) {
                prefix = SOAPMessageUtils.lookupPrefix(element, namespaceURI);
            }
            if (prefix == null && name.equals(fragName)) {
                return i;
            }
            if (prefix != null && name.equals(String.valueOf(prefix) + ":" + fragName)) {
                return i;
            }
            ++i;
        }
        return -1;
    }
}

