/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.servlet.ui.internal.wizard;

import java.util.ArrayList;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.ITypeHierarchy;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.ui.JavaUI;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.operation.IRunnableContext;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.jst.j2ee.internal.dialogs.FilteredFileSelectionDialog;
import org.eclipse.jst.j2ee.internal.dialogs.TwoArrayQuickSorter;
import org.eclipse.jst.j2ee.internal.dialogs.TypedFileViewerFilter;
import org.eclipse.jst.j2ee.internal.web.providers.WebAppEditResourceHandler;
import org.eclipse.jst.servlet.ui.internal.plugin.ServletUIPlugin;
import org.eclipse.jst.servlet.ui.internal.wizard.IWebWizardConstants;
import org.eclipse.jst.servlet.ui.internal.wizard.SimpleTypedElementSelectionValidator;
import org.eclipse.jst.servlet.ui.internal.wizard.StringMatcher;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.dialogs.ISelectionStatusValidator;
import org.eclipse.ui.part.PageBook;

public class MultiSelectFilteredFilterFileSelectionDialog
extends FilteredFileSelectionDialog {
    protected PageBook fPageBook = null;
    protected Control fServletControl = null;
    protected Composite fChild = null;
    protected IRunnableContext fRunnableContext;
    protected ILabelProvider fElementRenderer;
    protected ILabelProvider fQualifierRenderer;
    private Object[] fElements;
    private boolean fIgnoreCase = true;
    private String fUpperListLabel;
    private String fLowerListLabel;
    private Table fUpperList;
    private Table fLowerList;
    protected Text fText;
    private IType[] fIT;
    private String[] fRenderedStrings;
    private int[] fElementMap;
    private Integer[] fQualifierMap;
    private ISelectionStatusValidator fLocalValidator = null;

    public MultiSelectFilteredFilterFileSelectionDialog(Shell parent, String title, String message, String[] extensions, boolean allowMultiple, IProject project) {
        super(parent, title, message, extensions, allowMultiple);
        this.setShellStyle(67696);
        if (title == null) {
            this.setTitle(WebAppEditResourceHandler.getString((String)"File_Selection_UI_"));
        }
        if (message == null) {
            message = WebAppEditResourceHandler.getString((String)"Select_a_file__UI_");
        }
        this.setMessage(message);
        this.setExtensions(extensions);
        this.addFilter((ViewerFilter)new TypedFileViewerFilter(extensions));
        this.fLocalValidator = new SimpleTypedElementSelectionValidator(new Class[]{IFile.class}, allowMultiple);
        this.setValidator(this.fLocalValidator);
        Status currStatus = new Status(0, "org.eclipse.jst.servlet.ui", 0, "", null);
        this.updateStatus((IStatus)currStatus);
        this.fElementRenderer = new TypeRenderer();
        this.fQualifierRenderer = new PackageRenderer();
        this.fRunnableContext = ServletUIPlugin.getDefault().getWorkbench().getActiveWorkbenchWindow();
        try {
            IJavaProject jp;
            IType filterType;
            IResource resource;
            IJavaElement jelem = null;
            IProject proj = null;
            jelem = (IJavaElement)project.getAdapter(IJavaElement.class);
            if (jelem == null && (resource = (IResource)project.getAdapter(IResource.class)) != null && (proj = resource.getProject()) != null) {
                jelem = JavaCore.create((IProject)proj);
            }
            if ((filterType = (jp = jelem.getJavaProject()).findType("javax.servlet.Filter")) == null) {
                return;
            }
            ArrayList<IType> filterClasses = new ArrayList<IType>();
            ITypeHierarchy tH = filterType.newTypeHierarchy(jp, null);
            IType[] types = tH.getAllSubtypes(filterType);
            int i = 0;
            while (i < types.length) {
                if (types[i].isClass() && !filterClasses.contains(types[i])) {
                    filterClasses.add(types[i]);
                }
                ++i;
            }
            this.fIT = filterClasses.toArray(new IType[filterClasses.size()]);
            filterClasses = null;
        }
        catch (Exception e) {
            ServletUIPlugin.log(e);
        }
    }

    protected void computeResult() {
        IType type = (IType)this.getWidgetSelection();
        if (type != null) {
            if (type == null) {
                String title = WebAppEditResourceHandler.getString((String)"Select_Class_UI_");
                String message = WebAppEditResourceHandler.getString((String)"Could_not_uniquely_map_the_ERROR_");
                MessageDialog.openError((Shell)this.getShell(), (String)title, (String)message);
                this.setResult(null);
            } else {
                ArrayList<IType> result = new ArrayList<IType>(1);
                result.add(type);
                this.setResult(result);
            }
        }
    }

    public void create() {
        super.create();
        this.fText.setFocus();
        this.rematch("");
        this.updateOkState();
    }

    protected Control createButtonBar(Composite parent) {
        Composite composite = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        composite.setLayout((Layout)layout);
        composite.setLayoutData((Object)new GridData(768));
        Composite composite2 = new Composite(composite, 0);
        layout = new GridLayout();
        layout.numColumns = 0;
        layout.makeColumnsEqualWidth = true;
        layout.marginWidth = this.convertHorizontalDLUsToPixels(7);
        layout.marginHeight = this.convertVerticalDLUsToPixels(7);
        layout.horizontalSpacing = this.convertHorizontalDLUsToPixels(4);
        layout.verticalSpacing = this.convertVerticalDLUsToPixels(4);
        composite2.setLayout((Layout)layout);
        GridData data = new GridData(132);
        composite2.setLayoutData((Object)data);
        composite2.setFont(parent.getFont());
        super.createButtonsForButtonBar(composite2);
        return composite;
    }

    protected Control createDialogArea(Composite parent) {
        GridData gd = new GridData();
        this.fChild = new Composite(parent, 0);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)this.fChild, "com.ibm.etools.webapplicationedit.webx2010");
        GridLayout gl = new GridLayout();
        gl.numColumns = 2;
        gl.marginHeight = 5;
        this.fChild.setLayout((Layout)gl);
        gd.verticalAlignment = 4;
        gd.horizontalAlignment = 4;
        gd.grabExcessVerticalSpace = true;
        this.fChild.setLayoutData((Object)gd);
        this.fPageBook = new PageBook(this.fChild, 0);
        gd = new GridData();
        gd.horizontalAlignment = 4;
        gd.verticalAlignment = 4;
        gd.grabExcessHorizontalSpace = true;
        gd.grabExcessVerticalSpace = true;
        gd.horizontalSpan = 2;
        this.fPageBook.setLayoutData((Object)gd);
        super.createDialogArea((Composite)this.fPageBook);
        Composite composite = new Composite((Composite)this.fPageBook, 0);
        GridLayout layout = new GridLayout();
        layout.marginHeight = this.convertVerticalDLUsToPixels(7);
        layout.marginWidth = this.convertHorizontalDLUsToPixels(7);
        layout.verticalSpacing = this.convertVerticalDLUsToPixels(4);
        layout.horizontalSpacing = this.convertHorizontalDLUsToPixels(4);
        composite.setLayout((Layout)layout);
        composite.setLayoutData((Object)new GridData(1808));
        composite.setFont(parent.getFont());
        Label messageLabel = new Label(composite, 0);
        gd = new GridData();
        messageLabel.setLayoutData((Object)gd);
        messageLabel.setText(WebAppEditResourceHandler.getString((String)"Choose_a_filter__1"));
        this.fText = this.createText(composite);
        messageLabel = new Label(composite, 0);
        gd = new GridData();
        messageLabel.setLayoutData((Object)gd);
        messageLabel.setText(WebAppEditResourceHandler.getString((String)"Matching_filters__2"));
        this.fUpperList = this.createUpperList(composite);
        messageLabel = new Label(composite, 0);
        gd = new GridData();
        messageLabel.setLayoutData((Object)gd);
        messageLabel.setText(WebAppEditResourceHandler.getString((String)"Qualifier__3"));
        this.fLowerList = this.createLowerList(composite);
        this.fServletControl = composite;
        this.fPageBook.showPage(this.fServletControl);
        return parent;
    }

    private Table createLowerList(Composite parent) {
        if (this.fLowerListLabel != null) {
            new Label(parent, 0).setText(this.fLowerListLabel);
        }
        Table list = new Table(parent, 2816);
        list.addListener(13, new Listener(){

            public void handleEvent(Event evt) {
                MultiSelectFilteredFilterFileSelectionDialog.this.handleLowerSelectionChanged();
            }
        });
        list.addListener(8, new Listener(){

            public void handleEvent(Event evt) {
                MultiSelectFilteredFilterFileSelectionDialog.this.handleLowerDoubleClick();
            }
        });
        list.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                MultiSelectFilteredFilterFileSelectionDialog.this.fQualifierRenderer.dispose();
            }
        });
        GridData spec = new GridData();
        spec.widthHint = this.convertWidthInCharsToPixels(50);
        spec.heightHint = this.convertHeightInCharsToPixels(5);
        spec.grabExcessVerticalSpace = true;
        spec.grabExcessHorizontalSpace = true;
        spec.horizontalAlignment = 4;
        spec.verticalAlignment = 4;
        list.setLayoutData((Object)spec);
        return list;
    }

    private Text createText(Composite parent) {
        Text text = new Text(parent, 2048);
        GridData spec = new GridData();
        spec.grabExcessVerticalSpace = false;
        spec.grabExcessHorizontalSpace = true;
        spec.horizontalAlignment = 4;
        spec.verticalAlignment = 1;
        text.setLayoutData((Object)spec);
        Listener l = new Listener(){

            public void handleEvent(Event evt) {
                MultiSelectFilteredFilterFileSelectionDialog.this.rematch(MultiSelectFilteredFilterFileSelectionDialog.this.fText.getText());
            }
        };
        text.addListener(24, l);
        return text;
    }

    private Table createUpperList(Composite parent) {
        if (this.fUpperListLabel != null) {
            new Label(parent, 0).setText(this.fUpperListLabel);
        }
        Table list = new Table(parent, 2816);
        list.addListener(13, new Listener(){

            public void handleEvent(Event evt) {
                MultiSelectFilteredFilterFileSelectionDialog.this.handleUpperSelectionChanged();
            }
        });
        list.addListener(8, new Listener(){

            public void handleEvent(Event evt) {
                MultiSelectFilteredFilterFileSelectionDialog.this.handleUpperDoubleClick();
            }
        });
        list.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                MultiSelectFilteredFilterFileSelectionDialog.this.fElementRenderer.dispose();
            }
        });
        GridData spec = new GridData();
        spec.widthHint = this.convertWidthInCharsToPixels(50);
        spec.heightHint = this.convertHeightInCharsToPixels(15);
        spec.grabExcessVerticalSpace = true;
        spec.grabExcessHorizontalSpace = true;
        spec.horizontalAlignment = 4;
        spec.verticalAlignment = 4;
        list.setLayoutData((Object)spec);
        return list;
    }

    protected int getDefaultButtonID() {
        return 0;
    }

    protected Object getWidgetSelection() {
        int i = this.fLowerList.getSelectionIndex();
        if (this.fQualifierMap != null) {
            if (this.fQualifierMap.length == 1) {
                i = 0;
            }
            if (i < 0) {
                return null;
            }
            Integer index = this.fQualifierMap[i];
            return this.fElements[index];
        }
        return null;
    }

    protected final void handleLowerDoubleClick() {
        if (this.getWidgetSelection() != null) {
            this.buttonPressed(this.getDefaultButtonID());
        }
    }

    protected final void handleLowerSelectionChanged() {
        this.updateOkState();
    }

    protected final void handleUpperDoubleClick() {
        if (this.getWidgetSelection() != null) {
            this.buttonPressed(this.getDefaultButtonID());
        }
    }

    protected final void handleUpperSelectionChanged() {
        int selection = this.fUpperList.getSelectionIndex();
        if (selection >= 0) {
            int i;
            int k = i = this.fElementMap[selection];
            int length = this.fRenderedStrings.length;
            while (k < length && this.fRenderedStrings[k].equals(this.fRenderedStrings[i])) {
                ++k;
            }
            this.updateLowerListWidget(i, k);
        } else {
            this.updateLowerListWidget(0, 0);
        }
    }

    public int open() {
        if (this.fIT == null || this.fIT.length == 0) {
            MessageDialog.openInformation((Shell)this.getShell(), (String)WebAppEditResourceHandler.getString((String)"Empty_List_1"), (String)WebAppEditResourceHandler.getString((String)"_INFO_No_filters_exist_to_add._1"));
            return 1;
        }
        this.setElements(this.fIT);
        this.setInitialSelection("");
        return super.open();
    }

    /*
     * Unable to fully structure code
     */
    protected final void rematch(String matchString) {
        k = 0;
        text = this.fText.getText();
        matcher = new StringMatcher(String.valueOf(text) + "*", this.fIgnoreCase, false);
        lastString = null;
        length = this.fElements.length;
        i = 0;
        ** GOTO lbl17
        {
            ++i;
            do {
                if (i < length && this.fRenderedStrings[i].equals(lastString)) continue block0;
                if (i < length) {
                    lastString = this.fRenderedStrings[i];
                    if (matcher.match(this.fRenderedStrings[i])) {
                        this.fElementMap[k] = i;
                        ++k;
                    }
                }
                ++i;
lbl17:
                // 2 sources

            } while (i < length);
        }
        this.fElementMap[k] = -1;
        this.updateUpperListWidget(this.fElementMap, k);
    }

    private String[] renderStrings(Object[] p) {
        Object[] strings = new String[p.length];
        int size = strings.length;
        int i = 0;
        while (i < size) {
            strings[i] = this.fElementRenderer.getText(p[i]);
            ++i;
        }
        new TwoArrayQuickSorter(this.fIgnoreCase).sort(strings, p);
        return strings;
    }

    public void setElements(Object[] elements) {
        this.fElements = elements;
        this.fElementMap = new int[this.fElements.length + 1];
        this.fRenderedStrings = this.renderStrings(this.fElements);
    }

    private void updateLowerListWidget(int from, int to) {
        this.fLowerList.removeAll();
        this.fQualifierMap = new Integer[to - from];
        Object[] qualifiers = new String[to - from];
        int i = from;
        while (i < to) {
            qualifiers[i - from] = this.fQualifierRenderer.getText(this.fElements[i]);
            this.fQualifierMap[i - from] = new Integer(i);
            ++i;
        }
        new TwoArrayQuickSorter(this.fIgnoreCase).sort(qualifiers, (Object[])this.fQualifierMap);
        i = 0;
        while (i < to - from) {
            TableItem ti = new TableItem(this.fLowerList, i);
            ti.setText((String)qualifiers[i]);
            Image img = this.fQualifierRenderer.getImage(this.fElements[from + i]);
            if (img != null) {
                ti.setImage(img);
            }
            ++i;
        }
        if (this.fLowerList.getItemCount() > 0) {
            this.fLowerList.setSelection(0);
        }
        this.updateOkState();
    }

    private void updateOkState() {
        Button okButton = this.getOkButton();
        if (okButton != null) {
            okButton.setEnabled(this.getWidgetSelection() != null);
        }
    }

    private void updateUpperListWidget(int[] indices, int size) {
        this.fUpperList.setRedraw(false);
        int itemCount = this.fUpperList.getItemCount();
        if (size < itemCount) {
            this.fUpperList.remove(0, itemCount - size - 1);
        }
        TableItem[] items = this.fUpperList.getItems();
        int i = 0;
        while (i < size) {
            TableItem ti = null;
            ti = i < itemCount ? items[i] : new TableItem(this.fUpperList, i);
            ti.setText(this.fRenderedStrings[indices[i]]);
            Image img = this.fElementRenderer.getImage(this.fElements[indices[i]]);
            if (img != null) {
                ti.setImage(img);
            }
            ++i;
        }
        if (this.fUpperList.getItemCount() > 0) {
            this.fUpperList.setSelection(0);
        }
        this.fUpperList.setRedraw(true);
        this.handleUpperSelectionChanged();
    }

    public void widgetDefaultSelected(SelectionEvent e) {
    }

    protected void updateOKStatus() {
        super.updateOKStatus();
        Button okButton = this.getOkButton();
        if (okButton != null) {
            okButton.setEnabled(this.fLocalValidator.validate(this.getResult()).isOK());
        }
    }

    private static class PackageRenderer
    extends LabelProvider {
        private final Image PACKAGE_ICON = JavaUI.getSharedImages().getImage("org.eclipse.jdt.ui.package_obj.gif");

        private PackageRenderer() {
        }

        public String getText(Object element) {
            IType type = (IType)element;
            String p = type.getPackageFragment().getElementName();
            if ("".equals(p)) {
                p = IWebWizardConstants.DEFAULT_PACKAGE;
            }
            return String.valueOf(p) + " - " + type.getPackageFragment().getParent().getPath().toString();
        }

        public Image getImage(Object element) {
            return this.PACKAGE_ICON;
        }
    }

    private static class TypeRenderer
    extends LabelProvider {
        private final Image CLASS_ICON = JavaUI.getSharedImages().getImage("org.eclipse.jdt.ui.class_obj.gif");

        private TypeRenderer() {
        }

        public String getText(Object element) {
            IType e = (IType)element;
            return e.getElementName();
        }

        public Image getImage(Object element) {
            return this.CLASS_ICON;
        }
    }
}

