/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.j2ee.internal.web.validation;

import java.io.File;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.jst.j2ee.classpathdep.ClasspathDependencyUtil;
import org.eclipse.jst.j2ee.componentcore.J2EEModuleVirtualComponent;
import org.eclipse.jst.j2ee.internal.project.J2EEProjectUtilities;
import org.eclipse.jst.j2ee.internal.web.validation.UIWarHelper;
import org.eclipse.jst.j2ee.model.internal.validation.WarValidator;
import org.eclipse.jst.j2ee.project.WebUtilities;
import org.eclipse.jst.j2ee.web.componentcore.util.WebArtifactEdit;
import org.eclipse.wst.common.componentcore.ComponentCore;
import org.eclipse.wst.common.componentcore.internal.resources.VirtualArchiveComponent;
import org.eclipse.wst.common.componentcore.resources.IVirtualComponent;
import org.eclipse.wst.common.componentcore.resources.IVirtualFile;
import org.eclipse.wst.common.componentcore.resources.IVirtualFolder;
import org.eclipse.wst.common.componentcore.resources.IVirtualReference;
import org.eclipse.wst.common.componentcore.resources.IVirtualResource;
import org.eclipse.wst.validation.internal.core.Message;
import org.eclipse.wst.validation.internal.core.ValidationException;
import org.eclipse.wst.validation.internal.operations.IWorkbenchContext;
import org.eclipse.wst.validation.internal.provisional.core.IMessage;
import org.eclipse.wst.validation.internal.provisional.core.IReporter;
import org.eclipse.wst.validation.internal.provisional.core.IValidationContext;
import org.eclipse.wst.validation.internal.provisional.core.IValidator;

public class UIWarValidator
extends WarValidator {
    protected UIWarHelper warHelper;

    public UIWarHelper getWarHelper() {
        return this.warHelper;
    }

    public void setWarHelper(UIWarHelper newWarHelper) {
        this.warHelper = newWarHelper;
    }

    public void validate() throws ValidationException {
        super.validate();
        this.validateEARForContextRoot();
    }

    public IStatus validateInJob(IValidationContext inHelper, IReporter inReporter) throws ValidationException {
        IVirtualFile webFile;
        this.setWarHelper((UIWarHelper)inHelper);
        IProject proj = this.warHelper.getProject();
        IVirtualComponent wbModule = ComponentCore.createComponent((IProject)proj);
        if (wbModule != null && J2EEProjectUtilities.isDynamicWebProject((IProject)proj) && (webFile = wbModule.getRootFolder().getFile("WEB-INF/web.xml")).exists()) {
            this.status = super.validateInJob(inHelper, inReporter);
            this.validateWebInfLibs(wbModule);
        }
        return this.status;
    }

    private void validateWebInfLibs(IVirtualComponent component) {
        HashSet<String> webLibMappings = new HashSet<String>();
        IVirtualFolder folder = component.getRootFolder().getFolder(WebArtifactEdit.WEBLIB);
        try {
            IVirtualResource[] resources = folder.members();
            int i = 0;
            while (i < resources.length) {
                if (resources[i] instanceof IVirtualFile) {
                    IResource[] underlyingResources = resources[i].getUnderlyingResources();
                    int j = 0;
                    while (j < underlyingResources.length) {
                        webLibMappings.add(underlyingResources[j].getName());
                        ++j;
                    }
                }
                ++i;
            }
        }
        catch (CoreException coreException) {}
        HashMap<String, IPath> archiveToPath = new HashMap<String, IPath>();
        IVirtualReference[] webLibs = WebUtilities.getLibModules((IVirtualComponent)component);
        int i = 0;
        while (i < webLibs.length) {
            IVirtualComponent comp = webLibs[i].getReferencedComponent();
            String name = null;
            if (comp.isBinary()) {
                VirtualArchiveComponent archiveComp = (VirtualArchiveComponent)comp;
                File diskFile = archiveComp.getUnderlyingDiskFile();
                if (!diskFile.exists()) {
                    IFile wbFile = archiveComp.getUnderlyingWorkbenchFile();
                    diskFile = new File(wbFile.getLocation().toOSString());
                }
                this.checkLibName(diskFile.getName(), null, webLibMappings, true);
            } else {
                String archiveName = webLibs[i].getArchiveName();
                name = archiveName != null && archiveName.length() > 0 ? archiveName : String.valueOf(comp.getName()) + ".jar";
                this.checkLibName(name, comp.getProject(), webLibMappings, true);
                if (comp instanceof J2EEModuleVirtualComponent) {
                    IVirtualReference[] cpRefs = ((J2EEModuleVirtualComponent)comp).getJavaClasspathReferences();
                    int j = 0;
                    while (j < cpRefs.length) {
                        IVirtualReference ref = cpRefs[j];
                        if (ref.getReferencedComponent() instanceof VirtualArchiveComponent) {
                            String cpCompName = ref.getArchiveName();
                            this.checkLibName(cpCompName, comp.getProject(), webLibMappings, false);
                            IPath cpEntryPath = ClasspathDependencyUtil.getClasspathVirtualReferenceLocation((IVirtualReference)ref);
                            if (cpEntryPath != null) {
                                IPath existingPath = (IPath)archiveToPath.get(cpCompName);
                                if (existingPath != null && !existingPath.equals((Object)cpEntryPath)) {
                                    this._reporter.addMessage((IValidator)this, (IMessage)new Message(this.getBaseName(), 1, "ERROR_DUPLICATE_CLASSPATH_COMPONENT_URI", new String[]{cpCompName, comp.getProject().getName()}));
                                } else {
                                    archiveToPath.put(cpCompName, cpEntryPath);
                                }
                            }
                        }
                        ++j;
                    }
                }
            }
            ++i;
        }
    }

    private void checkLibName(String name, IProject project, Set webLibNames, boolean addName) {
        if (webLibNames.contains(name)) {
            if (project == null) {
                this._reporter.addMessage((IValidator)this, (IMessage)new Message(this.getBaseName(), 1, "ERROR_DUPLICATE_WEB_INF_LIB", new String[]{name}));
            }
        } else if (addName) {
            webLibNames.add(name);
        }
    }

    public void validateEARForContextRoot() {
    }

    public ISchedulingRule getSchedulingRule(IValidationContext helper) {
        IVirtualFile vf;
        IProject project = ((IWorkbenchContext)helper).getProject();
        IVirtualComponent comp = ComponentCore.createComponent((IProject)project);
        IFile webDeploymentDescriptor = null;
        if (comp != null && (vf = comp.getRootFolder().getFile((IPath)new Path("WEB-INF/web.xml"))) != null) {
            webDeploymentDescriptor = vf.getUnderlyingFile();
        }
        return webDeploymentDescriptor;
    }
}

