/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.html.ui.internal.contentassist;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.contentassist.ICompletionProposal;
import org.eclipse.jface.text.contentassist.IContentAssistProcessor;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.wst.css.ui.internal.contentassist.CSSContentAssistProcessor;
import org.eclipse.wst.html.core.internal.contentmodel.HTMLCMDocument;
import org.eclipse.wst.html.ui.StructuredTextViewerConfigurationHTML;
import org.eclipse.wst.html.ui.internal.HTMLUIPlugin;
import org.eclipse.wst.html.ui.internal.contentassist.HTMLMinimalContentModelGenerator;
import org.eclipse.wst.html.ui.internal.contentassist.HTMLTemplateCompletionProcessor;
import org.eclipse.wst.html.ui.internal.contentassist.XHTMLMinimalContentModelGenerator;
import org.eclipse.wst.html.ui.internal.preferences.HTMLUIPreferenceNames;
import org.eclipse.wst.html.ui.internal.templates.TemplateContextTypeIdsHTML;
import org.eclipse.wst.sse.core.internal.provisional.INodeAdapterFactory;
import org.eclipse.wst.sse.core.internal.provisional.INodeNotifier;
import org.eclipse.wst.sse.core.internal.provisional.IndexedRegion;
import org.eclipse.wst.sse.core.internal.provisional.text.IStructuredDocument;
import org.eclipse.wst.sse.core.internal.provisional.text.IStructuredDocumentRegion;
import org.eclipse.wst.sse.core.internal.provisional.text.ITextRegion;
import org.eclipse.wst.sse.core.internal.provisional.text.ITextRegionList;
import org.eclipse.wst.sse.ui.internal.IReleasable;
import org.eclipse.wst.sse.ui.internal.StructuredTextViewer;
import org.eclipse.wst.sse.ui.internal.contentassist.ContentAssistUtils;
import org.eclipse.wst.xml.core.internal.contentmodel.CMDocument;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMDocument;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMNode;
import org.eclipse.wst.xml.core.internal.ssemodelquery.ModelQueryAdapter;
import org.eclipse.wst.xml.ui.internal.contentassist.AbstractContentAssistProcessor;
import org.eclipse.wst.xml.ui.internal.contentassist.ContentAssistRequest;
import org.eclipse.wst.xml.ui.internal.contentassist.XMLContentModelGenerator;
import org.w3c.dom.Document;
import org.w3c.dom.DocumentType;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class HTMLContentAssistProcessor
extends AbstractContentAssistProcessor
implements IPropertyChangeListener {
    private INodeAdapterFactory factoryForCSS = null;
    protected IPreferenceStore fPreferenceStore = null;
    protected boolean isXHTML = false;
    private HTMLTemplateCompletionProcessor fTemplateProcessor = null;
    private IContentAssistProcessor fJSContentAssistProcessor = null;
    private List fTemplateContexts = new ArrayList();
    static /* synthetic */ Class class$0;

    protected void addAttributeNameProposals(ContentAssistRequest contentAssistRequest) {
        this.addTemplates(contentAssistRequest, TemplateContextTypeIdsHTML.ATTRIBUTE);
        super.addAttributeNameProposals(contentAssistRequest);
    }

    protected void addAttributeValueProposals(ContentAssistRequest contentAssistRequest) {
        this.addTemplates(contentAssistRequest, TemplateContextTypeIdsHTML.ATTRIBUTE_VALUE);
        super.addAttributeValueProposals(contentAssistRequest);
    }

    protected void addEmptyDocumentProposals(ContentAssistRequest contentAssistRequest) {
        this.addTemplates(contentAssistRequest, TemplateContextTypeIdsHTML.NEW);
    }

    protected void addPCDATAProposal(String nodeName, ContentAssistRequest contentAssistRequest) {
        if (this.isXHTML) {
            super.addPCDATAProposal(nodeName, contentAssistRequest);
        }
    }

    protected void addStartDocumentProposals(ContentAssistRequest contentAssistRequest) {
        if (this.isXHTML) {
            this.addEmptyDocumentProposals(contentAssistRequest);
        }
    }

    protected void addTagInsertionProposals(ContentAssistRequest contentAssistRequest, int childPosition) {
        this.addTemplates(contentAssistRequest, TemplateContextTypeIdsHTML.TAG);
        super.addTagInsertionProposals(contentAssistRequest, childPosition);
    }

    private void addTemplates(ContentAssistRequest contentAssistRequest, String context) {
        this.addTemplates(contentAssistRequest, context, contentAssistRequest.getReplacementBeginPosition());
    }

    private void addTemplates(ContentAssistRequest contentAssistRequest, String context, int startOffset) {
        if (contentAssistRequest == null) {
            return;
        }
        if (!this.fTemplateContexts.contains(context)) {
            boolean useProposalList;
            this.fTemplateContexts.add(context);
            boolean bl = useProposalList = !contentAssistRequest.shouldSeparate();
            if (this.getTemplateCompletionProcessor() != null) {
                this.getTemplateCompletionProcessor().setContextType(context);
                ICompletionProposal[] proposals = this.getTemplateCompletionProcessor().computeCompletionProposals(this.fTextViewer, startOffset);
                int i = 0;
                while (i < proposals.length) {
                    if (useProposalList) {
                        contentAssistRequest.addProposal(proposals[i]);
                    } else {
                        contentAssistRequest.addMacro(proposals[i]);
                    }
                    ++i;
                }
            }
        }
    }

    protected boolean beginsWith(String aString, String prefix) {
        if (aString == null || prefix == null || prefix.length() == 0) {
            return true;
        }
        int minimumLength = Math.min(prefix.length(), aString.length());
        String beginning = aString.substring(0, minimumLength);
        return beginning.equalsIgnoreCase(prefix);
    }

    protected ContentAssistRequest computeCompletionProposals(int documentPosition, String matchString, ITextRegion completionRegion, IDOMNode treeNode, IDOMNode xmlnode) {
        ContentAssistRequest request = super.computeCompletionProposals(documentPosition, matchString, completionRegion, treeNode, xmlnode);
        this.addTemplates(request, TemplateContextTypeIdsHTML.ALL, documentPosition);
        return request;
    }

    public ICompletionProposal[] computeCompletionProposals(ITextViewer textViewer, int documentPosition) {
        ITextRegionList v;
        this.fTemplateContexts.clear();
        IndexedRegion treeNode = ContentAssistUtils.getNodeAt((ITextViewer)textViewer, (int)documentPosition);
        IDOMNode node = (IDOMNode)treeNode;
        this.setErrorMessage(null);
        IStructuredDocument structuredDocument = (IStructuredDocument)textViewer.getDocument();
        IStructuredDocumentRegion fn = structuredDocument.getRegionAtCharacterOffset(documentPosition);
        if (fn != null && fn.getType() == "XML_COMMENT_TEXT" && documentPosition != fn.getStartOffset()) {
            return new ICompletionProposal[0];
        }
        if (fn != null && fn.getType() == "XML_TAG_NAME" && documentPosition == fn.getStartOffset() && (v = fn.getRegions()).size() > 1 && v.get(0).getType() == "XML_END_TAG_OPEN") {
            Iterator it = v.iterator();
            ITextRegion region = null;
            while (it.hasNext()) {
                region = (ITextRegion)it.next();
                if (!fn.getText(region).equalsIgnoreCase("script")) continue;
                IContentAssistProcessor jsProcessor = this.getJSContentAssistProcessor();
                if (jsProcessor != null) {
                    return jsProcessor.computeCompletionProposals(textViewer, documentPosition);
                }
                return new ICompletionProposal[0];
            }
        }
        this.isXHTML = this.getXHTML((Node)node);
        this.fGenerator = null;
        if (treeNode == null || this.isViewerEmpty(textViewer)) {
            ICompletionProposal htmlTagProposal = this.getHTMLTagProposal((StructuredTextViewer)textViewer, documentPosition);
            ICompletionProposal[] superResults = super.computeCompletionProposals(textViewer, documentPosition);
            if (superResults != null && superResults.length > 0 && htmlTagProposal != null) {
                ICompletionProposal[] blankHTMLDocResults = new ICompletionProposal[superResults.length + 1];
                blankHTMLDocResults[0] = htmlTagProposal;
                System.arraycopy(superResults, 0, blankHTMLDocResults, 1, superResults.length);
                return blankHTMLDocResults;
            }
        }
        if (node != null && node.getNodeType() == 1) {
            int offset;
            int pos;
            ICompletionProposal[] proposals;
            IStructuredDocumentRegion startStructuredDocumentRegion;
            IStructuredDocumentRegion endStructuredDocumentRegion;
            Element element = (Element)node;
            String tagName = element.getTagName();
            if (tagName != null && tagName.equalsIgnoreCase("style") && (endStructuredDocumentRegion = node.getEndStructuredDocumentRegion()) != null && endStructuredDocumentRegion.getStartOffset() == documentPosition && (startStructuredDocumentRegion = node.getStartStructuredDocumentRegion()) != null && (proposals = this.getCSSProposals(textViewer, pos = documentPosition - (offset = startStructuredDocumentRegion.getEndOffset()), node, offset, '\u0000')) != null) {
                return proposals;
            }
            IStructuredDocumentRegion sdRegion = ContentAssistUtils.getStructuredDocumentRegion((ITextViewer)textViewer, (int)documentPosition);
            Iterator regions = sdRegion.getRegions().iterator();
            ITextRegion styleNameRegion = null;
            ITextRegion styleValueRegion = null;
            while (regions.hasNext()) {
                styleNameRegion = (ITextRegion)regions.next();
                if (!styleNameRegion.getType().equals("XML_TAG_ATTRIBUTE_NAME") || !sdRegion.getText(styleNameRegion).equalsIgnoreCase("style") || !regions.hasNext()) continue;
                regions.next();
                if (!regions.hasNext()) continue;
                styleValueRegion = (ITextRegion)regions.next();
                break;
            }
            if (styleValueRegion != null) {
                int offset2 = sdRegion.getStartOffset(styleValueRegion);
                int end = sdRegion.getTextEndOffset(styleValueRegion);
                if (documentPosition >= offset2 && documentPosition <= end) {
                    int pos2;
                    ICompletionProposal[] proposals2;
                    int length;
                    boolean askCSS = true;
                    char quote = '\u0000';
                    String text = sdRegion.getText(styleValueRegion);
                    int n = length = text != null ? text.length() : 0;
                    if (length > 0) {
                        char firstChar = text.charAt(0);
                        if (firstChar == '\"' || firstChar == '\'') {
                            if (documentPosition == offset2) {
                                askCSS = false;
                            } else {
                                ++offset2;
                                quote = firstChar;
                            }
                        }
                        if (documentPosition == end && length > 1 && text.charAt(length - 1) == quote) {
                            askCSS = false;
                        }
                    }
                    if (askCSS && (proposals2 = this.getCSSProposals(textViewer, pos2 = documentPosition - offset2, node, offset2, quote)) != null) {
                        return proposals2;
                    }
                }
            }
        }
        return super.computeCompletionProposals(textViewer, documentPosition);
    }

    private boolean isViewerEmpty(ITextViewer textViewer) {
        boolean isEmpty = false;
        String text = textViewer.getTextWidget().getText();
        if (text == null || text != null && text.trim().equals("")) {
            isEmpty = true;
        }
        return isEmpty;
    }

    /*
     * Exception decompiling
     */
    private ICompletionProposal getHTMLTagProposal(StructuredTextViewer viewer, int documentPosition) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Back jump on a try block [egrp 1[TRYBLOCK] [1 : 208->211)] java.lang.Throwable
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.insertExceptionBlocks(Op02WithProcessedDataAndRefs.java:2283)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:415)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public XMLContentModelGenerator getContentGenerator() {
        if (this.fGenerator == null) {
            this.fGenerator = this.isXHTML ? XHTMLMinimalContentModelGenerator.getInstance() : HTMLMinimalContentModelGenerator.getInstance();
        }
        return this.fGenerator;
    }

    protected ICompletionProposal[] getCSSProposals(ITextViewer viewer, int pos, IDOMNode element, int offset, char quote) {
        CSSContentAssistProcessor cssProcessor = new CSSContentAssistProcessor();
        cssProcessor.setDocumentOffset(offset);
        cssProcessor.setQuoteCharOfStyleAttribute(quote);
        return cssProcessor.computeCompletionProposals(viewer, pos);
    }

    protected String getEmptyTagCloseString() {
        if (this.isXHTML) {
            return " />";
        }
        return ">";
    }

    private IContentAssistProcessor getJSContentAssistProcessor() {
        if (this.fJSContentAssistProcessor == null) {
            this.fJSContentAssistProcessor = new StructuredTextViewerConfigurationHTML().getContentAssistant(null).getContentAssistProcessor("org.eclipse.wst.html.SCRIPT");
        }
        return this.fJSContentAssistProcessor;
    }

    private HTMLTemplateCompletionProcessor getTemplateCompletionProcessor() {
        if (this.fTemplateProcessor == null) {
            this.fTemplateProcessor = new HTMLTemplateCompletionProcessor();
        }
        return this.fTemplateProcessor;
    }

    protected boolean getXHTML(Node node) {
        DocumentType docType;
        if (node == null) {
            return false;
        }
        Document doc = null;
        doc = node.getNodeType() != 9 ? node.getOwnerDocument() : (Document)node;
        if (doc instanceof IDOMDocument) {
            return ((IDOMDocument)doc).isXMLType();
        }
        if (doc instanceof INodeNotifier) {
            INodeNotifier iNodeNotifier = (INodeNotifier)doc;
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("org.eclipse.wst.xml.core.internal.ssemodelquery.ModelQueryAdapter");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            ModelQueryAdapter adapter = (ModelQueryAdapter)iNodeNotifier.getAdapterFor((Object)clazz);
            CMDocument cmdoc = null;
            if (adapter != null && adapter.getModelQuery() != null) {
                cmdoc = adapter.getModelQuery().getCorrespondingCMDocument((Node)doc);
            }
            if (cmdoc != null) {
                if (cmdoc instanceof HTMLCMDocument) {
                    return false;
                }
                if (cmdoc.supports("isXHTML")) {
                    return Boolean.TRUE.equals(cmdoc.getProperty("isXHTML"));
                }
            }
        }
        return (docType = doc.getDoctype()) != null && docType.getPublicId() != null && docType.getPublicId().indexOf("-//W3C//DTD XHTML ") == 0;
    }

    protected void init() {
        this.getPreferenceStore().addPropertyChangeListener((IPropertyChangeListener)this);
        this.reinit();
    }

    protected void reinit() {
        String key = HTMLUIPreferenceNames.AUTO_PROPOSE;
        boolean doAuto = this.getPreferenceStore().getBoolean(key);
        if (doAuto) {
            key = HTMLUIPreferenceNames.AUTO_PROPOSE_CODE;
            this.completionProposalAutoActivationCharacters = this.getPreferenceStore().getString(key).toCharArray();
        } else {
            this.completionProposalAutoActivationCharacters = null;
        }
    }

    public void release() {
        if (this.factoryForCSS != null) {
            this.factoryForCSS.release();
        }
        if (this.fJSContentAssistProcessor instanceof IReleasable) {
            ((IReleasable)this.fJSContentAssistProcessor).release();
        }
        this.getPreferenceStore().removePropertyChangeListener((IPropertyChangeListener)this);
        super.release();
    }

    protected boolean stringsEqual(String a, String b) {
        return a.equalsIgnoreCase(b);
    }

    public void propertyChange(PropertyChangeEvent event) {
        String property = event.getProperty();
        if (property.compareTo(HTMLUIPreferenceNames.AUTO_PROPOSE) == 0 || property.compareTo(HTMLUIPreferenceNames.AUTO_PROPOSE_CODE) == 0) {
            this.reinit();
        }
    }

    protected IPreferenceStore getPreferenceStore() {
        if (this.fPreferenceStore == null) {
            this.fPreferenceStore = HTMLUIPlugin.getDefault().getPreferenceStore();
        }
        return this.fPreferenceStore;
    }

    public ICompletionProposal[] computeCompletionProposals(ITextViewer viewer, int documentPosition, IndexedRegion indexedNode, ITextRegion region) {
        return this.computeCompletionProposals(viewer, documentPosition);
    }
}

