/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.ui.typehierarchy;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.Assert;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.wst.jsdt.core.IFunction;
import org.eclipse.wst.jsdt.core.IJavaScriptElement;
import org.eclipse.wst.jsdt.core.IMember;
import org.eclipse.wst.jsdt.core.IType;
import org.eclipse.wst.jsdt.core.ITypeHierarchy;
import org.eclipse.wst.jsdt.core.JavaScriptModelException;
import org.eclipse.wst.jsdt.internal.corext.util.JavaModelUtil;
import org.eclipse.wst.jsdt.internal.corext.util.MethodOverrideTester;
import org.eclipse.wst.jsdt.internal.ui.typehierarchy.ITypeHierarchyLifeCycleListener;
import org.eclipse.wst.jsdt.internal.ui.typehierarchy.TypeHierarchyLifeCycle;
import org.eclipse.wst.jsdt.ui.IWorkingCopyProvider;

public abstract class TypeHierarchyContentProvider
implements ITreeContentProvider,
IWorkingCopyProvider {
    protected static final Object[] NO_ELEMENTS = new Object[0];
    protected TypeHierarchyLifeCycle fTypeHierarchy;
    protected IMember[] fMemberFilter;
    protected TreeViewer fViewer;
    private ViewerFilter fWorkingSetFilter;
    private MethodOverrideTester fMethodOverrideTester;
    private ITypeHierarchyLifeCycleListener fTypeHierarchyLifeCycleListener;

    public TypeHierarchyContentProvider(TypeHierarchyLifeCycle lifecycle) {
        this.fTypeHierarchy = lifecycle;
        this.fMemberFilter = null;
        this.fWorkingSetFilter = null;
        this.fMethodOverrideTester = null;
        this.fTypeHierarchyLifeCycleListener = new ITypeHierarchyLifeCycleListener(){

            public void typeHierarchyChanged(TypeHierarchyLifeCycle typeHierarchyProvider, IType[] changedTypes) {
                if (changedTypes == null) {
                    TypeHierarchyContentProvider.this.fMethodOverrideTester = null;
                }
            }
        };
        lifecycle.addChangedListener(this.fTypeHierarchyLifeCycleListener);
    }

    public final void setMemberFilter(IMember[] memberFilter) {
        this.fMemberFilter = memberFilter;
    }

    private boolean initializeMethodOverrideTester(IFunction filterMethod, IType typeToFindIn) {
        IType focusType;
        IType filterType = filterMethod.getDeclaringType();
        ITypeHierarchy hierarchy = this.fTypeHierarchy.getHierarchy();
        boolean filterOverrides = JavaModelUtil.isSuperType(hierarchy, typeToFindIn, filterType);
        IType iType = focusType = filterOverrides ? filterType : typeToFindIn;
        if (this.fMethodOverrideTester == null || !this.fMethodOverrideTester.getFocusType().equals(focusType)) {
            this.fMethodOverrideTester = new MethodOverrideTester(focusType, hierarchy);
        }
        return filterOverrides;
    }

    private void addCompatibleMethods(IFunction filterMethod, IType typeToFindIn, List children) throws JavaScriptModelException {
        boolean filterMethodOverrides = this.initializeMethodOverrideTester(filterMethod, typeToFindIn);
        IFunction[] methods = typeToFindIn.getFunctions();
        int i = 0;
        while (i < methods.length) {
            IFunction curr = methods[i];
            if (this.isCompatibleMethod(filterMethod, curr, filterMethodOverrides) && !children.contains(curr)) {
                children.add(curr);
            }
            ++i;
        }
    }

    private boolean hasCompatibleMethod(IFunction filterMethod, IType typeToFindIn) throws JavaScriptModelException {
        boolean filterMethodOverrides = this.initializeMethodOverrideTester(filterMethod, typeToFindIn);
        IFunction[] methods = typeToFindIn.getFunctions();
        int i = 0;
        while (i < methods.length) {
            if (this.isCompatibleMethod(filterMethod, methods[i], filterMethodOverrides)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    private boolean isCompatibleMethod(IFunction filterMethod, IFunction method, boolean filterOverrides) throws JavaScriptModelException {
        if (filterOverrides) {
            return this.fMethodOverrideTester.isSubsignature(filterMethod, method);
        }
        return this.fMethodOverrideTester.isSubsignature(method, filterMethod);
    }

    public IMember[] getMemberFilter() {
        return this.fMemberFilter;
    }

    public void setWorkingSetFilter(ViewerFilter filter) {
        this.fWorkingSetFilter = filter;
    }

    protected final ITypeHierarchy getHierarchy() {
        return this.fTypeHierarchy.getHierarchy();
    }

    public boolean providesWorkingCopies() {
        return true;
    }

    public Object[] getElements(Object parent) {
        ArrayList types = new ArrayList();
        this.getRootTypes(types);
        int i = types.size() - 1;
        while (i >= 0) {
            IType curr = (IType)types.get(i);
            try {
                if (!this.isInTree(curr)) {
                    types.remove(i);
                }
            }
            catch (JavaScriptModelException javaScriptModelException) {}
            --i;
        }
        return types.toArray();
    }

    protected void getRootTypes(List res) {
        IType input;
        ITypeHierarchy hierarchy = this.getHierarchy();
        if (hierarchy != null && (input = hierarchy.getType()) != null) {
            res.add(input);
        }
    }

    protected abstract void getTypesInHierarchy(IType var1, List var2);

    protected abstract IType getParentType(IType var1);

    private boolean isInScope(IType type) {
        if (this.fWorkingSetFilter != null && !this.fWorkingSetFilter.select(null, null, (Object)type)) {
            return false;
        }
        IJavaScriptElement input = this.fTypeHierarchy.getInputElement();
        int inputType = input.getElementType();
        if (inputType == 7) {
            return true;
        }
        IJavaScriptElement parent = type.getAncestor(input.getElementType());
        return inputType == 4 ? parent == null || parent.getElementName().equals(input.getElementName()) : input.equals(parent);
    }

    public Object[] getChildren(Object element) {
        if (element instanceof IType) {
            try {
                IType type = (IType)element;
                ArrayList children = new ArrayList();
                if (this.fMemberFilter != null) {
                    this.addFilteredMemberChildren(type, children);
                }
                this.addTypeChildren(type, children);
                return children.toArray();
            }
            catch (JavaScriptModelException javaScriptModelException) {}
        }
        return NO_ELEMENTS;
    }

    public boolean hasChildren(Object element) {
        if (element instanceof IType) {
            try {
                IType type = (IType)element;
                return this.hasTypeChildren(type) || this.fMemberFilter != null && this.hasMemberFilterChildren(type);
            }
            catch (JavaScriptModelException javaScriptModelException) {
                return false;
            }
        }
        return false;
    }

    private void addFilteredMemberChildren(IType parent, List children) throws JavaScriptModelException {
        int i = 0;
        while (i < this.fMemberFilter.length) {
            IMember member = this.fMemberFilter[i];
            if (parent.equals(member.getDeclaringType())) {
                if (!children.contains(member)) {
                    children.add(member);
                }
            } else if (member instanceof IFunction) {
                this.addCompatibleMethods((IFunction)member, parent, children);
            }
            ++i;
        }
    }

    private void addTypeChildren(IType type, List children) throws JavaScriptModelException {
        ArrayList types = new ArrayList();
        this.getTypesInHierarchy(type, types);
        int len = types.size();
        int i = 0;
        while (i < len) {
            IType curr = (IType)types.get(i);
            if (this.isInTree(curr)) {
                children.add(curr);
            }
            ++i;
        }
    }

    protected final boolean isInTree(IType type) throws JavaScriptModelException {
        if (this.isInScope(type)) {
            if (this.fMemberFilter != null) {
                return this.hasMemberFilterChildren(type) || this.hasTypeChildren(type);
            }
            return true;
        }
        return this.hasTypeChildren(type);
    }

    private boolean hasMemberFilterChildren(IType type) throws JavaScriptModelException {
        int i = 0;
        while (i < this.fMemberFilter.length) {
            IMember member = this.fMemberFilter[i];
            if (type.equals(member.getDeclaringType())) {
                return true;
            }
            if (member instanceof IFunction && this.hasCompatibleMethod((IFunction)member, type)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    private boolean hasTypeChildren(IType type) throws JavaScriptModelException {
        ArrayList types = new ArrayList();
        this.getTypesInHierarchy(type, types);
        int len = types.size();
        int i = 0;
        while (i < len) {
            IType curr = (IType)types.get(i);
            if (this.isInTree(curr)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public void inputChanged(Viewer part, Object oldInput, Object newInput) {
        Assert.isTrue((boolean)(part instanceof TreeViewer));
        this.fViewer = (TreeViewer)part;
    }

    public void dispose() {
        this.fTypeHierarchy.removeChangedListener(this.fTypeHierarchyLifeCycleListener);
    }

    public Object getParent(Object element) {
        if (element instanceof IMember) {
            IMember member = (IMember)element;
            if (member.getElementType() == 7) {
                return this.getParentType((IType)member);
            }
            return member.getDeclaringType();
        }
        return null;
    }

    protected final boolean isAnonymous(IType type) {
        return type.getElementName().length() == 0;
    }

    protected final boolean isAnonymousFromInterface(IType type) {
        return this.isAnonymous(type) && this.fTypeHierarchy.getHierarchy().getSuperInterfaces(type).length != 0;
    }

    protected final boolean isObject(IType type) {
        return "Object".equals(type.getElementName()) && type.getDeclaringType() == null && "java.lang".equals(type.getPackageFragment().getElementName());
    }
}

