/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.sse.ui.internal.correction;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.jface.text.quickassist.IQuickAssistProcessor;
import org.eclipse.jface.text.source.Annotation;
import org.eclipse.wst.sse.ui.internal.correction.AnnotationQuery;
import org.eclipse.wst.sse.ui.internal.correction.AnnotationQueryResult;
import org.eclipse.wst.sse.ui.internal.correction.QuickFixRegistryReader;

public class QuickFixRegistry {
    private static QuickFixRegistry instance;
    private Map resolutionQueries = new HashMap();
    private static final String ATT_CLASS = "class";

    public static synchronized QuickFixRegistry getInstance() {
        if (instance == null) {
            instance = new QuickFixRegistry();
            new QuickFixRegistryReader().addHelp(instance);
        }
        return instance;
    }

    void addResolutionQuery(AnnotationQuery query, AnnotationQueryResult result, IConfigurationElement element) {
        this.addQuery(this.resolutionQueries, query, result, element);
    }

    private void addQuery(Map table, AnnotationQuery query, AnnotationQueryResult result, IConfigurationElement element) {
        HashMap results = (HashMap)table.get(query);
        if (results == null) {
            results = new HashMap();
            table.put(query, results);
        }
        if (results.containsKey(result)) {
            Collection currentElements = (Collection)results.get(result);
            currentElements.add(element);
        } else {
            HashSet<IConfigurationElement> elements = new HashSet<IConfigurationElement>();
            elements.add(element);
            results.put(result, elements);
        }
    }

    public IQuickAssistProcessor[] getQuickFixProcessors(Annotation anno) {
        ArrayList<IQuickAssistProcessor> processors = new ArrayList<IQuickAssistProcessor>();
        Iterator iter = this.resolutionQueries.keySet().iterator();
        while (iter.hasNext()) {
            Map resultsTable;
            AnnotationQuery query = (AnnotationQuery)iter.next();
            AnnotationQueryResult result = query.performQuery(anno);
            if (result == null || !(resultsTable = (Map)this.resolutionQueries.get(query)).containsKey(result)) continue;
            Iterator elements = ((Collection)resultsTable.get(result)).iterator();
            while (elements.hasNext()) {
                IConfigurationElement element = (IConfigurationElement)elements.next();
                IQuickAssistProcessor processor = null;
                try {
                    processor = (IQuickAssistProcessor)element.createExecutableExtension(ATT_CLASS);
                }
                catch (CoreException coreException) {}
                if (processor == null) continue;
                processors.add(processor);
            }
        }
        return processors.toArray(new IQuickAssistProcessor[processors.size()]);
    }
}

