/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.ui.workingsets;

import com.ibm.icu.text.Collator;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITreeSelection;
import org.eclipse.jface.viewers.TreePath;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.FontMetrics;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.IWorkingSet;
import org.eclipse.ui.IWorkingSetManager;
import org.eclipse.ui.PlatformUI;
import org.eclipse.wst.jsdt.internal.ui.workingsets.SimpleWorkingSetSelectionDialog;
import org.eclipse.wst.jsdt.internal.ui.workingsets.WorkingSetMessages;

public class WorkingSetConfigurationBlock {
    private static final String WORKINGSET_SELECTION_HISTORY = "workingset_selection_history";
    private static final int MAX_HISTORY_SIZE = 5;
    private Label fLabel;
    private Combo fWorkingSetCombo;
    private Button fConfigure;
    private IWorkingSet[] fSelectedWorkingSets;
    private String fMessage;
    private Button fEnableButton;
    private ArrayList fSelectionHistory;
    private final IDialogSettings fSettings;
    private final String fEnableButtonText;
    private final String[] fWorkingSetIds;

    public static IWorkingSet[] getSelectedWorkingSet(IStructuredSelection selection) {
        if (!(selection instanceof ITreeSelection)) {
            return null;
        }
        ITreeSelection treeSelection = (ITreeSelection)selection;
        if (treeSelection.isEmpty()) {
            return null;
        }
        List elements = treeSelection.toList();
        if (elements.size() == 1) {
            Object element = elements.get(0);
            TreePath[] paths = treeSelection.getPathsFor(element);
            if (paths.length != 1) {
                return null;
            }
            TreePath path = paths[0];
            if (path.getSegmentCount() == 0) {
                return null;
            }
            Object candidate = path.getSegment(0);
            if (!(candidate instanceof IWorkingSet)) {
                return null;
            }
            return new IWorkingSet[]{(IWorkingSet)candidate};
        }
        ArrayList result = new ArrayList();
        Iterator iterator = elements.iterator();
        while (iterator.hasNext()) {
            Object element = iterator.next();
            if (!(element instanceof IWorkingSet)) continue;
            result.add(element);
        }
        return result.toArray(new IWorkingSet[result.size()]);
    }

    public static void addToWorkingSets(IAdaptable element, IWorkingSet[] workingSets) {
        int i = 0;
        while (i < workingSets.length) {
            IWorkingSet workingSet = workingSets[i];
            IAdaptable[] adaptedNewElements = workingSet.adaptElements(new IAdaptable[]{element});
            if (adaptedNewElements.length == 1) {
                IAdaptable[] elements = workingSet.getElements();
                IAdaptable[] newElements = new IAdaptable[elements.length + 1];
                System.arraycopy(elements, 0, newElements, 0, elements.length);
                newElements[newElements.length - 1] = adaptedNewElements[0];
                workingSet.setElements(newElements);
            }
            ++i;
        }
    }

    public static IWorkingSet[] filter(IWorkingSet[] workingSets, String[] workingSetIds) {
        ArrayList<IWorkingSet> result = new ArrayList<IWorkingSet>();
        int i = 0;
        while (i < workingSets.length) {
            if (WorkingSetConfigurationBlock.accept(workingSets[i], workingSetIds)) {
                result.add(workingSets[i]);
            }
            ++i;
        }
        return result.toArray(new IWorkingSet[result.size()]);
    }

    private static boolean accept(IWorkingSet set, String[] workingSetIDs) {
        int i = 0;
        while (i < workingSetIDs.length) {
            if (workingSetIDs[i].equals(set.getId())) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public WorkingSetConfigurationBlock(String[] workingSetIds, String enableButtonText, IDialogSettings settings) {
        Assert.isNotNull((Object)workingSetIds);
        Assert.isNotNull((Object)enableButtonText);
        Assert.isNotNull((Object)settings);
        this.fWorkingSetIds = workingSetIds;
        this.fEnableButtonText = enableButtonText;
        this.fSelectedWorkingSets = new IWorkingSet[0];
        this.fSettings = settings;
        this.fSelectionHistory = this.loadSelectionHistory(settings, workingSetIds);
    }

    public void setDialogMessage(String message) {
        this.fMessage = message;
    }

    public void setSelection(IWorkingSet[] selection) {
        if (selection == null) {
            selection = new IWorkingSet[]{};
        }
        this.fSelectedWorkingSets = selection;
        if (this.fWorkingSetCombo != null) {
            this.updateSelectedWorkingSets();
        }
    }

    public IWorkingSet[] getSelectedWorkingSets() {
        if (this.fEnableButton.getSelection()) {
            return this.fSelectedWorkingSets;
        }
        return new IWorkingSet[0];
    }

    public void createContent(final Composite parent) {
        int numColumn = 3;
        Composite composite = new Composite(parent, 0);
        composite.setLayoutData((Object)new GridData(4, 128, true, false));
        composite.setLayout((Layout)new GridLayout(numColumn, false));
        this.fEnableButton = new Button(composite, 32);
        this.fEnableButton.setText(this.fEnableButtonText);
        GridData enableData = new GridData(4, 0x1000000, true, false);
        enableData.horizontalSpan = numColumn;
        this.fEnableButton.setLayoutData((Object)enableData);
        this.fEnableButton.setSelection(this.fSelectedWorkingSets.length > 0);
        this.fLabel = new Label(composite, 0);
        this.fLabel.setText(WorkingSetMessages.WorkingSetConfigurationBlock_WorkingSetText_name);
        this.fWorkingSetCombo = new Combo(composite, 2056);
        GridData textData = new GridData(4, 0x1000000, true, false);
        textData.horizontalSpan = numColumn - 2;
        textData.horizontalIndent = 0;
        this.fWorkingSetCombo.setLayoutData((Object)textData);
        this.fConfigure = new Button(composite, 8);
        this.fConfigure.setText(WorkingSetMessages.WorkingSetConfigurationBlock_SelectWorkingSet_button);
        GridData configureData = new GridData(16384, 0x1000000, false, false);
        configureData.widthHint = WorkingSetConfigurationBlock.getButtonWidthHint(this.fConfigure);
        this.fConfigure.setLayoutData((Object)configureData);
        this.fConfigure.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                SimpleWorkingSetSelectionDialog dialog = new SimpleWorkingSetSelectionDialog(parent.getShell(), WorkingSetConfigurationBlock.this.fWorkingSetIds, WorkingSetConfigurationBlock.this.fSelectedWorkingSets);
                if (WorkingSetConfigurationBlock.this.fMessage != null) {
                    dialog.setMessage(WorkingSetConfigurationBlock.this.fMessage);
                }
                if (dialog.open() == 0) {
                    IWorkingSet[] result = dialog.getSelection();
                    if (result != null && result.length > 0) {
                        WorkingSetConfigurationBlock.this.fSelectedWorkingSets = result;
                        PlatformUI.getWorkbench().getWorkingSetManager().addRecentWorkingSet(result[0]);
                    } else {
                        WorkingSetConfigurationBlock.this.fSelectedWorkingSets = new IWorkingSet[0];
                    }
                    WorkingSetConfigurationBlock.this.updateWorkingSetSelection();
                }
            }
        });
        this.fEnableButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                WorkingSetConfigurationBlock.this.updateEnableState(WorkingSetConfigurationBlock.this.fEnableButton.getSelection());
            }
        });
        this.updateEnableState(this.fEnableButton.getSelection());
        this.fWorkingSetCombo.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                WorkingSetConfigurationBlock.this.updateSelectedWorkingSets();
            }
        });
        this.fWorkingSetCombo.setItems(this.getHistoryEntries());
        if (this.fSelectedWorkingSets.length == 0 && this.fSelectionHistory.size() > 0) {
            this.fWorkingSetCombo.select(this.historyIndex((String)this.fSelectionHistory.get(0)));
            this.updateSelectedWorkingSets();
        } else {
            this.updateWorkingSetSelection();
        }
    }

    private void updateEnableState(boolean enabled) {
        this.fLabel.setEnabled(enabled);
        this.fWorkingSetCombo.setEnabled(enabled && (this.fSelectedWorkingSets.length > 0 || this.getHistoryEntries().length > 0));
        this.fConfigure.setEnabled(enabled);
    }

    private void updateWorkingSetSelection() {
        if (this.fSelectedWorkingSets.length > 0) {
            this.fWorkingSetCombo.setEnabled(true);
            StringBuffer buf = new StringBuffer();
            buf.append(this.fSelectedWorkingSets[0].getLabel());
            int i = 1;
            while (i < this.fSelectedWorkingSets.length) {
                IWorkingSet ws = this.fSelectedWorkingSets[i];
                buf.append(',').append(' ');
                buf.append(ws.getLabel());
                ++i;
            }
            String currentSelection = buf.toString();
            int index = this.historyIndex(currentSelection);
            this.historyInsert(currentSelection);
            if (index >= 0) {
                this.fWorkingSetCombo.select(index);
            } else {
                this.fWorkingSetCombo.setItems(this.getHistoryEntries());
                this.fWorkingSetCombo.select(this.historyIndex(currentSelection));
            }
        } else {
            this.fEnableButton.setSelection(false);
            this.updateEnableState(false);
        }
    }

    private String[] getHistoryEntries() {
        String[] history = this.fSelectionHistory.toArray(new String[this.fSelectionHistory.size()]);
        Arrays.sort(history, new Comparator(){

            public int compare(Object o1, Object o2) {
                return Collator.getInstance().compare(o1, o2);
            }
        });
        return history;
    }

    private void historyInsert(String entry) {
        this.fSelectionHistory.remove(entry);
        this.fSelectionHistory.add(0, entry);
        this.storeSelectionHistory(this.fSettings);
    }

    private int historyIndex(String entry) {
        int i = 0;
        while (i < this.fWorkingSetCombo.getItemCount()) {
            if (this.fWorkingSetCombo.getItem(i).equals(entry)) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    private void updateSelectedWorkingSets() {
        String item = this.fWorkingSetCombo.getItem(this.fWorkingSetCombo.getSelectionIndex());
        String[] workingSetNames = item.split(", ");
        IWorkingSetManager workingSetManager = PlatformUI.getWorkbench().getWorkingSetManager();
        this.fSelectedWorkingSets = new IWorkingSet[workingSetNames.length];
        int i = 0;
        while (i < workingSetNames.length) {
            IWorkingSet set = workingSetManager.getWorkingSet(workingSetNames[i]);
            Assert.isNotNull((Object)set);
            this.fSelectedWorkingSets[i] = set;
            ++i;
        }
    }

    private void storeSelectionHistory(IDialogSettings settings) {
        String[] history;
        if (this.fSelectionHistory.size() > 5) {
            List subList = this.fSelectionHistory.subList(0, 5);
            history = subList.toArray(new String[subList.size()]);
        } else {
            history = this.fSelectionHistory.toArray(new String[this.fSelectionHistory.size()]);
        }
        settings.put(WORKINGSET_SELECTION_HISTORY, history);
    }

    private ArrayList loadSelectionHistory(IDialogSettings settings, String[] workingSetIds) {
        String[] strings = settings.getArray(WORKINGSET_SELECTION_HISTORY);
        if (strings == null || strings.length == 0) {
            return new ArrayList();
        }
        ArrayList<String> result = new ArrayList<String>();
        HashSet<String> workingSetIdsSet = new HashSet<String>(Arrays.asList(workingSetIds));
        IWorkingSetManager workingSetManager = PlatformUI.getWorkbench().getWorkingSetManager();
        int i = 0;
        while (i < strings.length) {
            String[] workingSetNames = strings[i].split(", ");
            boolean valid = true;
            int j = 0;
            while (j < workingSetNames.length && valid) {
                IWorkingSet workingSet = workingSetManager.getWorkingSet(workingSetNames[j]);
                if (workingSet == null) {
                    valid = false;
                } else if (!workingSetIdsSet.contains(workingSet.getId())) {
                    valid = false;
                }
                ++j;
            }
            if (valid) {
                result.add(strings[i]);
            }
            ++i;
        }
        return result;
    }

    private static int getButtonWidthHint(Button button) {
        button.setFont(JFaceResources.getDialogFont());
        GC gc = new GC((Drawable)button);
        gc.setFont(button.getFont());
        FontMetrics fontMetrics = gc.getFontMetrics();
        gc.dispose();
        int widthHint = Dialog.convertHorizontalDLUsToPixels((FontMetrics)fontMetrics, (int)61);
        return Math.max(widthHint, button.computeSize((int)-1, (int)-1, (boolean)true).x);
    }
}

