/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.ui.internal.listeners;

import org.eclipse.jpt.utility.model.event.TreeChangeEvent;
import org.eclipse.jpt.utility.model.listener.TreeChangeListener;
import org.eclipse.swt.widgets.Display;

public class SWTTreeChangeListenerWrapper
implements TreeChangeListener {
    private final TreeChangeListener listener;

    public SWTTreeChangeListenerWrapper(TreeChangeListener listener) {
        if (listener == null) {
            throw new NullPointerException();
        }
        this.listener = listener;
    }

    public void nodeAdded(TreeChangeEvent event) {
        if (this.isExecutingUIThread()) {
            this.nodeAdded_(event);
        } else {
            this.executeOnUIThread(this.buildNodeAddedRunnable(event));
        }
    }

    public void nodeRemoved(TreeChangeEvent event) {
        if (this.isExecutingUIThread()) {
            this.nodeRemoved_(event);
        } else {
            this.executeOnUIThread(this.buildNodeRemovedRunnable(event));
        }
    }

    public void treeCleared(TreeChangeEvent event) {
        if (this.isExecutingUIThread()) {
            this.treeCleared_(event);
        } else {
            this.executeOnUIThread(this.buildTreeClearedRunnable(event));
        }
    }

    public void treeChanged(TreeChangeEvent event) {
        if (this.isExecutingUIThread()) {
            this.treeChanged_(event);
        } else {
            this.executeOnUIThread(this.buildTreeChangedRunnable(event));
        }
    }

    private Runnable buildNodeAddedRunnable(final TreeChangeEvent event) {
        return new Runnable(){

            public void run() {
                SWTTreeChangeListenerWrapper.this.nodeAdded_(event);
            }

            public String toString() {
                return "node added";
            }
        };
    }

    private Runnable buildNodeRemovedRunnable(final TreeChangeEvent event) {
        return new Runnable(){

            public void run() {
                SWTTreeChangeListenerWrapper.this.nodeRemoved_(event);
            }

            public String toString() {
                return "node removed";
            }
        };
    }

    private Runnable buildTreeClearedRunnable(final TreeChangeEvent event) {
        return new Runnable(){

            public void run() {
                SWTTreeChangeListenerWrapper.this.treeCleared_(event);
            }

            public String toString() {
                return "tree cleared";
            }
        };
    }

    private Runnable buildTreeChangedRunnable(final TreeChangeEvent event) {
        return new Runnable(){

            public void run() {
                SWTTreeChangeListenerWrapper.this.treeChanged_(event);
            }

            public String toString() {
                return "tree changed";
            }
        };
    }

    private boolean isExecutingUIThread() {
        return Display.getCurrent() != null;
    }

    private void executeOnUIThread(Runnable r) {
        Display.getDefault().asyncExec(r);
    }

    void nodeAdded_(TreeChangeEvent event) {
        this.listener.nodeAdded(event);
    }

    void nodeRemoved_(TreeChangeEvent event) {
        this.listener.nodeRemoved(event);
    }

    void treeCleared_(TreeChangeEvent event) {
        this.listener.treeCleared(event);
    }

    void treeChanged_(TreeChangeEvent event) {
        this.listener.treeChanged(event);
    }

    public String toString() {
        return "SWT(" + this.listener.toString() + ")";
    }
}

