/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.ws.internal.explorer.platform.wsil.actions;

import java.util.Enumeration;
import java.util.List;
import org.apache.wsil.WSILDocument;
import org.eclipse.wst.ws.internal.datamodel.Element;
import org.eclipse.wst.ws.internal.explorer.platform.actions.FormAction;
import org.eclipse.wst.ws.internal.explorer.platform.datamodel.TreeElement;
import org.eclipse.wst.ws.internal.explorer.platform.perspective.Controller;
import org.eclipse.wst.ws.internal.explorer.platform.perspective.FormTool;
import org.eclipse.wst.ws.internal.explorer.platform.perspective.MessageQueue;
import org.eclipse.wst.ws.internal.explorer.platform.perspective.Node;
import org.eclipse.wst.ws.internal.explorer.platform.perspective.NodeManager;
import org.eclipse.wst.ws.internal.explorer.platform.perspective.ToolManager;
import org.eclipse.wst.ws.internal.explorer.platform.util.MultipartFormDataException;
import org.eclipse.wst.ws.internal.explorer.platform.util.MultipartFormDataParser;
import org.eclipse.wst.ws.internal.explorer.platform.util.URLUtils;
import org.eclipse.wst.ws.internal.explorer.platform.wsil.actions.SelectWSILToolAction;
import org.eclipse.wst.ws.internal.explorer.platform.wsil.datamodel.WsilElement;
import org.eclipse.wst.ws.internal.explorer.platform.wsil.perspective.WSILPerspective;
import org.eclipse.wst.ws.internal.parser.discovery.WebServicesParserExt;
import org.eclipse.wst.ws.internal.parser.wsil.WebServiceEntity;

public class OpenWSILAction
extends FormAction {
    public OpenWSILAction(Controller controller) {
        super(controller);
    }

    protected boolean processParsedResults(MultipartFormDataParser parser) throws MultipartFormDataException {
        String wsilURL = parser.getParameter("wsilURL");
        String inspectionType = parser.getParameter("wsilInspectionType");
        FormTool formTool = this.getSelectedFormTool();
        this.propertyTable_.put("wsilURL", wsilURL);
        if (inspectionType != null && inspectionType.length() > 0) {
            this.propertyTable_.put("wsilInspectionType", inspectionType);
        }
        formTool.updatePropertyTable(this.propertyTable_);
        return true;
    }

    public FormTool getSelectedFormTool() {
        WSILPerspective wsilPerspective = this.controller_.getWSILPerspective();
        return (FormTool)wsilPerspective.getNodeManager().getSelectedNode().getToolManager().getSelectedTool();
    }

    public boolean run() {
        String wsilURL = (String)this.propertyTable_.get("wsilURL");
        wsilURL = URLUtils.encodeURLString(wsilURL);
        int inspectionType = Integer.parseInt((String)this.propertyTable_.get("wsilInspectionType"));
        WSILPerspective wsilPerspective = this.controller_.getWSILPerspective();
        MessageQueue msgQueue = wsilPerspective.getMessageQueue();
        NodeManager nodeManager = wsilPerspective.getNodeManager();
        Node rootNode = nodeManager.getRootNode();
        TreeElement root = rootNode.getTreeElement();
        WsilElement wsilElement = this.getOpenedWSIL(root, wsilURL);
        if (wsilElement == null) {
            WebServicesParserExt parser = new WebServicesParserExt(wsilURL);
            try {
                parser.parse(0);
                WebServiceEntity wsEntity = parser.getWebServiceEntityByURI(wsilURL);
                int type = wsEntity.getType();
                if (type == 0) {
                    return this.openHTML(wsEntity.getChildren(), inspectionType);
                }
                if (type == 1) {
                    return this.openWSIL(wsilURL, parser.getWSILDocument(wsilURL), inspectionType);
                }
                msgQueue.addMessage(wsilPerspective.getMessage("MSG_ERROR_INVALID_WSIL_URL", wsilURL));
            }
            catch (Throwable t) {
                msgQueue.addMessage(t.getMessage());
            }
            return false;
        }
        this.preselectWSILNode(nodeManager, rootNode.getChildNode(wsilElement).getNodeId(), inspectionType);
        msgQueue.addMessage(wsilPerspective.getMessage("MSG_ERROR_WSIL_ALREADY_OPENED", wsilURL));
        return true;
    }

    private boolean openHTML(List wsils, int inspectionType) {
        int nodeId = -1;
        WSILPerspective wsilPerspective = this.controller_.getWSILPerspective();
        MessageQueue msgQueue = wsilPerspective.getMessageQueue();
        NodeManager nodeManager = wsilPerspective.getNodeManager();
        Node rootNode = nodeManager.getRootNode();
        TreeElement root = rootNode.getTreeElement();
        for (WebServiceEntity wsilEntity : wsils) {
            String wsilURL = wsilEntity.getURI();
            WsilElement wsilElement = this.getOpenedWSIL(root, wsilURL);
            if (wsilElement == null) {
                try {
                    WSILDocument wsilDoc = WSILDocument.newInstance();
                    wsilDoc.read(wsilURL);
                    wsilElement = new WsilElement(wsilURL, root.getModel(), wsilDoc, wsilURL);
                    root.connect((Element)wsilElement, "relWSIL", "owner");
                    nodeId = rootNode.getChildNode(wsilElement).getNodeId();
                    msgQueue.addMessage(wsilPerspective.getMessage("MSG_INFO_OPEN_WSIL_SUCCESSFUL", wsilURL));
                }
                catch (Throwable t) {
                    msgQueue.addMessage(t.getMessage());
                }
                continue;
            }
            msgQueue.addMessage(wsilPerspective.getMessage("MSG_ERROR_WSIL_ALREADY_OPENED", wsilURL));
            nodeId = rootNode.getChildNode(wsilElement).getNodeId();
        }
        if (nodeId != -1) {
            this.preselectWSILNode(nodeManager, nodeId, inspectionType);
            return true;
        }
        return false;
    }

    private boolean openWSIL(String wsilURL, WSILDocument wsilDoc, int inspectionType) {
        WSILPerspective wsilPerspective = this.controller_.getWSILPerspective();
        MessageQueue msgQueue = wsilPerspective.getMessageQueue();
        NodeManager nodeManager = wsilPerspective.getNodeManager();
        Node rootNode = nodeManager.getRootNode();
        TreeElement root = rootNode.getTreeElement();
        WsilElement wsilElement = new WsilElement(wsilURL, root.getModel(), wsilDoc, wsilURL);
        root.connect((Element)wsilElement, "relWSIL", "owner");
        int nodeId = rootNode.getChildNode(wsilElement).getNodeId();
        msgQueue.addMessage(wsilPerspective.getMessage("MSG_INFO_OPEN_WSIL_SUCCESSFUL", wsilURL));
        this.preselectWSILNode(nodeManager, nodeId, inspectionType);
        return true;
    }

    private void preselectWSILNode(NodeManager nodeManager, int nodeId, int inspectionType) {
        nodeManager.setSelectedNodeId(nodeId);
        Node selectedNode = nodeManager.getNode(nodeId);
        selectedNode.setViewId(-1);
        ToolManager toolManager = selectedNode.getToolManager();
        toolManager.setSelectedToolId(inspectionType);
        this.addToHistory(1, SelectWSILToolAction.getActionLink(nodeId, inspectionType, -1, -1, true));
    }

    private WsilElement getOpenedWSIL(TreeElement root, String wsilURL) {
        Enumeration e = root.getElements("relWSIL");
        while (e.hasMoreElements()) {
            WsilElement wsilElement = (WsilElement)((Object)e.nextElement());
            if (!wsilElement.getWsilUrl().equals(wsilURL)) continue;
            return wsilElement;
        }
        return null;
    }
}

