/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.j2ee.internal.ejb.archiveoperations;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.jem.workbench.utility.JemProjectUtilities;
import org.eclipse.jst.j2ee.ejb.internal.plugin.EjbPlugin;
import org.eclipse.jst.j2ee.internal.common.operations.JARDependencyDataModelProvider;
import org.eclipse.jst.j2ee.internal.common.operations.JARDependencyOperation;
import org.eclipse.wst.common.componentcore.ComponentCore;
import org.eclipse.wst.common.componentcore.resources.IVirtualComponent;
import org.eclipse.wst.common.componentcore.resources.IVirtualReference;
import org.eclipse.wst.common.frameworks.datamodel.AbstractDataModelOperation;
import org.eclipse.wst.common.frameworks.datamodel.DataModelFactory;
import org.eclipse.wst.common.frameworks.datamodel.IDataModel;
import org.eclipse.wst.common.frameworks.datamodel.IDataModelProvider;

public class InvertClientJARDependencyCompoundOperation
extends AbstractDataModelOperation {
    protected IProject[] earProjects;
    protected IProject oldProject;
    protected IProject newProject;
    protected List childOperations = null;
    protected IProgressMonitor monitor;

    public InvertClientJARDependencyCompoundOperation(IProject[] referencingEARs, IProject anOldProject, IProject aNewProject) {
        this.earProjects = referencingEARs;
        this.oldProject = anOldProject;
        this.newProject = aNewProject;
    }

    public IStatus execute(IProgressMonitor aMonitor, IAdaptable info) throws ExecutionException {
        this.monitor = aMonitor;
        this.createChildOperations();
        this.executeChildOperations();
        return OK_STATUS;
    }

    private void createChildOperations() {
        this.childOperations = new ArrayList();
        int i = 0;
        while (i < this.earProjects.length) {
            IVirtualComponent earComponent = ComponentCore.createComponent((IProject)this.earProjects[i]);
            IVirtualReference[] refs = earComponent.getReferences();
            int j = 0;
            while (j < refs.length) {
                IProject project;
                IVirtualReference ref = refs[j];
                IVirtualComponent comp = ref.getReferencedComponent();
                if (!(comp == null || (project = comp.getProject()) == null || project.equals((Object)this.oldProject) || project.equals((Object)this.newProject) || JemProjectUtilities.isBinaryProject((IProject)project) || comp.isBinary())) {
                    IDataModel model = DataModelFactory.createDataModel((IDataModelProvider)new JARDependencyDataModelProvider());
                    model.setIntProperty("AbstractJARDependencyDataModel.JAR_MANIPULATION_TYPE", 2);
                    model.setProperty("UpdateManifestDataModel.PROJECT_NAME", (Object)project.getName());
                    model.setProperty("AbstractJARDependencyDataModel.OPPOSITE_PROJECT_NAME", (Object)this.newProject.getName());
                    model.setProperty("AbstractJARDependencyDataModel.EAR_PROJECT_NAME", (Object)this.earProjects[i].getName());
                    model.setProperty("AbstractJARDependencyDataModel.REFERENCED_PROJECT_NAME", (Object)this.oldProject.getName());
                    this.childOperations.add(new JARDependencyOperation(model));
                }
                ++j;
            }
            ++i;
        }
    }

    private void executeChildOperations() {
        this.monitor.beginTask("", this.childOperations.size());
        int i = 0;
        while (i < this.childOperations.size()) {
            JARDependencyOperation op = (JARDependencyOperation)this.childOperations.get(i);
            try {
                op.execute((IProgressMonitor)new SubProgressMonitor(this.monitor, 1), null);
            }
            catch (Exception e) {
                EjbPlugin.logError(e);
            }
            ++i;
        }
    }
}

