/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.ui.internal.platform.base;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jpt.core.JpaFile;
import org.eclipse.jpt.core.JpaProject;
import org.eclipse.jpt.core.JpaStructureNode;
import org.eclipse.jpt.core.ResourceModel;
import org.eclipse.jpt.core.context.AttributeMapping;
import org.eclipse.jpt.core.context.TypeMapping;
import org.eclipse.jpt.core.context.java.JavaJpaContextNode;
import org.eclipse.jpt.core.resource.java.JavaResourceModel;
import org.eclipse.jpt.core.resource.orm.OrmResourceModel;
import org.eclipse.jpt.core.resource.persistence.PersistenceResourceModel;
import org.eclipse.jpt.ui.JpaPlatformUi;
import org.eclipse.jpt.ui.JpaUiFactory;
import org.eclipse.jpt.ui.details.AttributeMappingUiProvider;
import org.eclipse.jpt.ui.details.JpaDetailsProvider;
import org.eclipse.jpt.ui.details.TypeMappingUiProvider;
import org.eclipse.jpt.ui.internal.details.BasicMappingUiProvider;
import org.eclipse.jpt.ui.internal.details.EmbeddableUiProvider;
import org.eclipse.jpt.ui.internal.details.EmbeddedIdMappingUiProvider;
import org.eclipse.jpt.ui.internal.details.EmbeddedMappingUiProvider;
import org.eclipse.jpt.ui.internal.details.IdMappingUiProvider;
import org.eclipse.jpt.ui.internal.details.ManyToManyMappingUiProvider;
import org.eclipse.jpt.ui.internal.details.ManyToOneMappingUiProvider;
import org.eclipse.jpt.ui.internal.details.MappedSuperclassUiProvider;
import org.eclipse.jpt.ui.internal.details.OneToManyMappingUiProvider;
import org.eclipse.jpt.ui.internal.details.OneToOneMappingUiProvider;
import org.eclipse.jpt.ui.internal.details.TransientMappingUiProvider;
import org.eclipse.jpt.ui.internal.details.VersionMappingUiProvider;
import org.eclipse.jpt.ui.internal.java.details.DefaultBasicMappingUiProvider;
import org.eclipse.jpt.ui.internal.java.details.DefaultEmbeddedMappingUiProvider;
import org.eclipse.jpt.ui.internal.java.details.JavaDetailsProvider;
import org.eclipse.jpt.ui.internal.java.details.JavaEntityUiProvider;
import org.eclipse.jpt.ui.internal.java.details.NullAttributeMappingUiProvider;
import org.eclipse.jpt.ui.internal.java.details.NullTypeMappingUiProvider;
import org.eclipse.jpt.ui.internal.orm.details.OrmDetailsProvider;
import org.eclipse.jpt.ui.internal.orm.details.OrmEntityUiProvider;
import org.eclipse.jpt.ui.internal.platform.base.EntitiesGenerator;
import org.eclipse.jpt.ui.internal.structure.JavaResourceModelStructureProvider;
import org.eclipse.jpt.ui.internal.structure.OrmResourceModelStructureProvider;
import org.eclipse.jpt.ui.internal.structure.PersistenceResourceModelStructureProvider;
import org.eclipse.jpt.ui.structure.JpaStructureProvider;
import org.eclipse.jpt.utility.internal.iterators.CloneIterator;
import org.eclipse.jpt.utility.internal.iterators.CloneListIterator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class BaseJpaPlatformUi
implements JpaPlatformUi {
    private List<JpaDetailsProvider> detailsProviders;
    private List<TypeMappingUiProvider<? extends TypeMapping>> javaTypeMappingUiProviders;
    private List<AttributeMappingUiProvider<? extends AttributeMapping>> javaAttributeMappingUiProviders;
    private List<AttributeMappingUiProvider<? extends AttributeMapping>> defaultJavaAttributeMappingUiProviders;
    private List<TypeMappingUiProvider<? extends TypeMapping>> ormTypeMappingUiProviders;
    private List<AttributeMappingUiProvider<? extends AttributeMapping>> ormAttributeMappingUiProviders;
    private List<AttributeMappingUiProvider<? extends AttributeMapping>> defaultOrmAttributeMappingUiProviders;
    private JpaUiFactory jpaUiFactory = this.createJpaUiFactory();

    protected BaseJpaPlatformUi() {
    }

    @Override
    public JpaStructureProvider buildStructureProvider(JpaFile jpaFile) {
        ResourceModel resourceModel = jpaFile.getResourceModel();
        String resourceType = resourceModel.getResourceType();
        if (resourceType == "JAVA_RESOURCE_TYPE") {
            return new JavaResourceModelStructureProvider((JavaResourceModel)resourceModel);
        }
        if (resourceType == "ORM_RESOURCE_TYPE") {
            return new OrmResourceModelStructureProvider((OrmResourceModel)resourceModel);
        }
        if (resourceType == "PERSISTENCE_RESOURCE_TYPE") {
            return new PersistenceResourceModelStructureProvider((PersistenceResourceModel)resourceModel);
        }
        return null;
    }

    protected abstract JpaUiFactory createJpaUiFactory();

    @Override
    public JpaUiFactory getJpaUiFactory() {
        return this.jpaUiFactory;
    }

    public Iterator<JpaDetailsProvider> detailsProviders() {
        if (this.detailsProviders == null) {
            this.detailsProviders = new ArrayList<JpaDetailsProvider>();
            this.addDetailsProvidersTo(this.detailsProviders);
        }
        return new CloneIterator(this.detailsProviders);
    }

    protected void addDetailsProvidersTo(Collection<JpaDetailsProvider> providers) {
        providers.add(new JavaDetailsProvider());
        providers.add(new OrmDetailsProvider());
    }

    @Override
    public JpaDetailsProvider detailsProvider(JpaStructureNode structureNode) {
        this.detailsProviders();
        if (structureNode instanceof JavaJpaContextNode) {
            return this.detailsProviders.get(0);
        }
        return this.detailsProviders.get(1);
    }

    public ListIterator<TypeMappingUiProvider<? extends TypeMapping>> javaTypeMappingUiProviders() {
        if (this.javaTypeMappingUiProviders == null) {
            this.javaTypeMappingUiProviders = new ArrayList<TypeMappingUiProvider<? extends TypeMapping>>();
            this.addJavaTypeMappingUiProvidersTo(this.javaTypeMappingUiProviders);
        }
        return new CloneListIterator(this.javaTypeMappingUiProviders);
    }

    protected void addJavaTypeMappingUiProvidersTo(List<TypeMappingUiProvider<? extends TypeMapping>> providers) {
        providers.add(NullTypeMappingUiProvider.instance());
        providers.add(JavaEntityUiProvider.instance());
        providers.add(MappedSuperclassUiProvider.instance());
        providers.add(EmbeddableUiProvider.instance());
    }

    public ListIterator<AttributeMappingUiProvider<? extends AttributeMapping>> javaAttributeMappingUiProviders() {
        if (this.javaAttributeMappingUiProviders == null) {
            this.javaAttributeMappingUiProviders = new ArrayList<AttributeMappingUiProvider<? extends AttributeMapping>>();
            this.addJavaAttributeMappingUiProvidersTo(this.javaAttributeMappingUiProviders);
        }
        return new CloneListIterator(this.javaAttributeMappingUiProviders);
    }

    protected void addJavaAttributeMappingUiProvidersTo(List<AttributeMappingUiProvider<? extends AttributeMapping>> providers) {
        providers.add(BasicMappingUiProvider.instance());
        providers.add(EmbeddedMappingUiProvider.instance());
        providers.add(EmbeddedIdMappingUiProvider.instance());
        providers.add(IdMappingUiProvider.instance());
        providers.add(ManyToManyMappingUiProvider.instance());
        providers.add(ManyToOneMappingUiProvider.instance());
        providers.add(NullAttributeMappingUiProvider.instance());
        providers.add(OneToManyMappingUiProvider.instance());
        providers.add(OneToOneMappingUiProvider.instance());
        providers.add(TransientMappingUiProvider.instance());
        providers.add(VersionMappingUiProvider.instance());
    }

    public ListIterator<AttributeMappingUiProvider<? extends AttributeMapping>> defaultJavaAttributeMappingUiProviders() {
        if (this.defaultJavaAttributeMappingUiProviders == null) {
            this.defaultJavaAttributeMappingUiProviders = new ArrayList<AttributeMappingUiProvider<? extends AttributeMapping>>();
            this.addDefaultJavaAttributeMappingUiProvidersTo(this.defaultJavaAttributeMappingUiProviders);
        }
        return new CloneListIterator(this.defaultJavaAttributeMappingUiProviders);
    }

    protected void addDefaultJavaAttributeMappingUiProvidersTo(List<AttributeMappingUiProvider<? extends AttributeMapping>> providers) {
        providers.add(DefaultBasicMappingUiProvider.instance());
        providers.add(DefaultEmbeddedMappingUiProvider.instance());
    }

    @Override
    public void generateEntities(JpaProject project, IStructuredSelection selection) {
        EntitiesGenerator.generate(project, selection);
    }

    @Override
    public Iterator<AttributeMappingUiProvider<? extends AttributeMapping>> defaultOrmAttributeMappingUiProviders() {
        if (this.defaultOrmAttributeMappingUiProviders == null) {
            this.defaultOrmAttributeMappingUiProviders = new ArrayList<AttributeMappingUiProvider<? extends AttributeMapping>>();
            this.addDefaultOrmAttributeMappingUiProvidersTo(this.defaultOrmAttributeMappingUiProviders);
        }
        return new CloneListIterator(this.defaultOrmAttributeMappingUiProviders);
    }

    protected void addDefaultOrmAttributeMappingUiProvidersTo(List<AttributeMappingUiProvider<? extends AttributeMapping>> providers) {
    }

    @Override
    public Iterator<AttributeMappingUiProvider<? extends AttributeMapping>> ormAttributeMappingUiProviders() {
        if (this.ormAttributeMappingUiProviders == null) {
            this.ormAttributeMappingUiProviders = new ArrayList<AttributeMappingUiProvider<? extends AttributeMapping>>();
            this.addOrmAttributeMappingUiProvidersTo(this.ormAttributeMappingUiProviders);
        }
        return new CloneListIterator(this.ormAttributeMappingUiProviders);
    }

    protected void addOrmAttributeMappingUiProvidersTo(List<AttributeMappingUiProvider<? extends AttributeMapping>> providers) {
        providers.add(BasicMappingUiProvider.instance());
        providers.add(EmbeddedMappingUiProvider.instance());
        providers.add(EmbeddedIdMappingUiProvider.instance());
        providers.add(IdMappingUiProvider.instance());
        providers.add(ManyToManyMappingUiProvider.instance());
        providers.add(ManyToOneMappingUiProvider.instance());
        providers.add(OneToManyMappingUiProvider.instance());
        providers.add(OneToOneMappingUiProvider.instance());
        providers.add(TransientMappingUiProvider.instance());
        providers.add(VersionMappingUiProvider.instance());
    }

    @Override
    public Iterator<TypeMappingUiProvider<? extends TypeMapping>> ormTypeMappingUiProviders() {
        if (this.ormTypeMappingUiProviders == null) {
            this.ormTypeMappingUiProviders = new ArrayList<TypeMappingUiProvider<? extends TypeMapping>>();
            this.addOrmTypeMappingUiProvidersTo(this.ormTypeMappingUiProviders);
        }
        return new CloneListIterator(this.ormTypeMappingUiProviders);
    }

    protected void addOrmTypeMappingUiProvidersTo(List<TypeMappingUiProvider<? extends TypeMapping>> providers) {
        providers.add(OrmEntityUiProvider.instance());
        providers.add(MappedSuperclassUiProvider.instance());
        providers.add(EmbeddableUiProvider.instance());
    }
}

