/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.jsp.ui.internal.autoedit;

import org.eclipse.core.runtime.Preferences;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.ConfigurableLineTracker;
import org.eclipse.jface.text.DocumentCommand;
import org.eclipse.jface.text.IAutoEditStrategy;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.ILineTracker;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.TextUtilities;
import org.eclipse.jst.jsp.ui.internal.Logger;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.texteditor.ITextEditor;
import org.eclipse.ui.texteditor.ITextEditorExtension3;
import org.eclipse.wst.html.core.internal.HTMLCorePlugin;

public class AutoEditStrategyForTabs
implements IAutoEditStrategy {
    private final String TAB_CHARACTER = "\t";
    static /* synthetic */ Class class$0;

    public void customizeDocumentCommand(IDocument document, DocumentCommand command) {
        if (!this.isSmartInsertMode()) {
            return;
        }
        if (command.length == 0 && command.text != null && command.text.length() > 0 && command.text.indexOf("\t") != -1) {
            this.smartInsertForTab(command, document);
        }
    }

    private void smartInsertForTab(DocumentCommand command, IDocument document) {
        int indentationWidth = this.getIndentationWidth();
        if (indentationWidth > -1) {
            String originalText = command.text;
            StringBuffer newText = new StringBuffer(originalText);
            int lineOffset = -1;
            try {
                IRegion lineInfo = document.getLineInformationOfOffset(command.offset);
                lineOffset = command.offset - lineInfo.getOffset();
            }
            catch (BadLocationException e) {
                Logger.log(202, e.getMessage(), e);
            }
            ILineTracker lineTracker = this.getLineTracker(document, originalText);
            int startIndex = 0;
            int index = newText.indexOf("\t");
            while (index != -1) {
                String indent = this.getIndentString(indentationWidth, lineOffset, lineTracker, index);
                newText.replace(index, index + 1, indent);
                if (lineTracker != null) {
                    try {
                        lineTracker.replace(index, 1, indent);
                    }
                    catch (BadLocationException e) {
                        lineTracker.set(newText.toString());
                        Logger.log(202, e.getMessage(), e);
                    }
                }
                startIndex = index + indent.length();
                index = newText.indexOf("\t", startIndex);
            }
            command.text = newText.toString();
        }
    }

    private String getIndentString(int indentationWidth, int lineOffset, ILineTracker lineTracker, int index) {
        int offsetInLine;
        int indentSize;
        block8: {
            indentSize = indentationWidth;
            offsetInLine = -1;
            if (lineTracker != null) {
                try {
                    IRegion lineInfo = lineTracker.getLineInformationOfOffset(index);
                    if (lineInfo.getOffset() == 0 && lineOffset > -1) {
                        offsetInLine = lineOffset + index;
                        break block8;
                    }
                    offsetInLine = index - lineInfo.getOffset();
                }
                catch (BadLocationException e) {
                    Logger.log(202, e.getMessage(), e);
                }
            } else if (lineOffset > -1) {
                offsetInLine = lineOffset + index;
            }
        }
        if (offsetInLine > -1 && indentationWidth > 0) {
            int remainder = offsetInLine % indentationWidth;
            indentSize = indentationWidth - remainder;
        }
        StringBuffer indent = new StringBuffer();
        int i = 0;
        while (i < indentSize) {
            indent.append(' ');
            ++i;
        }
        return indent.toString();
    }

    private ILineTracker getLineTracker(IDocument document, String originalText) {
        ConfigurableLineTracker lineTracker = null;
        int[] delims = TextUtilities.indexOf((String[])document.getLegalLineDelimiters(), (String)originalText, (int)0);
        if (delims[0] != -1 || delims[1] != -1) {
            lineTracker = new ConfigurableLineTracker(document.getLegalLineDelimiters());
            lineTracker.set(originalText);
        }
        return lineTracker;
    }

    private boolean isSmartInsertMode() {
        IEditorPart editor;
        IWorkbenchPage page;
        boolean isSmartInsertMode = false;
        ITextEditor textEditor = null;
        IWorkbenchWindow window = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
        if (window != null && (page = window.getActivePage()) != null && (editor = page.getActiveEditor()) != null) {
            if (editor instanceof ITextEditor) {
                textEditor = (ITextEditor)editor;
            } else {
                Class<?> clazz = class$0;
                if (clazz == null) {
                    try {
                        clazz = class$0 = Class.forName("org.eclipse.ui.texteditor.ITextEditor");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                textEditor = (ITextEditor)editor.getAdapter((Class)clazz);
            }
        }
        if (textEditor instanceof ITextEditorExtension3 && ((ITextEditorExtension3)textEditor).getInsertMode() == ITextEditorExtension3.SMART_INSERT) {
            isSmartInsertMode = true;
        }
        return isSmartInsertMode;
    }

    private int getIndentationWidth() {
        int width = -1;
        Preferences preferences = HTMLCorePlugin.getDefault().getPluginPreferences();
        if ("space".equals(preferences.getString("indentationChar"))) {
            width = preferences.getInt("indentationSize");
        }
        return width;
    }
}

