/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.xml.ui.internal.correction;

import java.util.List;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.DocumentEvent;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.contentassist.ICompletionProposal;
import org.eclipse.jface.text.contentassist.ICompletionProposalExtension2;
import org.eclipse.jface.text.contentassist.IContextInformation;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.text.edits.InsertEdit;
import org.eclipse.text.edits.MultiTextEdit;
import org.eclipse.text.edits.TextEdit;
import org.eclipse.wst.sse.core.internal.provisional.text.IStructuredDocumentRegion;
import org.eclipse.wst.sse.core.internal.provisional.text.ITextRegion;
import org.eclipse.wst.sse.ui.internal.contentassist.ContentAssistUtils;
import org.eclipse.wst.xml.core.internal.contentmodel.CMAttributeDeclaration;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMNode;
import org.eclipse.wst.xml.ui.internal.Logger;
import org.eclipse.wst.xml.ui.internal.XMLUIMessages;
import org.eclipse.wst.xml.ui.internal.editor.XMLEditorPluginImageHelper;

public class InsertRequiredAttrsQuickAssistProposal
implements ICompletionProposal,
ICompletionProposalExtension2 {
    private final List fRequiredAttrs;

    public InsertRequiredAttrsQuickAssistProposal(List requiredAttrs) {
        this.fRequiredAttrs = requiredAttrs;
    }

    public void apply(IDocument document) {
    }

    public void apply(ITextViewer viewer, char trigger, int stateMask, int offset) {
        IDOMNode node = (IDOMNode)ContentAssistUtils.getNodeAt((ITextViewer)viewer, (int)offset);
        IStructuredDocumentRegion startStructuredDocumentRegion = node.getStartStructuredDocumentRegion();
        int index = startStructuredDocumentRegion.getEndOffset();
        ITextRegion lastRegion = startStructuredDocumentRegion.getLastRegion();
        if (lastRegion.getType() == "XML_TAG_CLOSE") {
            lastRegion = startStructuredDocumentRegion.getRegionAtCharacterOffset(--index - 1);
        } else if (lastRegion.getType() == "XML_EMPTY_TAG_CLOSE") {
            lastRegion = startStructuredDocumentRegion.getRegionAtCharacterOffset((index -= 2) - 1);
        }
        MultiTextEdit multiTextEdit = new MultiTextEdit();
        try {
            int i = 0;
            while (i < this.fRequiredAttrs.size()) {
                CMAttributeDeclaration attrDecl = (CMAttributeDeclaration)this.fRequiredAttrs.get(i);
                String requiredAttributeName = attrDecl.getAttrName();
                String defaultValue = attrDecl.getDefaultValue();
                if (defaultValue == null) {
                    defaultValue = "";
                }
                String nameAndDefaultValue = " ";
                if (i == 0 && lastRegion.getLength() > lastRegion.getTextLength()) {
                    nameAndDefaultValue = "";
                }
                nameAndDefaultValue = String.valueOf(nameAndDefaultValue) + requiredAttributeName + "=\"" + defaultValue + "\"";
                multiTextEdit.addChild((TextEdit)new InsertEdit(index, nameAndDefaultValue));
                ++i;
            }
            multiTextEdit.apply(viewer.getDocument());
        }
        catch (BadLocationException e) {
            Logger.log(1, e.getMessage());
        }
    }

    public String getAdditionalProposalInfo() {
        return XMLUIMessages.InsertRequiredAttrsQuickAssistProposal_0;
    }

    public IContextInformation getContextInformation() {
        return null;
    }

    public String getDisplayString() {
        return XMLUIMessages.InsertRequiredAttrsQuickAssistProposal_1;
    }

    public Image getImage() {
        return XMLEditorPluginImageHelper.getInstance().getImage("icons/full/obj16/add_correction.gif");
    }

    public Point getSelection(IDocument document) {
        return null;
    }

    public void selected(ITextViewer viewer, boolean smartToggle) {
    }

    public void unselected(ITextViewer viewer) {
    }

    public boolean validate(IDocument document, int offset, DocumentEvent event) {
        return false;
    }
}

