/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.ws.internal.axis.consumption.ui.task;

import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jst.ws.internal.axis.consumption.core.common.JavaWSDLParameter;
import org.eclipse.jst.ws.internal.consumption.ui.wsil.DialogWWWAuthentication;
import org.eclipse.ui.PlatformUI;
import org.eclipse.wst.common.frameworks.datamodel.AbstractDataModelOperation;
import org.eclipse.wst.ws.internal.parser.discovery.WebServicesParserExt;
import org.eclipse.wst.ws.internal.parser.wsil.WWWAuthenticationException;
import org.eclipse.wst.ws.internal.parser.wsil.WebServiceEntity;
import org.eclipse.wst.ws.internal.parser.wsil.WebServicesParser;

public class DefaultsForHTTPBasicAuthCommand
extends AbstractDataModelOperation {
    private WebServicesParser webServicesParser;
    private String wsdlServiceURL;
    private JavaWSDLParameter javaWSDLParam;

    public IStatus execute(IProgressMonitor monitor, IAdaptable adaptable) {
        if (this.wsdlServiceURL != null && this.wsdlServiceURL.length() > 0) {
            WebServiceEntity wsEntity;
            if (this.webServicesParser == null) {
                this.webServicesParser = new WebServicesParserExt();
            }
            if ((wsEntity = this.webServicesParser.getWebServiceEntityByURI(this.wsdlServiceURL)) == null || !wsEntity.isEntityResolved()) {
                block10: {
                    this.webServicesParser.setURI(this.wsdlServiceURL);
                    try {
                        this.webServicesParser.parse(0);
                    }
                    catch (WWWAuthenticationException wwwae) {
                        DialogWWWAuthentication dialog = new DialogWWWAuthentication(PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell());
                        dialog.handleWWWAuthentication(wwwae);
                        String username = dialog.getUsername();
                        String password = dialog.getPassword();
                        if (username == null || password == null) break block10;
                        this.webServicesParser.setHTTPBasicAuthUsername(username);
                        this.webServicesParser.setHTTPBasicAuthPassword(password);
                        try {
                            this.webServicesParser.parse(0);
                        }
                        catch (Throwable throwable) {}
                        this.webServicesParser.setHTTPBasicAuthUsername(null);
                        this.webServicesParser.setHTTPBasicAuthPassword(null);
                    }
                    catch (Throwable throwable) {}
                }
                wsEntity = this.webServicesParser.getWebServiceEntityByURI(this.wsdlServiceURL);
            }
            if (wsEntity != null && wsEntity.getType() == 2) {
                String httpUsername = wsEntity.getHTTPUsername();
                String httpPassword = wsEntity.getHTTPPassword();
                if (httpUsername != null && httpPassword != null) {
                    this.javaWSDLParam.setHTTPUsername(httpUsername);
                    this.javaWSDLParam.setHTTPPassword(httpPassword);
                }
            }
        }
        return Status.OK_STATUS;
    }

    public void setJavaWSDLParam(JavaWSDLParameter javaWSDLParam) {
        this.javaWSDLParam = javaWSDLParam;
    }

    public void setWsdlServiceURL(String wsdlServiceURL) {
        this.wsdlServiceURL = wsdlServiceURL;
    }

    public JavaWSDLParameter getJavaWSDLParam() {
        return this.javaWSDLParam;
    }

    public WebServicesParser getWebServicesParser() {
        return this.webServicesParser;
    }

    public void setWebServicesParser(WebServicesParser webServicesParser) {
        this.webServicesParser = webServicesParser;
    }
}

