/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.j2ee.internal.ejb.workbench.validation;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.jst.j2ee.ejb.componentcore.util.EJBArtifactEdit;
import org.eclipse.jst.j2ee.internal.project.J2EEProjectUtilities;
import org.eclipse.jst.j2ee.model.internal.validation.EJBValidator;
import org.eclipse.wst.common.componentcore.ComponentCore;
import org.eclipse.wst.common.componentcore.resources.IVirtualComponent;
import org.eclipse.wst.common.componentcore.resources.IVirtualFile;
import org.eclipse.wst.validation.internal.core.ValidationException;
import org.eclipse.wst.validation.internal.operations.IWorkbenchContext;
import org.eclipse.wst.validation.internal.provisional.core.IReporter;
import org.eclipse.wst.validation.internal.provisional.core.IValidationContext;
import org.eclipse.wst.validation.internal.provisional.core.IValidatorJob;

public class UIEjbValidator
extends EJBValidator {
    public IStatus validateInJob(IValidationContext inHelper, IReporter inReporter) throws ValidationException {
        IProject proj = ((IWorkbenchContext)inHelper).getProject();
        if (J2EEProjectUtilities.isEJBProject((IProject)proj)) {
            EJBArtifactEdit edit = null;
            try {
                edit = EJBArtifactEdit.getEJBArtifactEditForRead(proj);
                if (edit != null && edit.getDeploymentDescriptorResource() != null) {
                    IStatus iStatus = super.validateInJob(inHelper, inReporter);
                    return iStatus;
                }
            }
            finally {
                if (edit != null) {
                    edit.dispose();
                }
            }
        }
        return IValidatorJob.OK_STATUS;
    }

    public ISchedulingRule getSchedulingRule(IValidationContext helper) {
        IVirtualFile vf;
        IProject project = ((IWorkbenchContext)helper).getProject();
        IVirtualComponent comp = ComponentCore.createComponent((IProject)project);
        IFile ejbJarFile = null;
        if (comp != null && (vf = comp.getRootFolder().getFile((IPath)new Path("META-INF/ejb-jar.xml"))) != null) {
            ejbJarFile = vf.getUnderlyingFile();
        }
        return ejbJarFile;
    }
}

