/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.ui.internal.mappings.details;

import java.text.Collator;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.eclipse.jpt.core.context.ColumnMapping;
import org.eclipse.jpt.core.context.TemporalType;
import org.eclipse.jpt.ui.internal.JptUiMessages;
import org.eclipse.jpt.ui.internal.mappings.JptUiMappingsMessages;
import org.eclipse.jpt.ui.internal.util.SWTUtil;
import org.eclipse.jpt.ui.internal.widgets.AbstractFormPane;
import org.eclipse.jpt.utility.internal.CollectionTools;
import org.eclipse.jpt.utility.internal.StringConverter;
import org.eclipse.jpt.utility.internal.model.value.ExtendedListValueModelWrapper;
import org.eclipse.jpt.utility.internal.model.value.PropertyAspectAdapter;
import org.eclipse.jpt.utility.internal.model.value.SimpleListValueModel;
import org.eclipse.jpt.utility.model.value.ListValueModel;
import org.eclipse.jpt.utility.model.value.WritablePropertyValueModel;
import org.eclipse.swt.widgets.Composite;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TemporalTypeComposite
extends AbstractFormPane<ColumnMapping> {
    public TemporalTypeComposite(AbstractFormPane<? extends ColumnMapping> parentPane, Composite parent) {
        super(parentPane, parent);
    }

    private ListValueModel<TemporalType> buildSortedTemporalTypeListHolder() {
        List types = CollectionTools.list((Object[])TemporalType.values());
        Collections.sort(types, this.buildTemporalTypeComparator());
        return new SimpleListValueModel(types);
    }

    private Comparator<TemporalType> buildTemporalTypeComparator() {
        return new Comparator<TemporalType>(){

            @Override
            public int compare(TemporalType type1, TemporalType type2) {
                String displayString1 = TemporalTypeComposite.this.displayString(type1);
                String displayString2 = TemporalTypeComposite.this.displayString(type2);
                return Collator.getInstance().compare(displayString1, displayString2);
            }
        };
    }

    private StringConverter<TemporalType> buildTemporalTypeConverter() {
        return new StringConverter<TemporalType>(){

            public String convertToString(TemporalType value) {
                if (value == null) {
                    return JptUiMessages.EnumComboViewer_default;
                }
                return TemporalTypeComposite.this.displayString(value);
            }
        };
    }

    private WritablePropertyValueModel<TemporalType> buildTemporalTypeHolder() {
        return new PropertyAspectAdapter<ColumnMapping, TemporalType>(this.getSubjectHolder(), new String[]{"temporalProperty"}){

            protected TemporalType buildValue_() {
                return ((ColumnMapping)this.subject).getTemporal();
            }

            protected void setValue_(TemporalType value) {
                ((ColumnMapping)this.subject).setTemporal(value);
            }
        };
    }

    private ListValueModel<TemporalType> buildTemporalTypeListHolder() {
        return new ExtendedListValueModelWrapper(null, this.buildSortedTemporalTypeListHolder());
    }

    private String displayString(TemporalType temporalType) {
        return SWTUtil.buildDisplayString(JptUiMappingsMessages.class, this, (Object)temporalType.name());
    }

    @Override
    protected void initializeLayout(Composite container) {
        this.buildLabeledCCombo(container, JptUiMappingsMessages.BasicGeneralSection_temporalLabel, this.buildTemporalTypeListHolder(), this.buildTemporalTypeHolder(), this.buildTemporalTypeConverter(), "org.eclipse.jpt.ui.mapping_temporal");
    }
}

