/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.validation.internal;

import java.lang.reflect.InvocationTargetException;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArraySet;
import java.util.concurrent.atomic.AtomicReference;
import org.eclipse.wst.validation.Friend;
import org.eclipse.wst.validation.MessageSeveritySetting;
import org.eclipse.wst.validation.Validator;
import org.eclipse.wst.validation.internal.ConfigurationManager;
import org.eclipse.wst.validation.internal.Deserializer;
import org.eclipse.wst.validation.internal.ExtensionValidators;
import org.eclipse.wst.validation.internal.GlobalConfiguration;
import org.eclipse.wst.validation.internal.IValChangedListener;
import org.eclipse.wst.validation.internal.PreferencesWrapper;
import org.eclipse.wst.validation.internal.Serializer;
import org.eclipse.wst.validation.internal.ValManager;
import org.eclipse.wst.validation.internal.ValidatorMetaData;
import org.eclipse.wst.validation.internal.ValidatorMutable;
import org.eclipse.wst.validation.internal.model.FilterGroup;
import org.eclipse.wst.validation.internal.model.GlobalPreferences;
import org.eclipse.wst.validation.internal.model.GlobalPreferencesValues;
import org.eclipse.wst.validation.internal.plugin.ValidationPlugin;
import org.osgi.service.prefs.BackingStoreException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ValPrefManagerGlobal {
    public static final int frameworkVersion = 3;
    private final Set<IValChangedListener> _listeners = new CopyOnWriteArraySet<IValChangedListener>();
    private final AtomicReference<List<Validator>> _validators = new AtomicReference();

    private ValPrefManagerGlobal() {
    }

    public static ValPrefManagerGlobal getDefault() {
        return Singleton.valPrefManagerGlobal;
    }

    public void addListener(IValChangedListener listener) {
        this._listeners.add(listener);
    }

    public void removeListener(IValChangedListener listener) {
        this._listeners.remove(listener);
    }

    private void updateListeners(boolean validationSettingChanged) {
        for (IValChangedListener cl : this._listeners) {
            cl.validatorsForProjectChanged(null, validationSettingChanged);
        }
    }

    public List<Validator> getValidators() throws BackingStoreException {
        List<Validator> vals = this._validators.get();
        while (vals == null) {
            vals = this.loadValidators();
            if (this._validators.compareAndSet(null, vals)) continue;
            vals = this._validators.get();
        }
        return vals;
    }

    private List<Validator> loadValidators() throws BackingStoreException {
        LinkedList<Validator> list = new LinkedList<Validator>();
        PreferencesWrapper pref = PreferencesWrapper.getPreferences(null, null);
        if (pref.nodeExists("vals")) {
            PreferencesWrapper vals = pref.node("vals");
            String[] stringArray = vals.childrenNames();
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                String id = stringArray[n2];
                Validator base = ExtensionValidators.instance().getMapV2().get(id);
                Validator v = ValPrefManagerGlobal.loadValidator(id, vals, base);
                if (v != null) {
                    Validator.V2 v2 = v.asV2Validator();
                    if (v2 != null) {
                        v2.setLevel(Validator.Level.Global);
                    }
                    list.add(v);
                }
                ++n2;
            }
        }
        return list;
    }

    static Validator loadValidator(String id, PreferencesWrapper valsNode, Validator base) {
        if (base == null) {
            return null;
        }
        PreferencesWrapper vp = valsNode.node(id);
        base = base.copy();
        Validator.V2 v2 = base.asV2Validator();
        String global = vp.get("global", "");
        if (global.length() > 0) {
            Global g = new Global(global);
            base.setBuildValidation(g.isBuild());
            base.setManualValidation(g.isManual());
            base.setDelegatingId(g.getDelegating());
        }
        if (v2 != null) {
            String settings;
            String groups = vp.get("groups", "");
            if (groups.length() > 0) {
                LinkedList<FilterGroup> list = new LinkedList<FilterGroup>();
                Deserializer des = new Deserializer(groups);
                while (des.hasNext()) {
                    list.add(FilterGroup.create(des));
                }
                v2.setGroups(list);
            }
            if ((settings = vp.get("msgs", "")).length() > 0) {
                Map<String, MessageSeveritySetting.Severity> map = Msgs.deserialize(settings);
                Map<String, MessageSeveritySetting> msg = base.getMessageSettings();
                for (Map.Entry<String, MessageSeveritySetting.Severity> me : map.entrySet()) {
                    MessageSeveritySetting ms = msg.get(me.getKey());
                    if (ms == null) continue;
                    ms.setCurrent(me.getValue());
                }
            }
        }
        return base;
    }

    public GlobalPreferences loadGlobalPreferences() {
        PreferencesWrapper pref = PreferencesWrapper.getPreferences(null, null);
        GlobalPreferencesValues gp = new GlobalPreferencesValues();
        gp.saveAutomatically = pref.getBoolean("saveAuto", false);
        gp.disableAllValidation = pref.getBoolean("suspend", false);
        gp.confirmDialog = pref.getBoolean("confirmDialog", true);
        gp.override = pref.getBoolean("override", true);
        gp.version = pref.getInt("vf.version", 2);
        gp.stateTimeStamp = pref.getLong("stateTS", 0L);
        if (gp.version != 3) {
            ValPrefManagerGlobal.migrate(gp.version, pref);
        }
        return new GlobalPreferences(gp);
    }

    static void migrate(int version, PreferencesWrapper pref) {
        try {
            boolean update = false;
            if (version == 2) {
                if (pref.nodeExists("filters")) {
                    pref.node("filters").removeNode();
                    update = true;
                }
                if (pref.nodeExists("msgs")) {
                    pref.node("msgs").removeNode();
                    update = true;
                }
            }
            if (update) {
                pref.putInt("vf.version", 3);
                pref.flush();
            }
        }
        catch (BackingStoreException e) {
            ValidationPlugin.getPlugin().handleException(e);
        }
    }

    static void save(Validator validator, PreferencesWrapper root, Map<String, Validator> baseValidators) throws BackingStoreException {
        FilterGroup[] groups;
        Collection<MessageSeveritySetting> msgs;
        Validator.V2 v2 = validator.asV2Validator();
        if (v2 == null) {
            return;
        }
        String id = validator.getId();
        boolean hasNode = root.nodeExists(id);
        if (validator.sameConfig(baseValidators.get(id))) {
            if (hasNode) {
                PreferencesWrapper vp = root.node(id);
                vp.removeNode();
            }
            return;
        }
        if (!validator.isChanged()) {
            return;
        }
        PreferencesWrapper vp = root.node(id);
        if (validator.hasGlobalChanges()) {
            Global g = new Global(validator.isManualValidation(), validator.isBuildValidation(), validator.getVersion(), validator.getDelegatingId());
            vp.put("global", g.serialize());
            Friend.setMigrated(validator, false);
        }
        if (validator.getChangeCountMessages() > 0 && (msgs = validator.getMessageSettings().values()).size() > 0) {
            vp.put("msgs", Msgs.serialize(msgs));
        }
        if (v2.getChangeCountGroups() > 0 && (groups = v2.getGroups()).length > 0) {
            Serializer ser = new Serializer(500);
            FilterGroup[] filterGroupArray = groups;
            int n = groups.length;
            int n2 = 0;
            while (n2 < n) {
                FilterGroup group = filterGroupArray[n2];
                group.save(ser);
                ++n2;
            }
            vp.put("groups", ser.toString());
        }
    }

    static void save(ValidatorMutable validator, PreferencesWrapper root, Map<String, Validator> baseValidators) throws BackingStoreException {
        Collection<MessageSeveritySetting> msgs;
        FilterGroup[] groups;
        if (!validator.isV2Validator()) {
            return;
        }
        PreferencesWrapper vp = root.node(validator.getId());
        if (validator.sameConfig(baseValidators.get(validator.getId()))) {
            vp.removeNode();
            return;
        }
        if (!validator.isChanged()) {
            return;
        }
        if (validator.hasGlobalChanges()) {
            Global g = new Global(validator.isManualValidation(), validator.isBuildValidation(), validator.getVersion(), validator.getDelegatingId());
            vp.put("global", g.serialize());
        }
        if (validator.getChangeCountGroups() > 0 && (groups = validator.getGroups()).length > 0) {
            Serializer ser = new Serializer(500);
            FilterGroup[] filterGroupArray = groups;
            int n = groups.length;
            int n2 = 0;
            while (n2 < n) {
                FilterGroup group = filterGroupArray[n2];
                group.save(ser);
                ++n2;
            }
            vp.put("groups", ser.toString());
        }
        if (validator.getChangeCountMessages() > 0 && (msgs = validator.getMessageSettings().values()).size() > 0) {
            vp.put("msgs", Msgs.serialize(msgs));
        }
    }

    public void saveAsPrefs(Validator[] val) {
        try {
            PreferencesWrapper pref = PreferencesWrapper.getPreferences(null, null);
            PreferencesWrapper vals = pref.node("vals");
            Map<String, Validator> base = ExtensionValidators.instance().getMapV2();
            Validator[] validatorArray = val;
            int n = val.length;
            int n2 = 0;
            while (n2 < n) {
                Validator v = validatorArray[n2];
                ValPrefManagerGlobal.save(v, vals, base);
                ++n2;
            }
            pref.flush();
            this._validators.set(null);
            this.updateListeners(true);
        }
        catch (BackingStoreException e) {
            throw new RuntimeException(e);
        }
    }

    public synchronized void savePreferences(GlobalPreferences gp, Validator[] validators) {
        try {
            PreferencesWrapper prefs = PreferencesWrapper.getPreferences(null, null);
            this.savePreferences(prefs, gp);
            PreferencesWrapper vals = prefs.node("vals");
            Map<String, Validator> base = ExtensionValidators.instance().getMapV2();
            Validator[] validatorArray = validators;
            int n = validators.length;
            int n2 = 0;
            while (n2 < n) {
                Validator v = validatorArray[n2];
                ValPrefManagerGlobal.save(v, vals, base);
                ++n2;
            }
            prefs.flush();
            this._validators.set(null);
            this.updateListeners(true);
        }
        catch (BackingStoreException e) {
            ValidationPlugin.getPlugin().handleException(e);
        }
    }

    public synchronized void savePreferences(GlobalPreferences gp, ValidatorMutable[] validators, Boolean persist) {
        try {
            PreferencesWrapper prefs = PreferencesWrapper.getPreferences(null, persist);
            this.savePreferences(prefs, gp);
            PreferencesWrapper vals = prefs.node("vals");
            Map<String, Validator> base = ExtensionValidators.instance().getMapV2();
            ValidatorMutable[] validatorMutableArray = validators;
            int n = validators.length;
            int n2 = 0;
            while (n2 < n) {
                ValidatorMutable v = validatorMutableArray[n2];
                ValPrefManagerGlobal.save(v, vals, base);
                ++n2;
            }
            prefs.flush();
            this._validators.set(null);
            this.updateListeners(true);
        }
        catch (BackingStoreException e) {
            ValidationPlugin.getPlugin().handleException(e);
        }
    }

    public static void saveV1Preferences(ValidatorMutable[] validators, Boolean persistent) {
        try {
            GlobalConfiguration gc = ConfigurationManager.getManager().getGlobalConfiguration();
            gc.setEnabledManualValidators(ValPrefManagerGlobal.getEnabledManualValidators(validators));
            gc.setEnabledBuildValidators(ValPrefManagerGlobal.getEnabledBuildValidators(validators));
            gc.passivate();
            gc.store(persistent);
        }
        catch (InvocationTargetException e) {
            ValidationPlugin.getPlugin().handleException(e);
        }
    }

    private static ValidatorMetaData[] getEnabledManualValidators(ValidatorMutable[] validators) {
        LinkedList<ValidatorMetaData> list = new LinkedList<ValidatorMetaData>();
        ValidatorMutable[] validatorMutableArray = validators;
        int n = validators.length;
        int n2 = 0;
        while (n2 < n) {
            ValidatorMutable v = validatorMutableArray[n2];
            if (v.isManualValidation() && v.isV1Validator()) {
                list.add(v.getVmd());
            }
            ++n2;
        }
        ValidatorMetaData[] result = new ValidatorMetaData[list.size()];
        list.toArray(result);
        return result;
    }

    private static ValidatorMetaData[] getEnabledBuildValidators(ValidatorMutable[] validators) {
        LinkedList<ValidatorMetaData> list = new LinkedList<ValidatorMetaData>();
        ValidatorMutable[] validatorMutableArray = validators;
        int n = validators.length;
        int n2 = 0;
        while (n2 < n) {
            ValidatorMutable v = validatorMutableArray[n2];
            if (v.isBuildValidation() && v.isV1Validator()) {
                list.add(v.getVmd());
            }
            ++n2;
        }
        ValidatorMetaData[] result = new ValidatorMetaData[list.size()];
        list.toArray(result);
        return result;
    }

    public synchronized void savePreferences() {
        try {
            GlobalPreferences gp = ValManager.getDefault().getGlobalPreferences();
            PreferencesWrapper prefs = PreferencesWrapper.getPreferences(null, null);
            this.savePreferences(prefs, gp);
            prefs.flush();
            this.updateListeners(true);
        }
        catch (BackingStoreException e) {
            ValidationPlugin.getPlugin().handleException(e);
        }
    }

    private void savePreferences(PreferencesWrapper prefs, GlobalPreferences gp) {
        prefs.putBoolean("saveAuto", gp.getSaveAutomatically());
        prefs.putBoolean("suspend", gp.getDisableAllValidation());
        prefs.putLong("stateTS", gp.getStateTimeStamp());
        prefs.putBoolean("confirmDialog", gp.getConfirmDialog());
        prefs.putBoolean("override", gp.getOverride());
        prefs.putInt("vf.version", 3);
    }

    public void loadMessages(Validator validator, Map<String, MessageSeveritySetting> settings) {
        PreferencesWrapper pref = PreferencesWrapper.getPreferences(null, null);
        try {
            ValPrefManagerGlobal.loadMessageSettings(validator, settings, pref);
        }
        catch (BackingStoreException e) {
            ValidationPlugin.getPlugin().handleException(e);
        }
    }

    static void loadMessageSettings(Validator val, Map<String, MessageSeveritySetting> settings, PreferencesWrapper root) throws BackingStoreException {
        if (!root.nodeExists("vals")) {
            return;
        }
        PreferencesWrapper vals = root.node("vals");
        if (!vals.nodeExists(val.getId())) {
            return;
        }
        PreferencesWrapper valPrefs = vals.node(val.getId());
        String msgs = valPrefs.get("msgs", "");
        if (msgs.length() == 0) {
            return;
        }
        Map<String, MessageSeveritySetting.Severity> map = Msgs.deserialize(msgs);
        for (Map.Entry<String, MessageSeveritySetting.Severity> me : map.entrySet()) {
            MessageSeveritySetting ms = settings.get(me.getKey());
            if (ms == null) continue;
            ms.setCurrent(me.getValue());
        }
    }

    /* synthetic */ ValPrefManagerGlobal(ValPrefManagerGlobal valPrefManagerGlobal) {
        this();
    }

    private static final class Global {
        private final boolean _manual;
        private final boolean _build;
        private final int _version;
        private final String _delegating;

        public Global(String value) {
            Deserializer d = new Deserializer(value);
            this._manual = d.getBoolean();
            this._build = d.getBoolean();
            this._version = d.getInt();
            this._delegating = d.hasNext() ? d.getString() : null;
        }

        public Global(boolean manual, boolean build, int version, String delegating) {
            this._manual = manual;
            this._build = build;
            this._version = version;
            this._delegating = delegating;
        }

        public String serialize() {
            Serializer s = new Serializer(50);
            s.put(this._manual);
            s.put(this._build);
            s.put(this._version);
            if (this._delegating != null) {
                s.put(this._delegating);
            }
            return s.toString();
        }

        public boolean isManual() {
            return this._manual;
        }

        public boolean isBuild() {
            return this._build;
        }

        public int getVersion() {
            return this._version;
        }

        public String getDelegating() {
            return this._delegating;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class Msgs {
        private Msgs() {
        }

        public static String serialize(Collection<MessageSeveritySetting> messages) {
            Serializer s = new Serializer(100);
            for (MessageSeveritySetting ms : messages) {
                s.put(ms.getId());
                s.put(ms.getCurrent().ordinal());
            }
            return s.toString();
        }

        public static Map<String, MessageSeveritySetting.Severity> deserialize(String v) {
            HashMap<String, MessageSeveritySetting.Severity> map = new HashMap<String, MessageSeveritySetting.Severity>(10);
            Deserializer d = new Deserializer(v);
            while (d.hasNext()) {
                String id = d.getString();
                int sev = d.getInt();
                map.put(id, MessageSeveritySetting.Severity.values()[sev]);
            }
            return map;
        }
    }

    private static final class Singleton {
        static final ValPrefManagerGlobal valPrefManagerGlobal = new ValPrefManagerGlobal(null);

        private Singleton() {
        }
    }
}

