/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.jsf.core.internal.jem;

import org.eclipse.jem.internal.proxy.core.IBeanProxy;
import org.eclipse.jem.internal.proxy.core.IBeanTypeProxy;
import org.eclipse.jem.internal.proxy.core.IFieldProxy;
import org.eclipse.jem.internal.proxy.core.IIntegerBeanProxy;
import org.eclipse.jem.internal.proxy.core.IMethodProxy;
import org.eclipse.jem.internal.proxy.core.IStringBeanProxy;
import org.eclipse.jem.internal.proxy.core.ThrowableProxy;

public final class BeanProxyUtil {

    public static class BeanProxyWrapper {
        private static final IBeanProxy[] NO_ARGS = new IBeanProxy[0];
        private static final IBeanTypeProxy[] NO_ARG_TYPES = new IBeanTypeProxy[0];
        private final IBeanTypeProxy _typeProxy;
        private IBeanProxy _instance;

        public BeanProxyWrapper(IBeanTypeProxy typeProxy) {
            this._typeProxy = typeProxy;
        }

        public void init() throws ProxyException {
            if (this._instance == null) {
                try {
                    this._instance = this._typeProxy.newInstance();
                }
                catch (ThrowableProxy e) {
                    throw new ProxyException(e);
                }
                catch (NoClassDefFoundError ndfe) {
                    throw new ProxyException(ndfe);
                }
                catch (ExceptionInInitializerError e) {
                    throw new ProxyException(e);
                }
            }
        }

        public void reinit() throws ProxyException {
            this._instance = null;
            this.init();
        }

        public IBeanProxy getInstance() {
            return this._instance;
        }

        public IBeanProxy call(String methodName, IBeanProxy[] args, IBeanTypeProxy[] argTypes) throws ProxyException {
            try {
                IMethodProxy method;
                IMethodProxy iMethodProxy = method = argTypes.length == 0 ? this._typeProxy.getMethodProxy(methodName) : this._typeProxy.getMethodProxy(methodName, argTypes);
                if (method != null) {
                    return method.invoke(this._instance, args);
                }
            }
            catch (ThrowableProxy tp) {
                throw new ProxyException(tp);
            }
            catch (NoClassDefFoundError ndfe) {
                throw new ProxyException(ndfe);
            }
            return null;
        }

        public IBeanProxy call(String methodName) throws ProxyException {
            return this.call(methodName, NO_ARGS, NO_ARG_TYPES);
        }

        public String callStringMethod(String methodName) throws ProxyException {
            IBeanProxy result = this.call(methodName);
            if (result instanceof IStringBeanProxy) {
                return ((IStringBeanProxy)result).stringValue();
            }
            return null;
        }

        public Integer callIntMethod(String methodName) throws ProxyException {
            IBeanProxy result = this.call(methodName, NO_ARGS, NO_ARG_TYPES);
            if (result instanceof IIntegerBeanProxy) {
                return ((IIntegerBeanProxy)result).intValue();
            }
            return null;
        }

        public String getStringFieldValue(String fieldName) throws ProxyException {
            return this.getStringFieldValue(fieldName, this._typeProxy);
        }

        public String getStringFieldValue(String fieldName, IBeanTypeProxy typeProxy) throws ProxyException {
            IBeanProxy value = this.getFieldValue(fieldName, typeProxy);
            if (value instanceof IStringBeanProxy) {
                return ((IStringBeanProxy)value).stringValue();
            }
            return null;
        }

        public IBeanProxy getFieldValue(String fieldName, IBeanTypeProxy typeProxy) throws ProxyException {
            try {
                IFieldProxy fieldProxy = typeProxy.getDeclaredFieldProxy(fieldName);
                if (fieldProxy != null) {
                    fieldProxy.setAccessible(true);
                    return fieldProxy.get(this._instance);
                }
            }
            catch (ThrowableProxy e) {
                throw new ProxyException(e);
            }
            catch (NoClassDefFoundError ndfe) {
                throw new ProxyException(ndfe);
            }
            return null;
        }

        public IBeanProxy getFieldValueIncludeParents(String fieldName, IBeanTypeProxy typeProxy) throws ProxyException {
            IBeanTypeProxy curType = typeProxy;
            while (curType != null) {
                IBeanProxy field = this.getFieldValue(fieldName, curType);
                if (field != null) {
                    return field;
                }
                try {
                    curType = curType.getSuperBeanTypeProxy();
                }
                catch (NullPointerException nullPointerException) {
                    curType = null;
                }
            }
            return null;
        }

        public final IBeanProxy getBeanProxy() {
            return this._instance;
        }
    }

    public static class ProxyException
    extends Exception {
        private static final long serialVersionUID = -1526057761795574331L;

        public ProxyException(String message, Throwable cause) {
            super(message, cause);
        }

        public ProxyException(Throwable cause) {
            super(cause);
        }
    }
}

