/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.server.core.model;

import java.util.ArrayList;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.wst.server.core.IModule;
import org.eclipse.wst.server.core.internal.Module;
import org.eclipse.wst.server.core.internal.ModuleFactory;
import org.eclipse.wst.server.core.model.ModuleDelegate;

public abstract class ModuleFactoryDelegate {
    private ModuleFactory factory;

    final void initialize(ModuleFactory newFactory, IProgressMonitor monitor) {
        this.factory = newFactory;
        this.initialize();
    }

    public void initialize() {
    }

    protected final String getId() {
        return this.factory.getId();
    }

    public void clearModuleCache() {
    }

    protected final IModule createModule(String id, String name, String type, String version, IProject project) {
        return new Module(this.factory, id, name, type, version, project);
    }

    public abstract ModuleDelegate getModuleDelegate(IModule var1);

    public abstract IModule[] getModules();

    public IModule[] getModules(IProject project) {
        IModule[] modules = this.getModules();
        if (project != null && modules != null) {
            ArrayList<IModule> list = new ArrayList<IModule>(modules.length);
            int size = modules.length;
            int i = 0;
            while (i < size) {
                if (project.equals((Object)modules[i].getProject())) {
                    list.add(modules[i]);
                }
                ++i;
            }
            IModule[] m = new IModule[list.size()];
            list.toArray(m);
            return m;
        }
        return new IModule[0];
    }

    public IModule findModule(String id) {
        if (id == null) {
            return null;
        }
        IModule[] modules = this.getModules();
        if (modules != null) {
            int size = modules.length;
            int i = 0;
            while (i < size) {
                String id2 = modules[i].getId();
                int index = id2.indexOf(":");
                if (index >= 0) {
                    id2 = id2.substring(index + 1);
                }
                if (id.equals(id2)) {
                    return modules[i];
                }
                ++i;
            }
        }
        return null;
    }
}

