/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.ui.actions;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.commands.IHandler;
import org.eclipse.core.runtime.Assert;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.commands.ActionHandler;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IWorkbenchSite;
import org.eclipse.ui.actions.ActionGroup;
import org.eclipse.ui.actions.AddBookmarkAction;
import org.eclipse.ui.handlers.IHandlerActivation;
import org.eclipse.ui.handlers.IHandlerService;
import org.eclipse.ui.ide.IDEActionFactory;
import org.eclipse.ui.part.Page;
import org.eclipse.ui.texteditor.IUpdate;
import org.eclipse.wst.jsdt.internal.ui.actions.ActionMessages;
import org.eclipse.wst.jsdt.internal.ui.actions.AddTaskAction;
import org.eclipse.wst.jsdt.internal.ui.actions.AllCleanUpsAction;
import org.eclipse.wst.jsdt.internal.ui.actions.FindBrokenNLSKeysAction;
import org.eclipse.wst.jsdt.internal.ui.actions.JDTQuickMenuAction;
import org.eclipse.wst.jsdt.internal.ui.actions.MultiSortMembersAction;
import org.eclipse.wst.jsdt.internal.ui.javaeditor.CompilationUnitEditor;
import org.eclipse.wst.jsdt.ui.actions.AddDelegateMethodsAction;
import org.eclipse.wst.jsdt.ui.actions.AddGetterSetterAction;
import org.eclipse.wst.jsdt.ui.actions.AddJavaDocStubAction;
import org.eclipse.wst.jsdt.ui.actions.ExternalizeStringsAction;
import org.eclipse.wst.jsdt.ui.actions.FormatAllAction;
import org.eclipse.wst.jsdt.ui.actions.GenerateNewConstructorUsingFieldsAction;
import org.eclipse.wst.jsdt.ui.actions.OverrideMethodsAction;

public class GenerateActionGroup
extends ActionGroup {
    public static final String MENU_ID = "org.eclipse.wst.jsdt.ui.source.menu";
    public static final String GROUP_IMPORT = "importGroup";
    public static final String GROUP_GENERATE = "generateGroup";
    public static final String GROUP_CODE = "codeGroup";
    private static final String GROUP_EXTERNALIZE = "externalizeGroup";
    private static final String GROUP_COMMENT = "commentGroup";
    private static final String GROUP_EDIT = "editGroup";
    private CompilationUnitEditor fEditor;
    private IWorkbenchSite fSite;
    private String fGroupName = "group.reorganize";
    private List fRegisteredSelectionListeners;
    private OverrideMethodsAction fOverrideMethods;
    private AddGetterSetterAction fAddGetterSetter;
    private AddDelegateMethodsAction fAddDelegateMethods;
    private GenerateNewConstructorUsingFieldsAction fGenerateConstructorUsingFields;
    private AddJavaDocStubAction fAddJavaDocStub;
    private AddBookmarkAction fAddBookmark;
    private AddTaskAction fAddTaskAction;
    private ExternalizeStringsAction fExternalizeStrings;
    private AllCleanUpsAction fCleanUp;
    private FindBrokenNLSKeysAction fFindNLSProblems;
    private MultiSortMembersAction fSortMembers;
    private FormatAllAction fFormatAll;
    private static final String QUICK_MENU_ID = "org.eclipse.wst.jsdt.ui.edit.text.java.source.quickMenu";
    private JDTQuickMenuAction fQuickAccessAction;
    private IHandlerActivation fQuickAccessHandlerActivation;
    private IHandlerService fHandlerService;
    static /* synthetic */ Class class$0;

    public GenerateActionGroup(CompilationUnitEditor editor, String groupName) {
        this.fSite = editor.getSite();
        this.fEditor = editor;
        this.fGroupName = groupName;
        this.fSortMembers = new MultiSortMembersAction(editor);
        this.fSortMembers.setActionDefinitionId("org.eclipse.wst.jsdt.ui.edit.text.java.sort.members");
        editor.setAction("SortMembers", (IAction)this.fSortMembers);
        this.fAddJavaDocStub = new AddJavaDocStubAction(editor);
        this.fAddJavaDocStub.setActionDefinitionId("org.eclipse.wst.jsdt.ui.edit.text.java.add.javadoc.comment");
        editor.setAction("AddJavadocComment", (IAction)this.fAddJavaDocStub);
        this.fCleanUp = new AllCleanUpsAction(editor);
        this.fCleanUp.setActionDefinitionId("org.eclipse.wst.jsdt.ui.edit.text.java.clean.up");
        editor.setAction("CleanUp", (IAction)this.fCleanUp);
        this.installQuickAccessAction();
    }

    public GenerateActionGroup(Page page) {
        this((IWorkbenchSite)page.getSite());
    }

    public GenerateActionGroup(IViewPart part) {
        this((IWorkbenchSite)part.getSite());
    }

    private GenerateActionGroup(IWorkbenchSite site) {
        this.fSite = site;
        ISelectionProvider provider = this.fSite.getSelectionProvider();
        ISelection selection = provider.getSelection();
        this.fAddJavaDocStub = new AddJavaDocStubAction(site);
        this.fAddJavaDocStub.setActionDefinitionId("org.eclipse.wst.jsdt.ui.edit.text.java.add.javadoc.comment");
        this.fAddBookmark = new AddBookmarkAction(site.getShell());
        this.fAddBookmark.setActionDefinitionId("org.eclipse.ui.edit.addBookmark");
        this.fAddTaskAction = new AddTaskAction(site);
        this.fAddTaskAction.setActionDefinitionId("org.eclipse.ui.edit.addTask");
        this.fSortMembers = new MultiSortMembersAction(site);
        this.fSortMembers.setActionDefinitionId("org.eclipse.wst.jsdt.ui.edit.text.java.sort.members");
        this.fFormatAll = new FormatAllAction(site);
        this.fFormatAll.setActionDefinitionId("org.eclipse.wst.jsdt.ui.edit.text.java.format");
        this.fCleanUp = new AllCleanUpsAction(site);
        this.fCleanUp.setActionDefinitionId("org.eclipse.wst.jsdt.ui.edit.text.java.clean.up");
        this.fAddJavaDocStub.update(selection);
        this.fCleanUp.update(selection);
        this.fAddTaskAction.update(selection);
        this.fSortMembers.update(selection);
        this.fFormatAll.update(selection);
        if (selection instanceof IStructuredSelection) {
            IStructuredSelection ss = (IStructuredSelection)selection;
            this.fAddBookmark.selectionChanged(ss);
        } else {
            this.fAddBookmark.setEnabled(false);
        }
        this.registerSelectionListener(provider, this.fAddJavaDocStub);
        this.registerSelectionListener(provider, (ISelectionChangedListener)this.fAddBookmark);
        this.registerSelectionListener(provider, this.fFormatAll);
        this.registerSelectionListener(provider, this.fSortMembers);
        this.registerSelectionListener(provider, this.fAddTaskAction);
        this.registerSelectionListener(provider, this.fCleanUp);
        this.installQuickAccessAction();
    }

    private void installQuickAccessAction() {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.ui.handlers.IHandlerService");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        this.fHandlerService = (IHandlerService)this.fSite.getService((Class)clazz);
        if (this.fHandlerService != null) {
            this.fQuickAccessAction = new SourceQuickAccessAction(this.fEditor);
            this.fQuickAccessHandlerActivation = this.fHandlerService.activateHandler(this.fQuickAccessAction.getActionDefinitionId(), (IHandler)new ActionHandler((IAction)this.fQuickAccessAction));
        }
    }

    private void registerSelectionListener(ISelectionProvider provider, ISelectionChangedListener listener) {
        if (this.fRegisteredSelectionListeners == null) {
            this.fRegisteredSelectionListeners = new ArrayList(20);
        }
        provider.addSelectionChangedListener(listener);
        this.fRegisteredSelectionListeners.add(listener);
    }

    public void editorStateChanged() {
        Assert.isTrue((boolean)this.isEditorOwner());
    }

    public void fillActionBars(IActionBars actionBar) {
        super.fillActionBars(actionBar);
        this.setGlobalActionHandlers(actionBar);
    }

    public void fillContextMenu(IMenuManager menu) {
        super.fillContextMenu(menu);
        String menuText = ActionMessages.SourceMenu_label;
        if (this.fQuickAccessAction != null) {
            menuText = this.fQuickAccessAction.addShortcut(menuText);
        }
        MenuManager subMenu = new MenuManager(menuText, MENU_ID);
        int added = 0;
        added = this.isEditorOwner() ? this.fillEditorSubMenu((IMenuManager)subMenu) : this.fillViewSubMenu((IMenuManager)subMenu);
        if (added > 0) {
            menu.appendToGroup(this.fGroupName, (IContributionItem)subMenu);
        }
    }

    private void fillQuickMenu(IMenuManager menu) {
        if (this.isEditorOwner()) {
            this.fillEditorSubMenu(menu);
        } else {
            this.fillViewSubMenu(menu);
        }
    }

    private int fillEditorSubMenu(IMenuManager source) {
        int added = 0;
        source.add((IContributionItem)new Separator(GROUP_COMMENT));
        added += this.addEditorAction(source, "ToggleComment");
        added += this.addEditorAction(source, "AddBlockComment");
        added += this.addEditorAction(source, "RemoveBlockComment");
        added += this.addAction(source, (IAction)this.fAddJavaDocStub);
        source.add((IContributionItem)new Separator(GROUP_EDIT));
        added += this.addEditorAction(source, "Indent");
        added += this.addEditorAction(source, "Format");
        source.add((IContributionItem)new Separator(GROUP_IMPORT));
        added += this.addAction(source, (IAction)this.fSortMembers);
        source.add((IContributionItem)new Separator(GROUP_CODE));
        source.add((IContributionItem)new Separator(GROUP_EXTERNALIZE));
        return added += this.addAction(source, (IAction)this.fCleanUp);
    }

    private int fillViewSubMenu(IMenuManager source) {
        int added = 0;
        source.add((IContributionItem)new Separator(GROUP_COMMENT));
        added += this.addAction(source, (IAction)this.fAddJavaDocStub);
        source.add((IContributionItem)new Separator(GROUP_EDIT));
        added += this.addAction(source, (IAction)this.fFormatAll);
        source.add((IContributionItem)new Separator(GROUP_IMPORT));
        added += this.addAction(source, (IAction)this.fSortMembers);
        source.add((IContributionItem)new Separator(GROUP_CODE));
        source.add((IContributionItem)new Separator(GROUP_EXTERNALIZE));
        return added += this.addAction(source, (IAction)this.fCleanUp);
    }

    public void dispose() {
        if (this.fRegisteredSelectionListeners != null) {
            ISelectionProvider provider = this.fSite.getSelectionProvider();
            Iterator iter = this.fRegisteredSelectionListeners.iterator();
            while (iter.hasNext()) {
                ISelectionChangedListener listener = (ISelectionChangedListener)iter.next();
                provider.removeSelectionChangedListener(listener);
            }
        }
        if (this.fQuickAccessHandlerActivation != null && this.fHandlerService != null) {
            this.fHandlerService.deactivateHandler(this.fQuickAccessHandlerActivation);
        }
        this.fEditor = null;
        this.fCleanUp.dispose();
        super.dispose();
    }

    private void setGlobalActionHandlers(IActionBars actionBar) {
        actionBar.setGlobalActionHandler("org.eclipse.wst.jsdt.ui.actions.OverrideMethods", (IAction)this.fOverrideMethods);
        actionBar.setGlobalActionHandler("org.eclipse.wst.jsdt.ui.actions.GenerateGetterSetter", (IAction)this.fAddGetterSetter);
        actionBar.setGlobalActionHandler("org.eclipse.wst.jsdt.ui.actions.GenerateDelegateMethods", (IAction)this.fAddDelegateMethods);
        actionBar.setGlobalActionHandler("org.eclipse.wst.jsdt.ui.actions.GenerateConstructorUsingFields", (IAction)this.fGenerateConstructorUsingFields);
        actionBar.setGlobalActionHandler("org.eclipse.wst.jsdt.ui.actions.AddJavaDocComment", (IAction)this.fAddJavaDocStub);
        actionBar.setGlobalActionHandler("org.eclipse.wst.jsdt.ui.actions.ExternalizeStrings", (IAction)this.fExternalizeStrings);
        actionBar.setGlobalActionHandler("org.eclipse.wst.jsdt.ui.actions.CleanUp", (IAction)this.fCleanUp);
        actionBar.setGlobalActionHandler("org.eclipse.wst.jsdt.ui.actions.FindNLSProblems", (IAction)this.fFindNLSProblems);
        actionBar.setGlobalActionHandler("org.eclipse.wst.jsdt.ui.actions.SortMembers", (IAction)this.fSortMembers);
        if (!this.isEditorOwner()) {
            actionBar.setGlobalActionHandler(IDEActionFactory.BOOKMARK.getId(), (IAction)this.fAddBookmark);
            actionBar.setGlobalActionHandler(IDEActionFactory.ADD_TASK.getId(), (IAction)this.fAddTaskAction);
            actionBar.setGlobalActionHandler("org.eclipse.wst.jsdt.ui.actions.Format", (IAction)this.fFormatAll);
        }
    }

    private int addAction(IMenuManager menu, IAction action) {
        if (action != null && action.isEnabled()) {
            menu.add(action);
            return 1;
        }
        return 0;
    }

    private int addEditorAction(IMenuManager menu, String actionID) {
        if (this.fEditor == null) {
            return 0;
        }
        IAction action = this.fEditor.getAction(actionID);
        if (action == null) {
            return 0;
        }
        if (action instanceof IUpdate) {
            ((IUpdate)action).update();
        }
        if (action.isEnabled()) {
            menu.add(action);
            return 1;
        }
        return 0;
    }

    private boolean isEditorOwner() {
        return this.fEditor != null;
    }

    private class SourceQuickAccessAction
    extends JDTQuickMenuAction {
        public SourceQuickAccessAction(CompilationUnitEditor editor) {
            super(editor, GenerateActionGroup.QUICK_MENU_ID);
        }

        protected void fillMenu(IMenuManager menu) {
            GenerateActionGroup.this.fillQuickMenu(menu);
        }
    }
}

