/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.j2ee.project;

import java.util.Properties;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.jst.j2ee.internal.componentcore.JavaEEBinaryComponentHelper;
import org.eclipse.jst.j2ee.internal.plugin.J2EEPlugin;
import org.eclipse.jst.j2ee.model.ModelProviderManager;
import org.eclipse.jst.j2ee.project.JavaEEProjectUtilities;
import org.eclipse.jst.javaee.ejb.EJBJar;
import org.eclipse.jst.jee.archive.ArchiveModelLoadException;
import org.eclipse.jst.jee.archive.IArchive;
import org.eclipse.wst.common.componentcore.ComponentCore;
import org.eclipse.wst.common.componentcore.resources.IVirtualComponent;
import org.eclipse.wst.common.componentcore.resources.IVirtualReference;

public class EJBUtilities
extends JavaEEProjectUtilities {
    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static IVirtualComponent getEJBClientJar(IVirtualComponent ejbComponent) {
        if (!ejbComponent.isBinary()) {
            return EJBUtilities.getEJBClientJar(ejbComponent.getProject());
        }
        if (!ejbComponent.isBinary()) return null;
        JavaEEBinaryComponentHelper helper = null;
        try {
            IArchive archive;
            block17: {
                helper = new JavaEEBinaryComponentHelper(ejbComponent);
                archive = null;
                try {
                    archive = helper.accessArchive();
                    Path ddPath = new Path("META-INF/ejb-jar.xml");
                    if (!archive.containsArchiveResource((IPath)ddPath)) break block17;
                    Object jar = archive.getModelObject((IPath)ddPath);
                    String clientJAR = null;
                    if (jar != null) {
                        if (jar instanceof org.eclipse.jst.j2ee.ejb.EJBJar) {
                            clientJAR = ((org.eclipse.jst.j2ee.ejb.EJBJar)jar).getEjbClientJar();
                        } else if (jar instanceof EJBJar) {
                            clientJAR = ((EJBJar)jar).getEjbClientJar();
                        }
                    }
                    if (clientJAR == null) break block17;
                    IVirtualComponent earComponent = ComponentCore.createComponent((IProject)ejbComponent.getProject());
                    IVirtualReference[] refs = earComponent.getReferences();
                    int i = 0;
                    while (i < refs.length) {
                        if (refs[i].getArchiveName().equals(clientJAR)) {
                            IVirtualComponent iVirtualComponent = refs[i].getReferencedComponent();
                            if (archive == null) return iVirtualComponent;
                            helper.releaseArchive(archive);
                            return iVirtualComponent;
                        }
                        ++i;
                    }
                }
                catch (Throwable throwable) {
                    if (archive == null) throw throwable;
                    helper.releaseArchive(archive);
                    throw throwable;
                }
                {
                    catch (ArchiveModelLoadException e) {
                        J2EEPlugin.logError(e);
                        if (archive == null) return null;
                        helper.releaseArchive(archive);
                        return null;
                        break;
                    }
                }
            }
            if (archive == null) return null;
            helper.releaseArchive(archive);
            return null;
        }
        finally {
            if (helper != null) {
                helper.dispose();
            }
        }
    }

    public static IVirtualComponent getEJBClientJar(IProject ejbProject) {
        Object jar = ModelProviderManager.getModelProvider(ejbProject).getModelObject();
        IVirtualComponent ejbClientComponent = null;
        IVirtualComponent ejbComponent = ComponentCore.createComponent((IProject)ejbProject);
        if (ejbComponent == null) {
            return null;
        }
        Properties props = ejbComponent.getMetaProperties();
        String clientCompName = props.getProperty("ClientProject");
        if (clientCompName != null && !clientCompName.equals("")) {
            IVirtualReference vRef = ejbComponent.getReference(clientCompName);
            if (vRef != null) {
                ejbClientComponent = vRef.getReferencedComponent();
            }
        } else {
            String clientJAR = null;
            if (jar != null) {
                if (jar instanceof org.eclipse.jst.j2ee.ejb.EJBJar) {
                    clientJAR = ((org.eclipse.jst.j2ee.ejb.EJBJar)jar).getEjbClientJar();
                } else if (jar instanceof EJBJar) {
                    clientJAR = ((EJBJar)jar).getEjbClientJar();
                }
            }
            if (clientJAR != null) {
                clientJAR = clientJAR.substring(0, clientJAR.length() - 4);
                ejbComponent = ComponentCore.createComponent((IProject)ejbProject);
                if (ejbComponent == null) {
                    return null;
                }
                IVirtualReference ref = ejbComponent.getReference(clientJAR);
                if (ref != null) {
                    ejbClientComponent = ref.getReferencedComponent();
                }
            }
        }
        return ejbClientComponent;
    }

    public static boolean hasEJBClientJARProject(IProject ejbProject) {
        return EJBUtilities.getEJBClientJar(ejbProject) != null;
    }
}

