/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.ui.wizards.buildpaths;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.dialogs.TrayDialog;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.INewWizard;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.model.BaseWorkbenchContentProvider;
import org.eclipse.ui.model.WorkbenchLabelProvider;
import org.eclipse.wst.jsdt.core.IJavaScriptProject;
import org.eclipse.wst.jsdt.internal.corext.util.Messages;
import org.eclipse.wst.jsdt.internal.ui.wizards.NewWizardMessages;
import org.eclipse.wst.jsdt.internal.ui.wizards.TypedViewerFilter;
import org.eclipse.wst.jsdt.internal.ui.wizards.buildpaths.AddSourceFolderWizard;
import org.eclipse.wst.jsdt.internal.ui.wizards.buildpaths.BuildPathBasePage;
import org.eclipse.wst.jsdt.internal.ui.wizards.buildpaths.CPListElement;
import org.eclipse.wst.jsdt.internal.ui.wizards.buildpaths.MultipleFolderSelectionDialog;
import org.eclipse.wst.jsdt.ui.PreferenceConstants;
import org.eclipse.wst.jsdt.ui.actions.AbstractOpenWizardAction;

public class CreateMultipleSourceFoldersDialog
extends TrayDialog {
    private final IJavaScriptProject fJavaProject;
    private final CPListElement[] fExistingElements;
    private String fOutputLocation;
    private final HashSet fRemovedElements;
    private final HashSet fModifiedElements;
    private final HashSet fInsertedElements;
    private final Hashtable fNonExistingFolders;
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;

    public CreateMultipleSourceFoldersDialog(IJavaScriptProject javaProject, CPListElement[] existingElements, String outputLocation, Shell shell) {
        super(shell);
        this.fJavaProject = javaProject;
        this.fExistingElements = existingElements;
        this.fOutputLocation = outputLocation;
        this.fRemovedElements = new HashSet();
        this.fModifiedElements = new HashSet();
        this.fInsertedElements = new HashSet();
        this.fNonExistingFolders = new Hashtable();
        int i = 0;
        while (i < existingElements.length) {
            CPListElement cur = existingElements[i];
            if (cur.getResource() == null || !cur.getResource().exists()) {
                this.addFakeFolder((IContainer)this.fJavaProject.getProject(), cur);
            }
            ++i;
        }
    }

    public int open() {
        Class[] classArray = new Class[2];
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.core.resources.IProject");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        classArray[0] = clazz;
        Class<?> clazz2 = class$1;
        if (clazz2 == null) {
            try {
                clazz2 = class$1 = Class.forName("org.eclipse.core.resources.IFolder");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        classArray[1] = clazz2;
        Class[] acceptedClasses = classArray;
        List existingContainers = this.getExistingContainers(this.fExistingElements);
        IProject[] allProjects = ResourcesPlugin.getWorkspace().getRoot().getProjects();
        ArrayList<IProject> rejectedElements = new ArrayList<IProject>(allProjects.length);
        IProject currProject = this.fJavaProject.getProject();
        int i = 0;
        while (i < allProjects.length) {
            if (!allProjects[i].equals((Object)currProject)) {
                rejectedElements.add(allProjects[i]);
            }
            ++i;
        }
        TypedViewerFilter filter = new TypedViewerFilter(acceptedClasses, rejectedElements.toArray());
        WorkbenchLabelProvider lp = new WorkbenchLabelProvider();
        FakeFolderBaseWorkbenchContentProvider cp = new FakeFolderBaseWorkbenchContentProvider();
        String title = NewWizardMessages.SourceContainerWorkbookPage_ExistingSourceFolderDialog_new_title;
        String message = NewWizardMessages.SourceContainerWorkbookPage_ExistingSourceFolderDialog_edit_description;
        MultipleFolderSelectionDialog dialog = new MultipleFolderSelectionDialog(this.getShell(), (ILabelProvider)lp, (ITreeContentProvider)cp){

            protected Control createDialogArea(Composite parent) {
                Control result = super.createDialogArea(parent);
                PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)parent, "org.eclipse.wst.jsdt.ui.bp_choose_existing_folder_to_make_source_folder");
                return result;
            }

            protected Object createFolder(IContainer container) {
                Object[] result = new Object[1];
                CPListElement newElement = new CPListElement(CreateMultipleSourceFoldersDialog.this.fJavaProject, 3);
                AddSourceFolderWizard wizard = CreateMultipleSourceFoldersDialog.this.newSourceFolderWizard(newElement, CreateMultipleSourceFoldersDialog.this.fExistingElements, CreateMultipleSourceFoldersDialog.this.fOutputLocation, container);
                AbstractOpenWizardAction action = new AbstractOpenWizardAction(this, wizard){
                    final /* synthetic */ 1 this$1;
                    private final /* synthetic */ AddSourceFolderWizard val$wizard;
                    {
                        this.this$1 = var1_1;
                        this.val$wizard = addSourceFolderWizard;
                    }

                    protected INewWizard createWizard() throws CoreException {
                        return this.val$wizard;
                    }
                };
                action.addPropertyChangeListener(new IPropertyChangeListener(this, result, newElement, wizard){
                    final /* synthetic */ 1 this$1;
                    private final /* synthetic */ Object[] val$result;
                    private final /* synthetic */ CPListElement val$newElement;
                    private final /* synthetic */ AddSourceFolderWizard val$wizard;
                    {
                        this.this$1 = var1_1;
                        this.val$result = objectArray;
                        this.val$newElement = cPListElement;
                        this.val$wizard = addSourceFolderWizard;
                    }

                    public void propertyChange(PropertyChangeEvent event) {
                        if (event.getProperty().equals("result")) {
                            if (event.getNewValue().equals(Boolean.TRUE)) {
                                this.val$result[0] = CreateMultipleSourceFoldersDialog.access$5(1.access$0(this.this$1), (IContainer)CreateMultipleSourceFoldersDialog.access$1(1.access$0(this.this$1)).getProject(), this.val$newElement);
                            } else {
                                this.val$wizard.cancel();
                            }
                        }
                    }
                });
                action.run();
                return result[0];
            }

            static /* synthetic */ CreateMultipleSourceFoldersDialog access$0(1 var0) {
                return var0.CreateMultipleSourceFoldersDialog.this;
            }
        };
        dialog.setExisting(existingContainers.toArray());
        dialog.setTitle(title);
        dialog.setMessage(message);
        dialog.addFilter(filter);
        dialog.setInput(this.fJavaProject.getProject().getParent());
        dialog.setInitialFocus(this.fJavaProject.getProject());
        if (dialog.open() == 0) {
            Object[] elements = dialog.getResult();
            int i2 = 0;
            while (i2 < elements.length) {
                IResource res = (IResource)elements[i2];
                this.fInsertedElements.add(new CPListElement(this.fJavaProject, 3, res.getFullPath(), res));
                ++i2;
            }
            if (this.fExistingElements.length == 1) {
                CPListElement existingElement = this.fExistingElements[0];
                if (existingElement.getResource() instanceof IProject && !this.removeProjectFromBP(existingElement)) {
                    ArrayList added = new ArrayList(this.fInsertedElements);
                    HashSet updatedEclusionPatterns = new HashSet();
                    this.addExlusionPatterns(added, updatedEclusionPatterns);
                    this.fModifiedElements.addAll(updatedEclusionPatterns);
                }
            } else {
                ArrayList added = new ArrayList(this.fInsertedElements);
                HashSet updatedEclusionPatterns = new HashSet();
                this.addExlusionPatterns(added, updatedEclusionPatterns);
                this.fModifiedElements.addAll(updatedEclusionPatterns);
            }
            return 0;
        }
        return 1;
    }

    public List getInsertedElements() {
        return new ArrayList(this.fInsertedElements);
    }

    public List getRemovedElements() {
        return new ArrayList(this.fRemovedElements);
    }

    public List getModifiedElements() {
        return new ArrayList(this.fModifiedElements);
    }

    public IPath getOutputLocation() {
        return new Path(this.fOutputLocation).makeAbsolute();
    }

    private boolean removeProjectFromBP(CPListElement existing) {
        String message;
        Path outputFolder = new Path(this.fOutputLocation);
        IPath newOutputFolder = null;
        if (outputFolder.segmentCount() == 1) {
            String outputFolderName = PreferenceConstants.getPreferenceStore().getString("org.eclipse.wst.jsdt.ui.wizards.srcBinFoldersBinName");
            newOutputFolder = outputFolder.append(outputFolderName);
            message = Messages.format(NewWizardMessages.SourceContainerWorkbookPage_ChangeOutputLocationDialog_project_and_output_message, newOutputFolder);
        } else {
            message = NewWizardMessages.SourceContainerWorkbookPage_ChangeOutputLocationDialog_project_message;
        }
        String title = NewWizardMessages.SourceContainerWorkbookPage_ChangeOutputLocationDialog_title;
        if (MessageDialog.openQuestion((Shell)this.getShell(), (String)title, (String)message)) {
            this.fRemovedElements.add(existing);
            if (newOutputFolder != null) {
                this.fOutputLocation = newOutputFolder.toString();
            }
            return true;
        }
        return false;
    }

    private void addExlusionPatterns(List newEntries, Set modifiedEntries) {
        BuildPathBasePage.fixNestingConflicts(newEntries.toArray(new CPListElement[newEntries.size()]), this.fExistingElements, modifiedEntries);
        if (!modifiedEntries.isEmpty()) {
            String title = NewWizardMessages.SourceContainerWorkbookPage_exclusion_added_title;
            String message = NewWizardMessages.SourceContainerWorkbookPage_exclusion_added_message;
            MessageDialog.openInformation((Shell)this.getShell(), (String)title, (String)message);
        }
    }

    private AddSourceFolderWizard newSourceFolderWizard(CPListElement element, CPListElement[] existing, String outputLocation, IContainer parent) {
        AddSourceFolderWizard wizard = new AddSourceFolderWizard(existing, element, new Path(outputLocation).makeAbsolute(), false, true, false, false, false, parent);
        wizard.setDoFlushChange(false);
        return wizard;
    }

    private List getExistingContainers(CPListElement[] existingElements) {
        ArrayList<Object> res = new ArrayList<Object>();
        int i = 0;
        while (i < existingElements.length) {
            IResource resource = existingElements[i].getResource();
            if (resource instanceof IContainer) {
                res.add(resource);
            }
            ++i;
        }
        Set keys = this.fNonExistingFolders.keySet();
        Iterator iter = keys.iterator();
        while (iter.hasNext()) {
            IFolder folder = (IFolder)iter.next();
            res.add(folder);
        }
        return res;
    }

    private IFolder addFakeFolder(IContainer container, CPListElement element) {
        IContainer parent;
        IFolder result;
        IPath path;
        IPath projectPath = this.fJavaProject.getPath();
        if (projectPath.isPrefixOf(path = element.getPath())) {
            path = path.removeFirstSegments(projectPath.segmentCount());
        }
        Object folder = result = container.getFolder(path);
        do {
            parent = folder.getParent();
            this.fNonExistingFolders.put(folder, parent);
        } while ((folder = parent instanceof IFolder ? (IFolder)parent : null) != null && !folder.exists());
        return result;
    }

    static /* synthetic */ IFolder access$5(CreateMultipleSourceFoldersDialog createMultipleSourceFoldersDialog, IContainer iContainer, CPListElement cPListElement) {
        return createMultipleSourceFoldersDialog.addFakeFolder(iContainer, cPListElement);
    }

    private final class FakeFolderBaseWorkbenchContentProvider
    extends BaseWorkbenchContentProvider {
        private FakeFolderBaseWorkbenchContentProvider() {
        }

        public Object getParent(Object element) {
            Object object = CreateMultipleSourceFoldersDialog.this.fNonExistingFolders.get(element);
            if (object != null) {
                return object;
            }
            return super.getParent(element);
        }

        public Object[] getChildren(Object element) {
            ArrayList<Object> result = new ArrayList<Object>();
            Set keys = CreateMultipleSourceFoldersDialog.this.fNonExistingFolders.keySet();
            Iterator iter = keys.iterator();
            while (iter.hasNext()) {
                Object key = iter.next();
                if (!CreateMultipleSourceFoldersDialog.this.fNonExistingFolders.get(key).equals(element)) continue;
                result.add(key);
            }
            if (result.size() == 0) {
                return super.getChildren(element);
            }
            Object[] children = super.getChildren(element);
            int i = 0;
            while (i < children.length) {
                result.add(children[i]);
                ++i;
            }
            return result.toArray();
        }
    }
}

