/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.ui.preferences;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.core.commands.Command;
import org.eclipse.core.commands.CommandManager;
import org.eclipse.core.commands.IParameter;
import org.eclipse.core.commands.Parameterization;
import org.eclipse.core.commands.ParameterizedCommand;
import org.eclipse.core.commands.common.NotDefinedException;
import org.eclipse.core.commands.contexts.ContextManager;
import org.eclipse.core.runtime.Assert;
import org.eclipse.jface.bindings.BindingManager;
import org.eclipse.jface.bindings.Scheme;
import org.eclipse.jface.bindings.TriggerSequence;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.CheckStateChangedEvent;
import org.eclipse.jface.viewers.CheckboxTableViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ICheckStateListener;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Link;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.commands.ICommandService;
import org.eclipse.ui.dialogs.PreferencesUtil;
import org.eclipse.ui.keys.IBindingService;
import org.eclipse.ui.preferences.IWorkbenchPreferenceContainer;
import org.eclipse.wst.jsdt.internal.corext.util.Messages;
import org.eclipse.wst.jsdt.internal.ui.JavaScriptPlugin;
import org.eclipse.wst.jsdt.internal.ui.dialogs.StatusInfo;
import org.eclipse.wst.jsdt.internal.ui.preferences.OptionsConfigurationBlock;
import org.eclipse.wst.jsdt.internal.ui.preferences.PreferencesMessages;
import org.eclipse.wst.jsdt.internal.ui.preferences.ScrolledPageContent;
import org.eclipse.wst.jsdt.internal.ui.text.java.CompletionProposalCategory;
import org.eclipse.wst.jsdt.internal.ui.text.java.CompletionProposalComputerRegistry;
import org.eclipse.wst.jsdt.internal.ui.util.PixelConverter;
import org.eclipse.wst.jsdt.internal.ui.util.SWTUtil;
import org.eclipse.wst.jsdt.internal.ui.wizards.IStatusChangeListener;

final class CodeAssistAdvancedConfigurationBlock
extends OptionsConfigurationBlock {
    private static final OptionsConfigurationBlock.Key PREF_EXCLUDED_CATEGORIES;
    private static final OptionsConfigurationBlock.Key PREF_CATEGORY_ORDER;
    private static final OptionsConfigurationBlock.Key PREF_CODEASSIST_TIMEOUT_FOR_PARAMETER_NAME_FROM_ATTACHED_JAVADOC;
    private final Comparator fCategoryComparator = new Comparator(){

        private int getRank(Object o) {
            return ((ModelElement)o).getRank();
        }

        public int compare(Object o1, Object o2) {
            return this.getRank(o1) - this.getRank(o2);
        }
    };
    private final PreferenceModel fModel;
    private final Map fImages = new HashMap();
    private CheckboxTableViewer fDefaultViewer;
    private CheckboxTableViewer fSeparateViewer;
    private Button fUpButton;
    private Button fDownButton;
    private static BindingManager fgLocalBindingManager;
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;

    static {
        IBindingService bindingService;
        Scheme[] definedSchemes;
        PREF_EXCLUDED_CATEGORIES = CodeAssistAdvancedConfigurationBlock.getJDTUIKey("content_assist_disabled_computers");
        PREF_CATEGORY_ORDER = CodeAssistAdvancedConfigurationBlock.getJDTUIKey("content_assist_category_order");
        PREF_CODEASSIST_TIMEOUT_FOR_PARAMETER_NAME_FROM_ATTACHED_JAVADOC = CodeAssistAdvancedConfigurationBlock.getJDTCoreKey("org.eclipse.wst.jsdt.core.timeoutForParameterNameFromAttachedJavadoc");
        fgLocalBindingManager = new BindingManager(new ContextManager(), new CommandManager());
        IWorkbench iWorkbench = PlatformUI.getWorkbench();
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.ui.keys.IBindingService");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if ((definedSchemes = (bindingService = (IBindingService)iWorkbench.getService((Class)clazz)).getDefinedSchemes()) != null) {
            try {
                int i = 0;
                while (i < definedSchemes.length) {
                    Scheme scheme = definedSchemes[i];
                    Scheme copy = fgLocalBindingManager.getScheme(scheme.getId());
                    copy.define(scheme.getName(), scheme.getDescription(), scheme.getParentId());
                    ++i;
                }
            }
            catch (NotDefinedException e) {
                JavaScriptPlugin.log(e);
            }
        }
        fgLocalBindingManager.setLocale(bindingService.getLocale());
        fgLocalBindingManager.setPlatform(bindingService.getPlatform());
    }

    private static OptionsConfigurationBlock.Key[] getAllKeys() {
        return new OptionsConfigurationBlock.Key[]{PREF_EXCLUDED_CATEGORIES, PREF_CATEGORY_ORDER, PREF_CODEASSIST_TIMEOUT_FOR_PARAMETER_NAME_FROM_ATTACHED_JAVADOC};
    }

    CodeAssistAdvancedConfigurationBlock(IStatusChangeListener statusListener, IWorkbenchPreferenceContainer container) {
        super(statusListener, null, CodeAssistAdvancedConfigurationBlock.getAllKeys(), container);
        this.fModel = new PreferenceModel(CompletionProposalComputerRegistry.getDefault());
    }

    protected Control createContents(Composite parent) {
        ScrolledPageContent scrolled = new ScrolledPageContent(parent, 768);
        scrolled.setExpandHorizontal(true);
        scrolled.setExpandVertical(true);
        Composite composite = new Composite((Composite)scrolled, 0);
        int columns = 2;
        GridLayout layout = new GridLayout(columns, false);
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        composite.setLayout((Layout)layout);
        this.createDefaultLabel(composite, columns);
        this.createDefaultViewer(composite, columns);
        this.createKeysLink(composite, columns);
        this.createFiller(composite, columns);
        this.createSeparateLabel(composite, columns);
        this.createSeparateSection(composite);
        this.createFiller(composite, columns);
        this.createParameterTimeoutControl(composite, columns);
        this.updateControls();
        if (this.fModel.elements.size() > 0) {
            this.fDefaultViewer.getTable().select(0);
            this.fSeparateViewer.getTable().select(0);
            this.handleTableSelection();
        }
        scrolled.setContent((Control)composite);
        scrolled.setMinSize(composite.computeSize(-1, -1));
        return scrolled;
    }

    private void createDefaultLabel(Composite composite, int h_span) {
        ICommandService commandSvc;
        Command command;
        ParameterizedCommand pCmd;
        String key;
        IWorkbench iWorkbench = PlatformUI.getWorkbench();
        Class<?> clazz = class$1;
        if (clazz == null) {
            try {
                clazz = class$1 = Class.forName("org.eclipse.ui.commands.ICommandService");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if ((key = CodeAssistAdvancedConfigurationBlock.getKeyboardShortcut(pCmd = new ParameterizedCommand(command = (commandSvc = (ICommandService)iWorkbench.getAdapter((Class)clazz)).getCommand("org.eclipse.ui.edit.text.contentAssist.proposals"), null))) == null) {
            key = PreferencesMessages.CodeAssistAdvancedConfigurationBlock_no_shortcut;
        }
        PixelConverter pixelConverter = new PixelConverter((Control)composite);
        int width = pixelConverter.convertWidthInCharsToPixels(40);
        Label label = new Label(composite, 64);
        label.setText(Messages.format(PreferencesMessages.CodeAssistAdvancedConfigurationBlock_page_description, new Object[]{key}));
        GridData gd = new GridData(4, 4, true, false, h_span, 1);
        gd.widthHint = width;
        label.setLayoutData((Object)gd);
        this.createFiller(composite, h_span);
        label = new Label(composite, 64);
        label.setText(PreferencesMessages.CodeAssistAdvancedConfigurationBlock_default_table_description);
        gd = new GridData(4, 4, true, false, h_span, 1);
        gd.widthHint = width;
        label.setLayoutData((Object)gd);
    }

    private void createDefaultViewer(Composite composite, int h_span) {
        this.fDefaultViewer = CheckboxTableViewer.newCheckList((Composite)composite, (int)2052);
        Table table = this.fDefaultViewer.getTable();
        table.setHeaderVisible(true);
        table.setLinesVisible(false);
        table.setLayoutData((Object)new GridData(4, 1, false, false, h_span, 1));
        TableColumn nameColumn = new TableColumn(table, 0);
        nameColumn.setText(PreferencesMessages.CodeAssistAdvancedConfigurationBlock_default_table_category_column_title);
        nameColumn.setResizable(false);
        TableColumn keyColumn = new TableColumn(table, 0);
        keyColumn.setText(PreferencesMessages.CodeAssistAdvancedConfigurationBlock_default_table_keybinding_column_title);
        keyColumn.setResizable(false);
        this.fDefaultViewer.addCheckStateListener(new ICheckStateListener(){

            public void checkStateChanged(CheckStateChangedEvent event) {
                boolean checked = event.getChecked();
                ModelElement element = (ModelElement)event.getElement();
                element.setInDefaultCategory(checked);
            }
        });
        this.fDefaultViewer.setContentProvider((IContentProvider)new ArrayContentProvider());
        DefaultTableLabelProvider labelProvider = new DefaultTableLabelProvider();
        this.fDefaultViewer.setLabelProvider((IBaseLabelProvider)labelProvider);
        this.fDefaultViewer.setInput((Object)this.fModel.elements);
        this.fDefaultViewer.setComparator(new ViewerComparator());
        int minNameWidth = this.computeWidth((Control)table, nameColumn.getText()) + 20;
        int minKeyWidth = this.computeWidth((Control)table, keyColumn.getText()) + 20;
        int i = 0;
        while (i < this.fModel.elements.size()) {
            minNameWidth = Math.max(minNameWidth, this.computeWidth((Control)table, labelProvider.getColumnText(this.fModel.elements.get(i), 0)) + 50);
            minKeyWidth = Math.max(minKeyWidth, this.computeWidth((Control)table, labelProvider.getColumnText(this.fModel.elements.get(i), 1)));
            ++i;
        }
        nameColumn.setWidth(minNameWidth);
        keyColumn.setWidth(minKeyWidth);
    }

    private void createKeysLink(Composite composite, int h_span) {
        Link link = new Link(composite, 64);
        link.setText(PreferencesMessages.CodeAssistAdvancedConfigurationBlock_key_binding_hint);
        link.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                PreferencesUtil.createPreferenceDialogOn((Shell)CodeAssistAdvancedConfigurationBlock.this.getShell(), (String)e.text, null, null);
            }
        });
        PixelConverter pixelConverter = new PixelConverter((Control)composite);
        int width = pixelConverter.convertWidthInCharsToPixels(40);
        GridData gd = new GridData(4, 4, false, false, h_span, 1);
        gd.widthHint = width;
        link.setLayoutData((Object)gd);
    }

    private void createFiller(Composite composite, int h_span) {
        Label filler = new Label(composite, 0);
        filler.setVisible(false);
        filler.setLayoutData((Object)new GridData(4, 4, false, false, h_span, 1));
    }

    private void createSeparateLabel(Composite composite, int h_span) {
        PixelConverter pixelConverter = new PixelConverter((Control)composite);
        int width = pixelConverter.convertWidthInCharsToPixels(40);
        Label label = new Label(composite, 64);
        label.setText(PreferencesMessages.CodeAssistAdvancedConfigurationBlock_separate_table_description);
        GridData gd = new GridData(4, 4, false, false, h_span, 1);
        gd.widthHint = width;
        label.setLayoutData((Object)gd);
    }

    private void createSeparateSection(Composite composite) {
        this.createSeparateViewer(composite);
        this.createButtonList(composite);
    }

    private void createSeparateViewer(Composite composite) {
        this.fSeparateViewer = CheckboxTableViewer.newCheckList((Composite)composite, (int)2052);
        Table table = this.fSeparateViewer.getTable();
        table.setHeaderVisible(false);
        table.setLinesVisible(false);
        table.setLayoutData((Object)new GridData(4, 1, true, false, 1, 1));
        TableColumn nameColumn = new TableColumn(table, 0);
        nameColumn.setText(PreferencesMessages.CodeAssistAdvancedConfigurationBlock_separate_table_category_column_title);
        nameColumn.setResizable(false);
        this.fSeparateViewer.setContentProvider((IContentProvider)new ArrayContentProvider());
        SeparateTableLabelProvider labelProvider = new SeparateTableLabelProvider();
        this.fSeparateViewer.setLabelProvider((IBaseLabelProvider)labelProvider);
        this.fSeparateViewer.setInput((Object)this.fModel.elements);
        int minNameWidth = this.computeWidth((Control)table, nameColumn.getText()) + 20;
        int i = 0;
        while (i < this.fModel.elements.size()) {
            minNameWidth = Math.max(minNameWidth, this.computeWidth((Control)table, labelProvider.getColumnText(this.fModel.elements.get(i), 0)) + 50);
            ++i;
        }
        nameColumn.setWidth(minNameWidth);
        this.fSeparateViewer.addCheckStateListener(new ICheckStateListener(){

            public void checkStateChanged(CheckStateChangedEvent event) {
                boolean checked = event.getChecked();
                ModelElement element = (ModelElement)event.getElement();
                element.setSeparateCommand(checked);
            }
        });
        table.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                CodeAssistAdvancedConfigurationBlock.this.handleTableSelection();
            }
        });
    }

    private void createButtonList(Composite parent) {
        Composite composite = new Composite(parent, 0);
        composite.setLayoutData((Object)new GridData(1, 1, false, false));
        GridLayout layout = new GridLayout();
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        composite.setLayout((Layout)layout);
        this.fUpButton = new Button(composite, 0x1000008);
        this.fUpButton.setText(PreferencesMessages.CodeAssistAdvancedConfigurationBlock_Up);
        this.fUpButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                int index = CodeAssistAdvancedConfigurationBlock.this.getSelectionIndex();
                if (index != -1) {
                    ((ModelElement)((CodeAssistAdvancedConfigurationBlock)CodeAssistAdvancedConfigurationBlock.this).fModel.elements.get(index)).moveUp();
                    CodeAssistAdvancedConfigurationBlock.this.fSeparateViewer.refresh();
                    CodeAssistAdvancedConfigurationBlock.this.handleTableSelection();
                }
            }
        });
        this.fUpButton.setLayoutData((Object)new GridData());
        SWTUtil.setButtonDimensionHint(this.fUpButton);
        this.fDownButton = new Button(composite, 0x1000008);
        this.fDownButton.setText(PreferencesMessages.CodeAssistAdvancedConfigurationBlock_Down);
        this.fDownButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                int index = CodeAssistAdvancedConfigurationBlock.this.getSelectionIndex();
                if (index != -1) {
                    ((ModelElement)((CodeAssistAdvancedConfigurationBlock)CodeAssistAdvancedConfigurationBlock.this).fModel.elements.get(index)).moveDown();
                    CodeAssistAdvancedConfigurationBlock.this.fSeparateViewer.refresh();
                    CodeAssistAdvancedConfigurationBlock.this.handleTableSelection();
                }
            }
        });
        this.fDownButton.setLayoutData((Object)new GridData());
        SWTUtil.setButtonDimensionHint(this.fDownButton);
    }

    private void createParameterTimeoutControl(Composite composite, int h_span) {
        Composite timeoutComposite = new Composite(composite, 0);
        GridLayout layout = new GridLayout(4, false);
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        timeoutComposite.setLayout((Layout)layout);
        GridData gd = new GridData(4, 4, true, false, h_span, 1);
        timeoutComposite.setLayoutData((Object)gd);
        PixelConverter pixelConverter = new PixelConverter((Control)composite);
        String str = PreferencesMessages.CodeAssistAdvancedConfigurationBlock_parameterNameFromAttachedJavadoc_timeout;
        this.addTextField(timeoutComposite, str, PREF_CODEASSIST_TIMEOUT_FOR_PARAMETER_NAME_FROM_ATTACHED_JAVADOC, 0, pixelConverter.convertWidthInCharsToPixels(7));
        Label ms = new Label(timeoutComposite, 0);
        gd = new GridData();
        ms.setLayoutData((Object)gd);
        ms.setText(PreferencesMessages.CodeAssistAdvancedConfigurationBlock_parameterNameFromAttachedJavadoc_timeout_ms);
    }

    private void handleTableSelection() {
        ModelElement item = this.getSelectedItem();
        if (item != null) {
            int index = this.getSelectionIndex();
            this.fUpButton.setEnabled(index > 0);
            this.fDownButton.setEnabled(index < this.fModel.elements.size() - 1);
        } else {
            this.fUpButton.setEnabled(false);
            this.fDownButton.setEnabled(false);
        }
    }

    private ModelElement getSelectedItem() {
        return (ModelElement)((IStructuredSelection)this.fSeparateViewer.getSelection()).getFirstElement();
    }

    private int getSelectionIndex() {
        return this.fSeparateViewer.getTable().getSelectionIndex();
    }

    protected void updateControls() {
        super.updateControls();
        this.fModel.update();
        this.updateCheckedState();
        this.fDefaultViewer.refresh();
        this.fSeparateViewer.refresh();
        this.handleTableSelection();
    }

    private void updateCheckedState() {
        int size = this.fModel.elements.size();
        ArrayList<ModelElement> defaultChecked = new ArrayList<ModelElement>(size);
        ArrayList<ModelElement> separateChecked = new ArrayList<ModelElement>(size);
        Iterator it = this.fModel.elements.iterator();
        while (it.hasNext()) {
            ModelElement element = (ModelElement)it.next();
            if (element.isInDefaultCategory()) {
                defaultChecked.add(element);
            }
            if (!element.isSeparateCommand()) continue;
            separateChecked.add(element);
        }
        this.fDefaultViewer.setCheckedElements(defaultChecked.toArray(new Object[defaultChecked.size()]));
        this.fSeparateViewer.setCheckedElements(separateChecked.toArray(new Object[separateChecked.size()]));
    }

    protected boolean processChanges(IWorkbenchPreferenceContainer container) {
        Iterator it = this.fModel.elements.iterator();
        while (it.hasNext()) {
            ModelElement item = (ModelElement)it.next();
            item.update();
        }
        return super.processChanges(container);
    }

    protected void validateSettings(OptionsConfigurationBlock.Key changedKey, String oldValue, String newValue) {
        if (changedKey == PREF_CODEASSIST_TIMEOUT_FOR_PARAMETER_NAME_FROM_ATTACHED_JAVADOC) {
            StatusInfo status = new StatusInfo();
            if (newValue.length() == 0) {
                status.setError(PreferencesMessages.CodeAssistAdvancedConfigurationBlock_parameterNameFromAttachedJavadoc_timeout_emptyInput);
            } else {
                try {
                    int number = Integer.parseInt(newValue);
                    int min = 0;
                    int max = 5000;
                    if (number < min || number > max) {
                        String msgFormat = PreferencesMessages.CodeAssistAdvancedConfigurationBlock_parameterNameFromAttachedJavadoc_timeout_invalidRange;
                        String msg = Messages.format(msgFormat, new Object[]{new Integer(min), new Integer(max)});
                        status.setError(msg);
                    }
                }
                catch (NumberFormatException numberFormatException) {
                    String msgFormat = PreferencesMessages.CodeAssistAdvancedConfigurationBlock_parameterNameFromAttachedJavadoc_timeout_invalidInput;
                    String msg = Messages.format(msgFormat, newValue);
                    status.setError(msg);
                }
            }
            this.fContext.statusChanged(status);
        }
    }

    protected String[] getFullBuildDialogStrings(boolean workspaceSettings) {
        return null;
    }

    public void dispose() {
        Iterator it = this.fImages.values().iterator();
        while (it.hasNext()) {
            Image image = (Image)it.next();
            image.dispose();
        }
        super.dispose();
    }

    private int computeWidth(Control control, String name) {
        int n;
        if (name == null) {
            return 0;
        }
        GC gc = new GC((Drawable)control);
        try {
            gc.setFont(JFaceResources.getDialogFont());
            n = gc.stringExtent((String)name).x + 10;
            Object var4_5 = null;
        }
        catch (Throwable throwable) {
            Object var4_6 = null;
            gc.dispose();
            throw throwable;
        }
        gc.dispose();
        return n;
    }

    private static String getKeyboardShortcut(ParameterizedCommand command) {
        TriggerSequence[] bindings;
        IWorkbench iWorkbench = PlatformUI.getWorkbench();
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.ui.keys.IBindingService");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        IBindingService bindingService = (IBindingService)iWorkbench.getAdapter((Class)clazz);
        fgLocalBindingManager.setBindings(bindingService.getBindings());
        try {
            Scheme activeScheme = bindingService.getActiveScheme();
            if (activeScheme != null) {
                fgLocalBindingManager.setActiveScheme(activeScheme);
            }
        }
        catch (NotDefinedException e) {
            JavaScriptPlugin.log(e);
        }
        if ((bindings = fgLocalBindingManager.getActiveBindingsDisregardingContextFor(command)).length > 0) {
            return bindings[0].format();
        }
        return null;
    }

    private Image getImage(ImageDescriptor imgDesc) {
        if (imgDesc == null) {
            return null;
        }
        Image img = (Image)this.fImages.get(imgDesc);
        if (img == null) {
            img = imgDesc.createImage(false);
            this.fImages.put(imgDesc, img);
        }
        return img;
    }

    private final class DefaultTableLabelProvider
    extends LabelProvider
    implements ITableLabelProvider {
        private DefaultTableLabelProvider() {
        }

        public Image getColumnImage(Object element, int columnIndex) {
            if (columnIndex == 0) {
                return ((ModelElement)element).getImage();
            }
            return null;
        }

        public String getColumnText(Object element, int columnIndex) {
            switch (columnIndex) {
                case 0: {
                    return ((ModelElement)element).getName();
                }
                case 1: {
                    return ((ModelElement)element).getKeybindingAsString();
                }
            }
            Assert.isTrue((boolean)false);
            return null;
        }

        public String getText(Object element) {
            return this.getColumnText(element, 0);
        }
    }

    private final class ModelElement {
        private final CompletionProposalCategory fCategory;
        private final Command fCommand;
        private final IParameter fParam;
        private final PreferenceModel fPreferenceModel;

        ModelElement(CompletionProposalCategory category, PreferenceModel model) {
            IParameter type;
            this.fCategory = category;
            IWorkbench iWorkbench = PlatformUI.getWorkbench();
            Class<?> clazz = class$1;
            if (clazz == null) {
                try {
                    clazz = class$1 = Class.forName("org.eclipse.ui.commands.ICommandService");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            ICommandService commandSvc = (ICommandService)iWorkbench.getAdapter((Class)clazz);
            this.fCommand = commandSvc.getCommand("org.eclipse.wst.jsdt.ui.specific_content_assist.command");
            try {
                type = this.fCommand.getParameters()[0];
            }
            catch (NotDefinedException notDefinedException) {
                Assert.isTrue((boolean)false);
                type = null;
            }
            this.fParam = type;
            this.fPreferenceModel = model;
        }

        Image getImage() {
            return CodeAssistAdvancedConfigurationBlock.this.getImage(this.fCategory.getImageDescriptor());
        }

        String getName() {
            return this.fCategory.getDisplayName();
        }

        String getKeybindingAsString() {
            Parameterization[] params = new Parameterization[]{new Parameterization(this.fParam, this.fCategory.getId())};
            ParameterizedCommand pCmd = new ParameterizedCommand(this.fCommand, params);
            String key = CodeAssistAdvancedConfigurationBlock.getKeyboardShortcut(pCmd);
            return key;
        }

        boolean isInDefaultCategory() {
            return this.fPreferenceModel.readInclusionPreference(this.fCategory);
        }

        void setInDefaultCategory(boolean included) {
            if (included != this.isInDefaultCategory()) {
                this.fPreferenceModel.writeInclusionPreference(this, included);
            }
        }

        String getId() {
            return this.fCategory.getId();
        }

        int getRank() {
            int rank = this.getInternalRank();
            if (rank > 65535) {
                return rank - 65535;
            }
            return rank;
        }

        void moveUp() {
            this.fPreferenceModel.moveUp(this);
        }

        void moveDown() {
            this.fPreferenceModel.moveDown(this);
        }

        private int getInternalRank() {
            return this.fPreferenceModel.readOrderPreference(this.fCategory);
        }

        boolean isSeparateCommand() {
            return this.getInternalRank() < 65535;
        }

        void setSeparateCommand(boolean separate) {
            if (separate != this.isSeparateCommand()) {
                this.fPreferenceModel.writeOrderPreference(this, separate);
            }
        }

        void update() {
            this.fCategory.setIncluded(this.isInDefaultCategory());
            int rank = this.getInternalRank();
            this.fCategory.setSortOrder(rank);
            this.fCategory.setSeparateCommand(rank < 65535);
        }
    }

    private final class PreferenceModel {
        private static final int LIMIT = 65535;
        private static final String COLON = ":";
        private static final String SEPARATOR = "\u0000";
        private final List fElements;
        final List elements;

        public PreferenceModel(CompletionProposalComputerRegistry registry) {
            List categories = registry.getProposalCategories();
            this.fElements = new ArrayList();
            Iterator it = categories.iterator();
            while (it.hasNext()) {
                CompletionProposalCategory category = (CompletionProposalCategory)it.next();
                if (!category.hasComputers()) continue;
                this.fElements.add(new ModelElement(category, this));
            }
            Collections.sort(this.fElements, CodeAssistAdvancedConfigurationBlock.this.fCategoryComparator);
            this.elements = Collections.unmodifiableList(this.fElements);
        }

        public void moveUp(ModelElement category) {
            int index = this.fElements.indexOf(category);
            if (index > 0) {
                Object item = this.fElements.remove(index);
                this.fElements.add(index - 1, item);
                this.writeOrderPreference(null, false);
            }
        }

        public void moveDown(ModelElement category) {
            int index = this.fElements.indexOf(category);
            if (index < this.fElements.size() - 1) {
                Object item = this.fElements.remove(index);
                this.fElements.add(index + 1, item);
                this.writeOrderPreference(null, false);
            }
        }

        private void writeInclusionPreference(ModelElement changed, boolean isInDefaultCategory) {
            StringBuffer buf = new StringBuffer();
            Iterator it = this.fElements.iterator();
            while (it.hasNext()) {
                boolean included;
                ModelElement item = (ModelElement)it.next();
                boolean bl = included = changed == item ? isInDefaultCategory : item.isInDefaultCategory();
                if (included) continue;
                buf.append(String.valueOf(item.getId()) + SEPARATOR);
            }
            String newValue = buf.toString();
            String oldValue = CodeAssistAdvancedConfigurationBlock.this.setValue(PREF_EXCLUDED_CATEGORIES, newValue);
            CodeAssistAdvancedConfigurationBlock.this.validateSettings(PREF_EXCLUDED_CATEGORIES, oldValue, newValue);
        }

        private void writeOrderPreference(ModelElement changed, boolean isSeparate) {
            StringBuffer buf = new StringBuffer();
            int i = 0;
            Iterator it = this.fElements.iterator();
            while (it.hasNext()) {
                ModelElement item = (ModelElement)it.next();
                boolean separate = changed == item ? isSeparate : item.isSeparateCommand();
                int rank = separate ? i : i + 65535;
                buf.append(String.valueOf(item.getId()) + COLON + rank + SEPARATOR);
                ++i;
            }
            String newValue = buf.toString();
            String oldValue = CodeAssistAdvancedConfigurationBlock.this.setValue(PREF_CATEGORY_ORDER, newValue);
            CodeAssistAdvancedConfigurationBlock.this.validateSettings(PREF_CATEGORY_ORDER, oldValue, newValue);
        }

        private boolean readInclusionPreference(CompletionProposalCategory cat) {
            String[] ids = CodeAssistAdvancedConfigurationBlock.this.getTokens(CodeAssistAdvancedConfigurationBlock.this.getValue(PREF_EXCLUDED_CATEGORIES), SEPARATOR);
            int i = 0;
            while (i < ids.length) {
                if (ids[i].equals(cat.getId())) {
                    return false;
                }
                ++i;
            }
            return true;
        }

        private int readOrderPreference(CompletionProposalCategory cat) {
            String[] sortOrderIds = CodeAssistAdvancedConfigurationBlock.this.getTokens(CodeAssistAdvancedConfigurationBlock.this.getValue(PREF_CATEGORY_ORDER), SEPARATOR);
            int i = 0;
            while (i < sortOrderIds.length) {
                String[] idAndRank = CodeAssistAdvancedConfigurationBlock.this.getTokens(sortOrderIds[i], COLON);
                if (idAndRank[0].equals(cat.getId())) {
                    return Integer.parseInt(idAndRank[1]);
                }
                ++i;
            }
            return 65536;
        }

        public void update() {
            Collections.sort(this.fElements, CodeAssistAdvancedConfigurationBlock.this.fCategoryComparator);
        }
    }

    private final class SeparateTableLabelProvider
    extends LabelProvider
    implements ITableLabelProvider {
        private SeparateTableLabelProvider() {
        }

        public Image getColumnImage(Object element, int columnIndex) {
            if (columnIndex == 0) {
                return ((ModelElement)element).getImage();
            }
            return null;
        }

        public String getColumnText(Object element, int columnIndex) {
            switch (columnIndex) {
                case 0: {
                    return ((ModelElement)element).getName();
                }
            }
            Assert.isTrue((boolean)false);
            return null;
        }
    }
}

